/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Pair;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.AppInfo;
import com.stripe.android.ErrorParser;
import com.stripe.android.FingerprintRequestFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.StripeApiRequestExecutor;
import com.stripe.android.StripeError;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Token;
import com.stripe.android.utils.ObjectUtils;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class StripeApiHandler {
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    @NonNull
    private final AnalyticsDataFactory mAnalyticsDataFactory;
    @NonNull
    private final FingerprintRequestFactory mFingerprintRequestFactory;
    @NonNull
    private final StripeNetworkUtils mNetworkUtils;
    @NonNull
    private final ApiRequestExecutor mStripeApiRequestExecutor;
    @NonNull
    private final FireAndForgetRequestExecutor mFireAndForgetRequestExecutor;
    @Nullable
    private final AppInfo mAppInfo;

    StripeApiHandler(@NonNull Context context, @Nullable AppInfo appInfo) {
        this(context.getApplicationContext(), new StripeApiRequestExecutor(), new StripeFireAndForgetRequestExecutor(), appInfo);
    }

    @VisibleForTesting
    StripeApiHandler(@NonNull Context context, @NonNull ApiRequestExecutor stripeApiRequestExecutor, @NonNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @Nullable AppInfo appInfo) {
        this(context, stripeApiRequestExecutor, fireAndForgetRequestExecutor, appInfo, new FingerprintRequestFactory(context));
    }

    @VisibleForTesting
    StripeApiHandler(@NonNull Context context, @NonNull ApiRequestExecutor stripeApiRequestExecutor, @NonNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @Nullable AppInfo appInfo, @NonNull FingerprintRequestFactory fingerprintRequestFactory) {
        this.mStripeApiRequestExecutor = stripeApiRequestExecutor;
        this.mFireAndForgetRequestExecutor = fireAndForgetRequestExecutor;
        this.mAnalyticsDataFactory = new AnalyticsDataFactory(context);
        this.mFingerprintRequestFactory = fingerprintRequestFactory;
        this.mNetworkUtils = new StripeNetworkUtils(context);
        this.mAppInfo = appInfo;
    }

    @Nullable
    PaymentIntent confirmPaymentIntent(@NonNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = confirmPaymentIntentParams.toParamMap();
        this.mNetworkUtils.addUidParamsToPaymentIntent(paramMap);
        try {
            this.fireFingerprintRequest();
            SourceParams sourceParams = confirmPaymentIntentParams.getSourceParams();
            String sourceType = sourceParams != null ? sourceParams.getType() : null;
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getPaymentIntentConfirmationParams(null, options.apiKey, sourceType), options.apiKey);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(confirmPaymentIntentParams.getClientSecret());
            StripeResponse response = this.makeApiRequest(ApiRequest.createPost(StripeApiHandler.getConfirmPaymentIntentUrl(paymentIntentId), paramMap, options, this.mAppInfo));
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentIntent retrievePaymentIntent(@NonNull String clientSecret, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getPaymentIntentRetrieveParams(null, options.apiKey), options.apiKey);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(clientSecret);
            StripeResponse response = this.makeApiRequest(ApiRequest.createGet(StripeApiHandler.getRetrievePaymentIntentUrl(paymentIntentId), this.createClientSecretParam(clientSecret), options, this.mAppInfo));
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    SetupIntent confirmSetupIntent(@NonNull ConfirmSetupIntentParams confirmSetupIntentParams, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = confirmSetupIntentParams.toParamMap();
        this.mNetworkUtils.addUidParamsToPaymentIntent(paramMap);
        try {
            this.fireFingerprintRequest();
            String setupIntentId = SetupIntent.parseIdFromClientSecret(confirmSetupIntentParams.getClientSecret());
            StripeResponse response = this.makeApiRequest(ApiRequest.createPost(StripeApiHandler.getConfirmSetupIntentUrl(setupIntentId), paramMap, options, this.mAppInfo));
            SetupIntent setupIntent = SetupIntent.fromString(response.getResponseBody());
            PaymentMethodCreateParams paymentMethodCreateParams = confirmSetupIntentParams.getPaymentMethodCreateParams();
            String paymentMethodType = paymentMethodCreateParams != null ? paymentMethodCreateParams.getTypeCode() : null;
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getSetupIntentConfirmationParams(options.apiKey, paymentMethodType), options.apiKey);
            return setupIntent;
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    SetupIntent retrieveSetupIntent(@NonNull String clientSecret, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getSetupIntentRetrieveParams(options.apiKey), options.apiKey);
            String setupIntentId = SetupIntent.parseIdFromClientSecret(Objects.requireNonNull(clientSecret));
            StripeResponse response = this.makeApiRequest(ApiRequest.createGet(StripeApiHandler.getRetrieveSetupIntentUrl(setupIntentId), this.createClientSecretParam(clientSecret), options, this.mAppInfo));
            return SetupIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source createSource(@NonNull SourceParams sourceParams, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> requestParams = sourceParams.toParamMap();
        requestParams.putAll(this.mNetworkUtils.createUidParams());
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getSourceCreationParams(null, options.apiKey, sourceParams.getType()), options.apiKey);
            StripeResponse response = this.makeApiRequest(ApiRequest.createPost(StripeApiHandler.getSourcesUrl(), requestParams, options, this.mAppInfo));
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, String> paramMap = SourceParams.createRetrieveSourceParams(clientSecret);
        try {
            StripeResponse response = this.makeApiRequest(ApiRequest.createGet(StripeApiHandler.getRetrieveSourceApiUrl(sourceId), paramMap, options, this.mAppInfo));
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentMethod createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> params = paymentMethodCreateParams.toParamMap();
        params.putAll(this.mNetworkUtils.createUidParams());
        this.fireFingerprintRequest();
        try {
            StripeResponse response = this.makeApiRequest(ApiRequest.createPost(StripeApiHandler.getPaymentMethodsUrl(), params, options, this.mAppInfo));
            PaymentMethod paymentMethod = PaymentMethod.fromString(response.getResponseBody());
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.createPaymentMethodCreationParams(options.apiKey, paymentMethod != null ? paymentMethod.id : null), options.apiKey);
            return paymentMethod;
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Token createToken(@NonNull Map<String, Object> tokenParams, @NonNull ApiRequest.Options options, @NonNull String tokenType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        try {
            List loggingTokens = (List)tokenParams.get("product_usage");
            tokenParams.remove("product_usage");
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getTokenCreationParams(loggingTokens, options.apiKey, tokenType), options.apiKey);
        }
        catch (ClassCastException classCastEx) {
            tokenParams.remove("product_usage");
        }
        return this.requestToken(StripeApiHandler.getTokensUrl(), tokenParams, options);
    }

    @Nullable
    Source addCustomerSource(@NonNull String customerId, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", sourceId);
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getAddSourceParams(productUsageTokens, publishableKey, sourceType), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getAddCustomerSourceUrl(customerId), params, ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    Source deleteCustomerSource(@NonNull String customerId, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getDeleteSourceParams(productUsageTokens, publishableKey), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createDelete(StripeApiHandler.getDeleteCustomerSourceUrl(customerId, sourceId), ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    PaymentMethod attachPaymentMethod(@NonNull String customerId, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String paymentMethodId, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customer", customerId);
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getAttachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getAttachPaymentMethodUrl(paymentMethodId), params, ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    @Nullable
    PaymentMethod detachPaymentMethod(@NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String paymentMethodId, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getDetachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(this.getDetachPaymentMethodUrl(paymentMethodId), ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    @NonNull
    List<PaymentMethod> getPaymentMethods(@NonNull String customerId, @NonNull String paymentMethodType, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        JSONArray data;
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("customer", customerId);
        queryParams.put("type", paymentMethodType);
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getDetachPaymentMethodParams(productUsageTokens, publishableKey), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createGet(StripeApiHandler.getPaymentMethodsUrl(), queryParams, ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        try {
            data = new JSONObject(response.getResponseBody()).optJSONArray("data");
        }
        catch (JSONException e) {
            return new ArrayList<PaymentMethod>();
        }
        ArrayList<PaymentMethod> paymentMethods = new ArrayList<PaymentMethod>();
        for (int i = 0; i < data.length(); ++i) {
            paymentMethods.add(PaymentMethod.fromJson(data.optJSONObject(i)));
        }
        return paymentMethods;
    }

    @Nullable
    Customer setDefaultCustomerSource(@NonNull String customerId, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("default_source", sourceId);
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getEventLoggingParams(productUsageTokens, sourceType, null, publishableKey, "default_source"), ephemeralKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getRetrieveCustomerUrl(customerId), params, ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer setCustomerShippingInfo(@NonNull String customerId, @NonNull String publishableKey, @NonNull List<String> productUsageTokens, @NonNull ShippingInformation shippingInformation, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("shipping", shippingInformation.toMap());
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.getEventLoggingParams(productUsageTokens, publishableKey, "set_shipping_info"), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getRetrieveCustomerUrl(customerId), params, ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer retrieveCustomer(@NonNull String customerId, @NonNull String ephemeralKey) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createGet(StripeApiHandler.getRetrieveCustomerUrl(customerId), ApiRequest.Options.create(ephemeralKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @NonNull
    private static Map<String, String> createVerificationParam(@NonNull String verificationId, @NonNull String userOneTimeCode) {
        HashMap<String, String> verificationMap = new HashMap<String, String>();
        verificationMap.put("id", verificationId);
        verificationMap.put("one_time_code", userOneTimeCode);
        return verificationMap;
    }

    @NonNull
    String retrieveIssuingCardPin(@NonNull String cardId, @NonNull String verificationId, @NonNull String userOneTimeCode, @NonNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("verification", StripeApiHandler.createVerificationParam(verificationId, userOneTimeCode));
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createGet(StripeApiHandler.getIssuingCardPinUrl(cardId), params, ApiRequest.Options.create(ephemeralKeySecret), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        JSONObject jsonResponse = new JSONObject(response.getResponseBody());
        return jsonResponse.getString("pin");
    }

    void updateIssuingCardPin(@NonNull String cardId, @NonNull String newPin, @NonNull String verificationId, @NonNull String userOneTimeCode, @NonNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("verification", StripeApiHandler.createVerificationParam(verificationId, userOneTimeCode));
        params.put("pin", newPin);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getIssuingCardPinUrl(cardId), params, ApiRequest.Options.create(ephemeralKeySecret), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
    }

    @NonNull
    @VisibleForTesting
    Stripe3ds2AuthResult start3ds2Auth(@NonNull Stripe3ds2AuthParams authParams, @NonNull String stripeIntentId, @NonNull String publishableKey) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException, JSONException {
        this.fireAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("3ds2_authenticate", stripeIntentId, publishableKey), publishableKey);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getApiUrl("3ds2/authenticate"), authParams.toParamMap(), ApiRequest.Options.create(publishableKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Stripe3ds2AuthResult.fromJson(new JSONObject(response.getResponseBody()));
    }

    void start3ds2Auth(@NonNull Stripe3ds2AuthParams authParams, @NonNull String stripeIntentId, @NonNull String publishableKey, @NonNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
        new Start3ds2AuthTask(this, authParams, stripeIntentId, publishableKey, callback).execute(new Void[0]);
    }

    @VisibleForTesting
    boolean complete3ds2Auth(@NonNull String sourceId, @NonNull String publishableKey) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", sourceId);
        StripeResponse response = this.fireStripeApiRequest(ApiRequest.createPost(StripeApiHandler.getApiUrl("3ds2/challenge_complete"), params, ApiRequest.Options.create(publishableKey), this.mAppInfo));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return response.isOk();
    }

    void complete3ds2Auth(@NonNull String sourceId, @NonNull String publishableKey, @NonNull ApiResultCallback<Boolean> callback) {
        new Complete3ds2AuthTask(this, sourceId, publishableKey, callback).execute(new Void[0]);
    }

    @NonNull
    static String getTokensUrl() {
        return StripeApiHandler.getApiUrl("tokens");
    }

    @NonNull
    @VisibleForTesting
    static String getSourcesUrl() {
        return StripeApiHandler.getApiUrl("sources");
    }

    @VisibleForTesting
    @NonNull
    static String getPaymentMethodsUrl() {
        return StripeApiHandler.getApiUrl("payment_methods");
    }

    @VisibleForTesting
    @NonNull
    static String getRetrievePaymentIntentUrl(@NonNull String paymentIntentId) {
        return StripeApiHandler.getApiUrl("payment_intents/%s", paymentIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getConfirmPaymentIntentUrl(@NonNull String paymentIntentId) {
        return StripeApiHandler.getApiUrl("payment_intents/%s/confirm", paymentIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveSetupIntentUrl(@NonNull String setupIntentId) {
        return StripeApiHandler.getApiUrl("setup_intents/%s", setupIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getConfirmSetupIntentUrl(@NonNull String setupIntentId) {
        return StripeApiHandler.getApiUrl("setup_intents/%s/confirm", setupIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getAddCustomerSourceUrl(@NonNull String customerId) {
        return StripeApiHandler.getApiUrl("customers/%s/sources", customerId);
    }

    @VisibleForTesting
    @NonNull
    static String getDeleteCustomerSourceUrl(@NonNull String customerId, @NonNull String sourceId) {
        return StripeApiHandler.getApiUrl("customers/%s/sources/%s", customerId, sourceId);
    }

    @VisibleForTesting
    @NonNull
    static String getAttachPaymentMethodUrl(@NonNull String paymentMethodId) {
        return StripeApiHandler.getApiUrl("payment_methods/%s/attach", paymentMethodId);
    }

    @VisibleForTesting
    @NonNull
    String getDetachPaymentMethodUrl(@NonNull String paymentMethodId) {
        return StripeApiHandler.getApiUrl("payment_methods/%s/detach", paymentMethodId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveCustomerUrl(@NonNull String customerId) {
        return StripeApiHandler.getApiUrl("customers/%s", customerId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveSourceApiUrl(@NonNull String sourceId) {
        return StripeApiHandler.getApiUrl("sources/%s", sourceId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveTokenApiUrl(@NonNull String tokenId) {
        return StripeApiHandler.getApiUrl("tokens/%s", tokenId);
    }

    @VisibleForTesting
    @NonNull
    static String getIssuingCardPinUrl(@NonNull String cardId) {
        return StripeApiHandler.getApiUrl("issuing/cards/%s/pin", cardId);
    }

    @NonNull
    private static String getApiUrl(@NonNull String path, Object ... args) {
        return StripeApiHandler.getApiUrl(String.format(Locale.ENGLISH, path, args));
    }

    @NonNull
    private static String getApiUrl(@NonNull String path) {
        return String.format(Locale.ENGLISH, "%s/v1/%s", "https://api.stripe.com", path);
    }

    private void convertErrorsToExceptionsAndThrowIfNecessary(@NonNull StripeResponse response) throws InvalidRequestException, APIException, AuthenticationException, CardException {
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> requestIdList = headers == null ? null : headers.get("Request-Id");
        String requestId = requestIdList != null && requestIdList.size() > 0 ? requestIdList.get(0) : null;
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode, requestId);
        }
    }

    @Nullable
    private JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    private JSONArray listToJsonArray(@Nullable List<?> values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)this.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)this.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }

    @NonNull
    private StripeResponse fireStripeApiRequest(@NonNull ApiRequest apiRequest) throws InvalidRequestException, APIConnectionException {
        return this.mStripeApiRequestExecutor.execute(apiRequest);
    }

    private void handleAPIError(@Nullable String responseBody, int responseCode, @Nullable String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        StripeError stripeError = ErrorParser.parseError(responseBody);
        switch (responseCode) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, responseCode, stripeError.code, stripeError.declineCode, stripeError, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError.message, requestId, stripeError);
            }
            case 402: {
                throw new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.declineCode, stripeError.charge, stripeError);
            }
            case 403: {
                throw new PermissionException(stripeError.message, requestId, stripeError);
            }
            case 429: {
                throw new RateLimitException(stripeError.message, stripeError.param, requestId, stripeError);
            }
        }
        throw new APIException(stripeError.message, requestId, responseCode, stripeError, null);
    }

    @NonNull
    @VisibleForTesting
    StripeResponse makeApiRequest(@NonNull ApiRequest request) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        StripeResponse response = this.fireStripeApiRequest(request);
        if (response.hasErrorCode()) {
            this.handleAPIError(response.getResponseBody(), response.getResponseCode(), response.getRequestId());
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeFireAndForgetRequest(@NonNull StripeRequest request) {
        Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        try {
            this.mFireAndForgetRequestExecutor.execute(request);
        }
        catch (StripeException stripeException) {
        }
        finally {
            this.resetDnsCacheTtl(dnsCacheData);
        }
    }

    @NonNull
    private Pair<Boolean, String> disableDnsCache() {
        try {
            String originalDNSCacheTtl = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
            return Pair.create((Object)true, (Object)originalDNSCacheTtl);
        }
        catch (SecurityException se) {
            return Pair.create((Object)false, null);
        }
    }

    private void resetDnsCacheTtl(@NonNull Pair<Boolean, String> dnsCacheData) {
        if (((Boolean)dnsCacheData.first).booleanValue()) {
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, ObjectUtils.getOrDefault(dnsCacheData.second, "-1"));
        }
    }

    @Nullable
    private Token requestToken(@NonNull String url, @NonNull Map<String, Object> params, @NonNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse response = this.makeApiRequest(ApiRequest.createPost(url, params, options, this.mAppInfo));
        return Token.fromString(response.getResponseBody());
    }

    private void fireFingerprintRequest() {
        this.makeFireAndForgetRequest(this.mFingerprintRequestFactory.create());
    }

    @VisibleForTesting
    void fireAnalyticsRequest(@NonNull Map<String, Object> loggingMap, @NonNull String publishableKey) {
        this.makeFireAndForgetRequest(ApiRequest.createAnalyticsRequest(loggingMap, publishableKey, this.mAppInfo));
    }

    @NonNull
    private Map<String, String> createClientSecretParam(@NonNull String clientSecret) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("client_secret", clientSecret);
        return paramMap;
    }

    private static final class Complete3ds2AuthTask
    extends ApiOperation<Boolean> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final String mPublishableKey;

        private Complete3ds2AuthTask(@NonNull StripeApiHandler apiHandler, @NonNull String sourceId, @NonNull String publishableKey, @NonNull ApiResultCallback<Boolean> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mSourceId = sourceId;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @NonNull
        Boolean getResult() throws StripeException {
            return this.mApiHandler.complete3ds2Auth(this.mSourceId, this.mPublishableKey);
        }
    }

    private static final class Start3ds2AuthTask
    extends ApiOperation<Stripe3ds2AuthResult> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Stripe3ds2AuthParams mParams;
        @NonNull
        private final String mStripeIntentId;
        @NonNull
        private final String mPublishableKey;

        private Start3ds2AuthTask(@NonNull StripeApiHandler apiHandler, @NonNull Stripe3ds2AuthParams params, @NonNull String stripeIntentId, @NonNull String publishableKey, @NonNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mParams = params;
            this.mStripeIntentId = stripeIntentId;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @NonNull
        Stripe3ds2AuthResult getResult() throws StripeException, JSONException {
            return this.mApiHandler.start3ds2Auth(this.mParams, this.mStripeIntentId, this.mPublishableKey);
        }
    }
}

