/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.TokenCallback;
import com.stripe.android.model.Card;
import com.stripe.android.model.Token;
import com.stripe.android.util.StripeTextUtils;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.net.RequestOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stripe {
    @VisibleForTesting
    TokenCreator tokenCreator = new TokenCreator(){

        @Override
        public void create(final Card card, final String publishableKey, Executor executor, final TokenCallback callback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        RequestOptions requestOptions = RequestOptions.builder().setApiKey(publishableKey).build();
                        com.stripe.model.Token stripeToken = com.stripe.model.Token.create((Map)Stripe.this.hashMapFromCard(card), (RequestOptions)requestOptions);
                        com.stripe.model.Card stripeCard = stripeToken.getCard();
                        Card card2 = Stripe.this.androidCardFromStripeCard(stripeCard);
                        Token token = Stripe.this.androidTokenFromStripeToken(card2, stripeToken);
                        return new ResponseWrapper(token, null);
                    }
                    catch (Exception e) {
                        return new ResponseWrapper(null, e);
                    }
                }

                protected void onPostExecute(ResponseWrapper result) {
                    Stripe.this.tokenTaskPostExecution(result, callback);
                }
            };
            Stripe.this.executeTokenTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)((AsyncTask)task));
        }
    };
    @VisibleForTesting
    TokenRequester tokenRequester = new TokenRequester(){

        @Override
        public void request(final String tokenId, final String publishableKey, Executor executor, final TokenCallback callback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        com.stripe.model.Token stripeToken = com.stripe.model.Token.retrieve((String)tokenId, (String)publishableKey);
                        com.stripe.model.Card stripeCard = stripeToken.getCard();
                        Card card = Stripe.this.androidCardFromStripeCard(stripeCard);
                        Token token = Stripe.this.androidTokenFromStripeToken(card, stripeToken);
                        return new ResponseWrapper(token, null);
                    }
                    catch (Exception e) {
                        return new ResponseWrapper(null, e);
                    }
                }

                protected void onPostExecute(ResponseWrapper result) {
                    Stripe.this.tokenTaskPostExecution(result, callback);
                }
            };
            Stripe.this.executeTokenTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)((AsyncTask)task));
        }
    };
    private String defaultPublishableKey;

    public Stripe() {
    }

    public Stripe(String publishableKey) throws AuthenticationException {
        this.setDefaultPublishableKey(publishableKey);
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.defaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.defaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        try {
            if (card == null) {
                throw new RuntimeException("Required Parameter: 'card' is required to create a token");
            }
            if (callback == null) {
                throw new RuntimeException("Required Parameter: 'callback' is required to use the created token and handle errors");
            }
            this.validateKey(publishableKey);
            this.tokenCreator.create(card, publishableKey, executor, callback);
        }
        catch (AuthenticationException e) {
            callback.onError((Exception)((Object)e));
        }
    }

    public Token createTokenSynchronous(Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.defaultPublishableKey);
    }

    public Token createTokenSynchronous(Card card, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder().setApiKey(publishableKey).build();
        com.stripe.model.Token stripeToken = com.stripe.model.Token.create(this.hashMapFromCard(card), (RequestOptions)requestOptions);
        com.stripe.model.Card stripeCard = stripeToken.getCard();
        Card resultCard = this.androidCardFromStripeCard(stripeCard);
        return this.androidTokenFromStripeToken(resultCard, stripeToken);
    }

    @Deprecated
    public void requestToken(@NonNull String tokenId, @NonNull TokenCallback callback) {
        this.requestToken(tokenId, this.defaultPublishableKey, callback);
    }

    @Deprecated
    public void requestToken(@NonNull String tokenId, @NonNull @Size(min=1L) String publishableKey, @NonNull TokenCallback callback) {
        this.requestToken(tokenId, publishableKey, null, callback);
    }

    @Deprecated
    public void requestToken(@NonNull String tokenId, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.requestToken(tokenId, this.defaultPublishableKey, executor, callback);
    }

    @Deprecated
    public void requestToken(@NonNull String tokenId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        try {
            if (tokenId == null) {
                throw new RuntimeException("Required Parameter: 'tokenId' is required to request a token");
            }
            if (callback == null) {
                throw new RuntimeException("Required Parameter: 'callback' is required to use the requested token and handle errors");
            }
            this.validateKey(publishableKey);
            this.tokenRequester.request(tokenId, publishableKey, executor, callback);
        }
        catch (AuthenticationException e) {
            callback.onError((Exception)((Object)e));
        }
    }

    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) throws AuthenticationException {
        this.validateKey(publishableKey);
        this.defaultPublishableKey = publishableKey;
    }

    @VisibleForTesting
    Card androidCardFromStripeCard(com.stripe.model.Card stripeCard) {
        return new Card(null, stripeCard.getExpMonth(), stripeCard.getExpYear(), null, stripeCard.getName(), stripeCard.getAddressLine1(), stripeCard.getAddressLine2(), stripeCard.getAddressCity(), stripeCard.getAddressState(), stripeCard.getAddressZip(), stripeCard.getAddressCountry(), stripeCard.getBrand(), stripeCard.getLast4(), stripeCard.getFingerprint(), stripeCard.getFunding(), stripeCard.getCountry(), stripeCard.getCurrency());
    }

    private void validateKey(@NonNull @Size(min=1L) String publishableKey) throws AuthenticationException {
        if (publishableKey == null || publishableKey.length() == 0) {
            throw new AuthenticationException("Invalid Publishable Key: You must use a valid publishable key to create a token.  For more info, see https://stripe.com/docs/stripe.js.", null, Integer.valueOf(0));
        }
        if (publishableKey.startsWith("sk_")) {
            throw new AuthenticationException("Invalid Publishable Key: You are using a secret key to create a token, instead of the publishable one. For more info, see https://stripe.com/docs/stripe.js", null, Integer.valueOf(0));
        }
    }

    private Token androidTokenFromStripeToken(Card androidCard, com.stripe.model.Token stripeToken) {
        return new Token(stripeToken.getId(), stripeToken.getLivemode(), new Date(stripeToken.getCreated() * 1000L), stripeToken.getUsed(), androidCard);
    }

    private void tokenTaskPostExecution(ResponseWrapper result, TokenCallback callback) {
        if (result.token != null) {
            callback.onSuccess(result.token);
        } else if (result.error != null) {
            callback.onError(result.error);
        } else {
            callback.onError(new RuntimeException("Somehow got neither a token response or an error response"));
        }
    }

    private void executeTokenTask(Executor executor, AsyncTask<Void, Void, ResponseWrapper> task) {
        if (executor != null && Build.VERSION.SDK_INT > 11) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    private Map<String, Object> hashMapFromCard(Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        cardParams.put("number", StripeTextUtils.nullIfBlank(card.getNumber()));
        cardParams.put("cvc", StripeTextUtils.nullIfBlank(card.getCVC()));
        cardParams.put("exp_month", card.getExpMonth());
        cardParams.put("exp_year", card.getExpYear());
        cardParams.put("name", StripeTextUtils.nullIfBlank(card.getName()));
        cardParams.put("currency", StripeTextUtils.nullIfBlank(card.getCurrency()));
        cardParams.put("address_line1", StripeTextUtils.nullIfBlank(card.getAddressLine1()));
        cardParams.put("address_line2", StripeTextUtils.nullIfBlank(card.getAddressLine2()));
        cardParams.put("address_city", StripeTextUtils.nullIfBlank(card.getAddressCity()));
        cardParams.put("address_zip", StripeTextUtils.nullIfBlank(card.getAddressZip()));
        cardParams.put("address_state", StripeTextUtils.nullIfBlank(card.getAddressState()));
        cardParams.put("address_country", StripeTextUtils.nullIfBlank(card.getAddressCountry()));
        for (String key : new HashSet(cardParams.keySet())) {
            if (cardParams.get(key) != null) continue;
            cardParams.remove(key);
        }
        tokenParams.put("card", cardParams);
        return tokenParams;
    }

    @VisibleForTesting
    static interface TokenRequester {
        public void request(String var1, String var2, Executor var3, TokenCallback var4);
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(Card var1, String var2, Executor var3, TokenCallback var4);
    }

    private class ResponseWrapper {
        final Token token;
        final Exception error;

        private ResponseWrapper(Token token, Exception error) {
            this.error = error;
            this.token = token;
        }
    }
}

