/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import com.stripe.android.time.Clock;
import java.util.Calendar;
import java.util.Locale;

public class DateUtils {
    public static boolean hasYearPassed(int year) {
        Calendar now;
        int normalized = DateUtils.normalizeYear(year);
        return normalized < (now = Clock.getCalendarInstance()).get(1);
    }

    public static boolean hasMonthPassed(int year, int month) {
        Calendar now = Clock.getCalendarInstance();
        return DateUtils.hasYearPassed(year) || DateUtils.normalizeYear(year) == now.get(1) && month < now.get(2) + 1;
    }

    private static int normalizeYear(int year) {
        if (year < 100 && year >= 0) {
            Calendar now = Clock.getCalendarInstance();
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }
}

