/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import com.stripe.android.util.DateUtils;
import com.stripe.android.util.TextUtils;
import com.stripe.model.StripeObject;

public class Card
extends StripeObject {
    public static final String AMERICAN_EXPRESS = "American Express";
    public static final String DISCOVER = "Discover";
    public static final String JCB = "JCB";
    public static final String DINERS_CLUB = "Diners Club";
    public static final String VISA = "Visa";
    public static final String MASTERCARD = "MasterCard";
    public static final String UNKNOWN = "Unknown";
    public static final String[] PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
    public static final String[] PREFIXES_DISCOVER = new String[]{"60", "62", "64", "65"};
    public static final String[] PREFIXES_JCB = new String[]{"35"};
    public static final String[] PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "37", "39"};
    public static final String[] PREFIXES_VISA = new String[]{"4"};
    public static final String[] PREFIXES_MASTERCARD = new String[]{"50", "51", "52", "53", "54", "55"};
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    private String number;
    private String cvc;
    private Integer expMonth;
    private Integer expYear;
    private String name;
    private String addressLine1;
    private String addressLine2;
    private String addressCity;
    private String addressState;
    private String addressZip;
    private String addressCountry;
    private String last4;
    private String type;
    private String fingerprint;
    private String country;
    private String currency;

    private Card(Builder builder) {
        this.number = TextUtils.nullIfBlank(this.normalizeCardNumber(builder.number));
        this.expMonth = builder.expMonth;
        this.expYear = builder.expYear;
        this.cvc = TextUtils.nullIfBlank(builder.cvc);
        this.name = TextUtils.nullIfBlank(builder.name);
        this.addressLine1 = TextUtils.nullIfBlank(builder.addressLine1);
        this.addressLine2 = TextUtils.nullIfBlank(builder.addressLine2);
        this.addressCity = TextUtils.nullIfBlank(builder.addressCity);
        this.addressState = TextUtils.nullIfBlank(builder.addressState);
        this.addressZip = TextUtils.nullIfBlank(builder.addressZip);
        this.addressCountry = TextUtils.nullIfBlank(builder.addressCountry);
        this.last4 = TextUtils.nullIfBlank(builder.last4);
        this.type = TextUtils.nullIfBlank(builder.type);
        this.fingerprint = TextUtils.nullIfBlank(builder.fingerprint);
        this.country = TextUtils.nullIfBlank(builder.country);
        this.type = this.getType();
        this.last4 = this.getLast4();
        this.currency = TextUtils.nullIfBlank(builder.currency);
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String last4, String type, String fingerprint, String country) {
        this.number = TextUtils.nullIfBlank(this.normalizeCardNumber(number));
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cvc = TextUtils.nullIfBlank(cvc);
        this.name = TextUtils.nullIfBlank(name);
        this.addressLine1 = TextUtils.nullIfBlank(addressLine1);
        this.addressLine2 = TextUtils.nullIfBlank(addressLine2);
        this.addressCity = TextUtils.nullIfBlank(addressCity);
        this.addressState = TextUtils.nullIfBlank(addressState);
        this.addressZip = TextUtils.nullIfBlank(addressZip);
        this.addressCountry = TextUtils.nullIfBlank(addressCountry);
        this.last4 = TextUtils.nullIfBlank(last4);
        this.type = TextUtils.nullIfBlank(type);
        this.fingerprint = TextUtils.nullIfBlank(fingerprint);
        this.country = TextUtils.nullIfBlank(country);
        this.type = this.getType();
        this.last4 = this.getLast4();
        this.currency = TextUtils.nullIfBlank(this.currency);
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String currency) {
        this(number, expMonth, expYear, cvc, name, addressLine1, addressLine2, addressCity, addressState, addressZip, addressCountry, null, null, null, null);
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc) {
        this(number, expMonth, expYear, cvc, null, null, null, null, null, null, null, null, null, null, null);
    }

    public boolean validateCard() {
        if (this.cvc == null) {
            return this.validateNumber() && this.validateExpiryDate();
        }
        return this.validateNumber() && this.validateExpiryDate() && this.validateCVC();
    }

    public boolean validateNumber() {
        if (TextUtils.isBlank(this.number)) {
            return false;
        }
        String rawNumber = this.number.trim().replaceAll("\\s+|-", "");
        if (TextUtils.isBlank(rawNumber) || !TextUtils.isWholePositiveNumber(rawNumber) || !this.isValidLuhnNumber(rawNumber)) {
            return false;
        }
        if (AMERICAN_EXPRESS.equals(this.type)) {
            return rawNumber.length() == 15;
        }
        if (DINERS_CLUB.equals(this.type)) {
            return rawNumber.length() == 14;
        }
        return rawNumber.length() == 16;
    }

    public boolean validateExpiryDate() {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !DateUtils.hasMonthPassed(this.expYear, this.expMonth);
    }

    public boolean validateExpMonth() {
        if (this.expMonth == null) {
            return false;
        }
        return this.expMonth >= 1 && this.expMonth <= 12;
    }

    public boolean validateExpYear() {
        if (this.expYear == null) {
            return false;
        }
        return !DateUtils.hasYearPassed(this.expYear);
    }

    public boolean validateCVC() {
        boolean validLength;
        if (TextUtils.isBlank(this.cvc)) {
            return false;
        }
        String cvcValue = this.cvc.trim();
        boolean bl = validLength = this.type == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || AMERICAN_EXPRESS.equals(this.type) && cvcValue.length() == 4 || !AMERICAN_EXPRESS.equals(this.type) && cvcValue.length() == 3;
        return TextUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    private boolean isValidLuhnNumber(String number) {
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; index >= 0; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Integer.parseInt("" + c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    private String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCVC() {
        return this.cvc;
    }

    public void setCVC(String cvc) {
        this.cvc = cvc;
    }

    public Integer getExpMonth() {
        return this.expMonth;
    }

    public void setExpMonth(Integer expMonth) {
        this.expMonth = expMonth;
    }

    public Integer getExpYear() {
        return this.expYear;
    }

    public void setExpYear(Integer expYear) {
        this.expYear = expYear;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressZip() {
        return this.addressZip;
    }

    public void setAddressZip(String addressZip) {
        this.addressZip = addressZip;
    }

    public String getAddressState() {
        return this.addressState;
    }

    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLast4() {
        if (!TextUtils.isBlank(this.last4)) {
            return this.last4;
        }
        if (this.number != null && this.number.length() > 4) {
            return this.number.substring(this.number.length() - 4, this.number.length());
        }
        return null;
    }

    public String getType() {
        if (TextUtils.isBlank(this.type) && !TextUtils.isBlank(this.number)) {
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_AMERICAN_EXPRESS)) {
                return AMERICAN_EXPRESS;
            }
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_DISCOVER)) {
                return DISCOVER;
            }
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_JCB)) {
                return JCB;
            }
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_DINERS_CLUB)) {
                return DINERS_CLUB;
            }
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_VISA)) {
                return VISA;
            }
            if (TextUtils.hasAnyPrefix(this.number, PREFIXES_MASTERCARD)) {
                return MASTERCARD;
            }
            return UNKNOWN;
        }
        return this.type;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getCountry() {
        return this.country;
    }

    public static class Builder {
        private final String number;
        private final String cvc;
        private final Integer expMonth;
        private final Integer expYear;
        private String name;
        private String addressLine1;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressCountry;
        private String last4;
        private String type;
        private String fingerprint;
        private String country;
        private String currency;

        public Builder(String number, Integer expMonth, Integer expYear, String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addressLine1(String address) {
            this.addressLine1 = address;
            return this;
        }

        public Builder addressLine2(String address) {
            this.addressLine2 = address;
            return this;
        }

        public Builder addressCity(String city) {
            this.addressCity = city;
            return this;
        }

        public Builder addressState(String state) {
            this.addressState = state;
            return this;
        }

        public Builder addressZip(String zip) {
            this.addressZip = zip;
            return this;
        }

        public Builder addressCountry(String country) {
            this.addressCountry = country;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = last4;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Card build() {
            return new Card(this);
        }
    }
}

