/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.TokenCallback;
import com.stripe.android.compat.AsyncTask;
import com.stripe.android.model.Card;
import com.stripe.android.model.Token;
import com.stripe.android.util.TextUtils;
import com.stripe.exception.AuthenticationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stripe {
    private String defaultPublishableKey;
    public TokenCreator tokenCreator = new TokenCreator(){

        @Override
        public void create(final Card card, final String publishableKey, Executor executor, final TokenCallback callback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        com.stripe.model.Token stripeToken = com.stripe.model.Token.create((Map)Stripe.this.hashMapFromCard(card), (String)publishableKey);
                        com.stripe.model.Card stripeCard = stripeToken.getCard();
                        Card card2 = Stripe.this.androidCardFromStripeCard(stripeCard);
                        Token token = Stripe.this.androidTokenFromStripeToken(card2, stripeToken);
                        return new ResponseWrapper(token, null);
                    }
                    catch (Exception e) {
                        return new ResponseWrapper(null, e);
                    }
                }

                @Override
                protected void onPostExecute(ResponseWrapper result) {
                    Stripe.this.tokenTaskPostExecution(result, callback);
                }
            };
            Stripe.this.executeTokenTask(executor, task);
        }
    };
    public TokenRequester tokenRequester = new TokenRequester(){

        @Override
        public void request(final String tokenId, final String publishableKey, Executor executor, final TokenCallback callback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        com.stripe.model.Token stripeToken = com.stripe.model.Token.retrieve((String)tokenId, (String)publishableKey);
                        com.stripe.model.Card stripeCard = stripeToken.getCard();
                        Card card = Stripe.this.androidCardFromStripeCard(stripeCard);
                        Token token = Stripe.this.androidTokenFromStripeToken(card, stripeToken);
                        return new ResponseWrapper(token, null);
                    }
                    catch (Exception e) {
                        return new ResponseWrapper(null, e);
                    }
                }

                @Override
                protected void onPostExecute(ResponseWrapper result) {
                    Stripe.this.tokenTaskPostExecution(result, callback);
                }
            };
            Stripe.this.executeTokenTask(executor, task);
        }
    };

    public Stripe() {
    }

    public Stripe(String publishableKey) throws AuthenticationException {
        this.setDefaultPublishableKey(publishableKey);
    }

    public void setDefaultPublishableKey(String publishableKey) throws AuthenticationException {
        this.validateKey(publishableKey);
        this.defaultPublishableKey = publishableKey;
    }

    private void validateKey(String publishableKey) throws AuthenticationException {
        if (publishableKey == null || publishableKey.length() == 0) {
            throw new AuthenticationException("Invalid Publishable Key: You must use a valid publishable key to create a token.  For more info, see https://stripe.com/docs/stripe.js.");
        }
        if (publishableKey.startsWith("sk_")) {
            throw new AuthenticationException("Invalid Publishable Key: You are using a secret key to create a token, instead of the publishable one. For more info, see https://stripe.com/docs/stripe.js");
        }
    }

    public void requestToken(String tokenId, Executor executor, TokenCallback callback) {
        this.requestToken(tokenId, this.defaultPublishableKey, executor, callback);
    }

    public void requestToken(String tokenId, String publishableKey, TokenCallback callback) {
        this.requestToken(tokenId, publishableKey, null, callback);
    }

    public void requestToken(String tokenId, TokenCallback callback) {
        this.requestToken(tokenId, this.defaultPublishableKey, callback);
    }

    public void requestToken(String tokenId, String publishableKey, Executor executor, TokenCallback callback) {
        try {
            if (tokenId == null) {
                throw new RuntimeException("Required Parameter: 'tokenId' is required to request a token");
            }
            if (callback == null) {
                throw new RuntimeException("Required Parameter: 'callback' is required to use the requested token and handle errors");
            }
            this.validateKey(publishableKey);
            this.tokenRequester.request(tokenId, publishableKey, executor, callback);
        }
        catch (AuthenticationException e) {
            callback.onError((Exception)((Object)e));
        }
    }

    public void createToken(Card card, Executor executor, TokenCallback callback) {
        this.createToken(card, this.defaultPublishableKey, executor, callback);
    }

    public void createToken(Card card, String publishableKey, TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(Card card, TokenCallback callback) {
        this.createToken(card, this.defaultPublishableKey, callback);
    }

    public void createToken(Card card, String publishableKey, Executor executor, TokenCallback callback) {
        try {
            if (card == null) {
                throw new RuntimeException("Required Parameter: 'card' is required to create a token");
            }
            if (callback == null) {
                throw new RuntimeException("Required Parameter: 'callback' is required to use the created token and handle errors");
            }
            this.validateKey(publishableKey);
            this.tokenCreator.create(card, publishableKey, executor, callback);
        }
        catch (AuthenticationException e) {
            callback.onError((Exception)((Object)e));
        }
    }

    private Card androidCardFromStripeCard(com.stripe.model.Card stripeCard) {
        return new Card(null, stripeCard.getExpMonth(), stripeCard.getExpYear(), null, stripeCard.getName(), stripeCard.getAddressLine1(), stripeCard.getAddressLine2(), stripeCard.getAddressCity(), stripeCard.getAddressState(), stripeCard.getAddressZip(), stripeCard.getAddressCountry(), stripeCard.getLast4(), stripeCard.getType(), stripeCard.getFingerprint(), stripeCard.getCountry());
    }

    private Token androidTokenFromStripeToken(Card androidCard, com.stripe.model.Token stripeToken) {
        return new Token(stripeToken.getId(), stripeToken.getLivemode(), new Date(stripeToken.getCreated() * 1000L), stripeToken.getUsed(), androidCard);
    }

    private void tokenTaskPostExecution(ResponseWrapper result, TokenCallback callback) {
        if (result.token != null) {
            callback.onSuccess(result.token);
        } else if (result.error != null) {
            callback.onError(result.error);
        } else {
            callback.onError(new RuntimeException("Somehow got neither a token response or an error response"));
        }
    }

    private void executeTokenTask(Executor executor, AsyncTask<Void, Void, ResponseWrapper> task) {
        if (executor != null) {
            task.executeOnExecutor(executor, (Void[])new Void[0]);
        } else {
            task.execute((Void[])new Void[0]);
        }
    }

    private Map<String, Object> hashMapFromCard(Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        cardParams.put("number", TextUtils.nullIfBlank(card.getNumber()));
        cardParams.put("cvc", TextUtils.nullIfBlank(card.getCVC()));
        cardParams.put("exp_month", card.getExpMonth());
        cardParams.put("exp_year", card.getExpYear());
        cardParams.put("name", TextUtils.nullIfBlank(card.getName()));
        cardParams.put("address_line1", TextUtils.nullIfBlank(card.getAddressLine1()));
        cardParams.put("address_line2", TextUtils.nullIfBlank(card.getAddressLine2()));
        cardParams.put("address_city", TextUtils.nullIfBlank(card.getAddressCity()));
        cardParams.put("address_zip", TextUtils.nullIfBlank(card.getAddressZip()));
        cardParams.put("address_state", TextUtils.nullIfBlank(card.getAddressState()));
        cardParams.put("address_country", TextUtils.nullIfBlank(card.getAddressCountry()));
        for (String key : new HashSet(cardParams.keySet())) {
            if (cardParams.get(key) != null) continue;
            cardParams.remove(key);
        }
        tokenParams.put("card", cardParams);
        return tokenParams;
    }

    static interface TokenRequester {
        public void request(String var1, String var2, Executor var3, TokenCallback var4);
    }

    static interface TokenCreator {
        public void create(Card var1, String var2, Executor var3, TokenCallback var4);
    }

    private class ResponseWrapper {
        public final Token token;
        public final Exception error;

        private ResponseWrapper(Token token, Exception error) {
            this.error = error;
            this.token = token;
        }
    }
}

