/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.jwk.KeyUse;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.security.Algorithm;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0080\u0081\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB3\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dj\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/stripe3ds2/security/DirectoryServer;", "", "ids", "", "", "algorithm", "Lcom/stripe/android/stripe3ds2/security/Algorithm;", "fileName", "keyUse", "Lcom/nimbusds/jose/jwk/KeyUse;", "<init>", "(Ljava/lang/String;ILjava/util/List;Lcom/stripe/android/stripe3ds2/security/Algorithm;Ljava/lang/String;Lcom/nimbusds/jose/jwk/KeyUse;)V", "getIds", "()Ljava/util/List;", "getAlgorithm", "()Lcom/stripe/android/stripe3ds2/security/Algorithm;", "getFileName", "()Ljava/lang/String;", "getKeyUse", "()Lcom/nimbusds/jose/jwk/KeyUse;", "TestRsa", "TestEc", "Visa", "Mastercard", "Amex", "Discover", "CartesBancaires", "isCertificate", "", "()Z", "Companion", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nDirectoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryServer.kt\ncom/stripe/android/stripe3ds2/security/DirectoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n*S KotlinDebug\n*F\n+ 1 DirectoryServer.kt\ncom/stripe/android/stripe3ds2/security/DirectoryServer\n*L\n67#1:88,3\n*E\n"})
public final class DirectoryServer
extends Enum<DirectoryServer> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<String> ids;
    @NotNull
    private final Algorithm algorithm;
    @NotNull
    private final String fileName;
    @Nullable
    private final KeyUse keyUse;
    @NotNull
    private static final Set<String> CERTIFICATE_EXTENSIONS;
    public static final /* enum */ DirectoryServer TestRsa;
    public static final /* enum */ DirectoryServer TestEc;
    public static final /* enum */ DirectoryServer Visa;
    public static final /* enum */ DirectoryServer Mastercard;
    public static final /* enum */ DirectoryServer Amex;
    public static final /* enum */ DirectoryServer Discover;
    public static final /* enum */ DirectoryServer CartesBancaires;
    private static final /* synthetic */ DirectoryServer[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DirectoryServer(List<String> ids, Algorithm algorithm, String fileName, KeyUse keyUse) {
        this.ids = ids;
        this.algorithm = algorithm;
        this.fileName = fileName;
        this.keyUse = keyUse;
    }

    /* synthetic */ DirectoryServer(String string, int n, List list, Algorithm algorithm, String string2, KeyUse keyUse, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            keyUse = KeyUse.SIGNATURE;
        }
        this(list, algorithm, string2, keyUse);
    }

    @NotNull
    public final List<String> getIds() {
        return this.ids;
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final KeyUse getKeyUse() {
        return this.keyUse;
    }

    public final boolean isCertificate() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CERTIFICATE_EXTENSIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)this.fileName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static DirectoryServer[] values() {
        return (DirectoryServer[])$VALUES.clone();
    }

    public static DirectoryServer valueOf(String value) {
        return Enum.valueOf(DirectoryServer.class, value);
    }

    @NotNull
    public static EnumEntries<DirectoryServer> getEntries() {
        return $ENTRIES;
    }

    static {
        TestRsa = new DirectoryServer("TestRsa", 0, CollectionsKt.listOf((Object)"F055545342"), Algorithm.RSA, "ds-test-rsa.txt", null, 8, null);
        TestEc = new DirectoryServer("TestEc", 1, CollectionsKt.listOf((Object)"F155545342"), Algorithm.EC, "ds-test-ec.txt", null, 8, null);
        Visa = new DirectoryServer("Visa", 2, CollectionsKt.listOf((Object)"A000000003"), Algorithm.RSA, "ds-visa.crt", null, 8, null);
        Mastercard = new DirectoryServer("Mastercard", 3, CollectionsKt.listOf((Object)"A000000004"), Algorithm.RSA, "ds-mastercard.crt", null, 8, null);
        Amex = new DirectoryServer("Amex", 4, CollectionsKt.listOf((Object)"A000000025"), Algorithm.RSA, "ds-amex.pem", null, 8, null);
        Object[] objectArray = new String[]{"A000000152", "A000000324"};
        Discover = new DirectoryServer(CollectionsKt.listOf((Object[])objectArray), Algorithm.RSA, "ds-discover.cer", null);
        CartesBancaires = new DirectoryServer("CartesBancaires", 6, CollectionsKt.listOf((Object)"A000000042"), Algorithm.RSA, "ds-cartesbancaires.pem", null, 8, null);
        $VALUES = directoryServerArray = new DirectoryServer[]{DirectoryServer.TestRsa, DirectoryServer.TestEc, DirectoryServer.Visa, DirectoryServer.Mastercard, DirectoryServer.Amex, DirectoryServer.Discover, DirectoryServer.CartesBancaires};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        objectArray = new String[]{".crt", ".cer", ".pem"};
        CERTIFICATE_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/stripe3ds2/security/DirectoryServer$Companion;", "", "<init>", "()V", "CERTIFICATE_EXTENSIONS", "", "", "lookup", "Lcom/stripe/android/stripe3ds2/security/DirectoryServer;", "directoryServerId", "3ds2sdk_release"})
    @SourceDebugExtension(value={"SMAP\nDirectoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryServer.kt\ncom/stripe/android/stripe3ds2/security/DirectoryServer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n295#2,2:88\n*S KotlinDebug\n*F\n+ 1 DirectoryServer.kt\ncom/stripe/android/stripe3ds2/security/DirectoryServer$Companion\n*L\n78#1:88,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectoryServer lookup(@NotNull String directoryServerId) {
            DirectoryServer directoryServer;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
                Iterable $this$firstOrNull$iv = (Iterable)DirectoryServer.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DirectoryServer it = (DirectoryServer)((Object)element$iv);
                    boolean bl = false;
                    if (!it.getIds().contains(directoryServerId)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            DirectoryServer directoryServer2 = directoryServer = (DirectoryServer)v0;
            if (directoryServer2 == null) {
                throw new SDKRuntimeException(new IllegalArgumentException("Unknown directory server id: " + directoryServerId));
            }
            return directoryServer2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

