/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.MessageTransformerFactory;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.DefaultAcsDataParser;
import com.stripe.android.stripe3ds2.transaction.DefaultChallengeRequestResultRepository;
import com.stripe.android.stripe3ds2.transaction.DefaultJwsValidator;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.StripeErrorRequestExecutor;
import com.stripe.android.stripe3ds2.transaction.TransactionViewModel;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J'\u0010\u0016\u001a\u0002H\u0017\"\n\b\u0000\u0010\u0017*\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionViewModelFactory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "sdkReferenceNumber", "", "isLiveMode", "", "challengeParameters", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "sdkKeyPair", "Ljava/security/KeyPair;", "logger", "Lcom/stripe/android/stripe3ds2/transaction/Logger;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;Ljava/util/List;Ljava/security/KeyPair;Lcom/stripe/android/stripe3ds2/transaction/Logger;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lkotlin/coroutines/CoroutineContext;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "3ds2sdk_release"})
public final class TransactionViewModelFactory
implements ViewModelProvider.Factory {
    @NotNull
    private final SdkTransactionId sdkTransactionId;
    @NotNull
    private final String sdkReferenceNumber;
    private final boolean isLiveMode;
    @NotNull
    private final ChallengeParameters challengeParameters;
    @NotNull
    private final List<X509Certificate> rootCerts;
    @NotNull
    private final KeyPair sdkKeyPair;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final CoroutineContext workContext;

    public TransactionViewModelFactory(@NotNull SdkTransactionId sdkTransactionId2, @NotNull String sdkReferenceNumber, boolean isLiveMode, @NotNull ChallengeParameters challengeParameters, @NotNull List<? extends X509Certificate> rootCerts, @NotNull KeyPair sdkKeyPair, @NotNull Logger logger, @NotNull ErrorReporter errorReporter2, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)sdkTransactionId2, (String)"sdkTransactionId");
        Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
        Intrinsics.checkNotNullParameter((Object)challengeParameters, (String)"challengeParameters");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)sdkKeyPair, (String)"sdkKeyPair");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.sdkTransactionId = sdkTransactionId2;
        this.sdkReferenceNumber = sdkReferenceNumber;
        this.isLiveMode = isLiveMode;
        this.challengeParameters = challengeParameters;
        this.rootCerts = rootCerts;
        this.sdkKeyPair = sdkKeyPair;
        this.logger = logger;
        this.errorReporter = errorReporter2;
        this.workContext = workContext;
    }

    public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        return (T)((Object)new TransactionViewModel(new MessageVersionRegistry(), this.sdkTransactionId, this.sdkReferenceNumber, this.challengeParameters, new DefaultJwsValidator(this.isLiveMode, this.rootCerts, this.errorReporter), this.sdkKeyPair, new MessageTransformerFactory(this.errorReporter).create(this.isLiveMode), new DefaultAcsDataParser(this.errorReporter), new DefaultChallengeRequestResultRepository(this.errorReporter, this.workContext), new StripeErrorRequestExecutor.Factory(this.workContext), this.logger, this.errorReporter));
    }
}

