/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParametersFactory;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.IntentData;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.TransactionContract;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/StripeTransaction;", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "areqParamsFactory", "Lcom/stripe/android/stripe3ds2/transaction/AuthenticationRequestParametersFactory;", "directoryServerId", "", "directoryServerPublicKey", "Ljava/security/PublicKey;", "directoryServerKeyId", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "sdkKeyPair", "Ljava/security/KeyPair;", "sdkReferenceNumber", "isLiveMode", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "enableLogging", "(Lcom/stripe/android/stripe3ds2/transaction/AuthenticationRequestParametersFactory;Ljava/lang/String;Ljava/security/PublicKey;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Ljava/security/KeyPair;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;Ljava/util/List;Z)V", "getSdkTransactionId", "()Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "createAuthenticationRequestParameters", "Lcom/stripe/android/stripe3ds2/transaction/AuthenticationRequestParameters;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTransactionArgs", "Lcom/stripe/android/stripe3ds2/transaction/TransactionContract$Args;", "challengeParameters", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeParameters;", "timeoutMins", "", "intentData", "Lcom/stripe/android/stripe3ds2/transaction/IntentData;", "Companion", "3ds2sdk_release"})
public final class StripeTransaction
implements Transaction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticationRequestParametersFactory areqParamsFactory;
    @NotNull
    private final String directoryServerId;
    @NotNull
    private final PublicKey directoryServerPublicKey;
    @Nullable
    private final String directoryServerKeyId;
    @NotNull
    private final SdkTransactionId sdkTransactionId;
    @NotNull
    private final KeyPair sdkKeyPair;
    @NotNull
    private final String sdkReferenceNumber;
    private final boolean isLiveMode;
    @NotNull
    private final StripeUiCustomization uiCustomization;
    @NotNull
    private final List<X509Certificate> rootCerts;
    private final boolean enableLogging;
    public static final int MIN_TIMEOUT = 5;

    public StripeTransaction(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull String directoryServerId, @NotNull PublicKey directoryServerPublicKey, @Nullable String directoryServerKeyId, @NotNull SdkTransactionId sdkTransactionId2, @NotNull KeyPair sdkKeyPair, @NotNull String sdkReferenceNumber, boolean isLiveMode, @NotNull StripeUiCustomization uiCustomization, @NotNull List<? extends X509Certificate> rootCerts, boolean enableLogging) {
        Intrinsics.checkNotNullParameter((Object)areqParamsFactory, (String)"areqParamsFactory");
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
        Intrinsics.checkNotNullParameter((Object)sdkTransactionId2, (String)"sdkTransactionId");
        Intrinsics.checkNotNullParameter((Object)sdkKeyPair, (String)"sdkKeyPair");
        Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        this.areqParamsFactory = areqParamsFactory;
        this.directoryServerId = directoryServerId;
        this.directoryServerPublicKey = directoryServerPublicKey;
        this.directoryServerKeyId = directoryServerKeyId;
        this.sdkTransactionId = sdkTransactionId2;
        this.sdkKeyPair = sdkKeyPair;
        this.sdkReferenceNumber = sdkReferenceNumber;
        this.isLiveMode = isLiveMode;
        this.uiCustomization = uiCustomization;
        this.rootCerts = rootCerts;
        this.enableLogging = enableLogging;
    }

    @Override
    @NotNull
    public SdkTransactionId getSdkTransactionId() {
        return this.sdkTransactionId;
    }

    @Override
    @Nullable
    public Object createAuthenticationRequestParameters(@NotNull Continuation<? super AuthenticationRequestParameters> $completion) {
        SdkTransactionId sdkTransactionId2 = this.getSdkTransactionId();
        PublicKey publicKey = this.sdkKeyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"sdkKeyPair.public");
        return this.areqParamsFactory.create(this.directoryServerId, this.directoryServerPublicKey, this.directoryServerKeyId, sdkTransactionId2, publicKey, $completion);
    }

    @Override
    @NotNull
    public TransactionContract.Args createTransactionArgs(@NotNull ChallengeParameters challengeParameters, int timeoutMins, @NotNull IntentData intentData) {
        Intrinsics.checkNotNullParameter((Object)challengeParameters, (String)"challengeParameters");
        Intrinsics.checkNotNullParameter((Object)intentData, (String)"intentData");
        return new TransactionContract.Args(this.getSdkTransactionId(), this.sdkReferenceNumber, this.isLiveMode, this.uiCustomization, this.rootCerts, this.sdkKeyPair, this.enableLogging, challengeParameters, RangesKt.coerceAtLeast((int)timeoutMins, (int)5), intentData);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/StripeTransaction$Companion;", "", "()V", "MIN_TIMEOUT", "", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

