/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.impl.AAD;
import com.nimbusds.jose.crypto.impl.AESCBC;
import com.nimbusds.jose.crypto.impl.AESGCM;
import com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import com.nimbusds.jose.crypto.impl.DeflateHelper;
import com.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import com.nimbusds.jose.jca.JWEJCAContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.ByteUtils;
import com.nimbusds.jose.util.Container;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/stripe3ds2/security/TransactionEncrypter;", "Lcom/nimbusds/jose/crypto/DirectEncrypter;", "key", "", "counter", "", "([BB)V", "encrypt", "Lcom/nimbusds/jose/JWECryptoParts;", "header", "Lcom/nimbusds/jose/JWEHeader;", "clearText", "Crypto", "3ds2sdk_release"})
public final class TransactionEncrypter
extends DirectEncrypter {
    private final byte counter;

    @NotNull
    public JWECryptoParts encrypt(@NotNull JWEHeader header, @NotNull byte[] clearText) throws JOSEException {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)clearText, (String)"clearText");
        JWEAlgorithm alg = header.getAlgorithm();
        if (Intrinsics.areEqual((Object)alg, (Object)JWEAlgorithm.DIR) ^ true) {
            throw (Throwable)new JOSEException("Invalid algorithm " + alg);
        }
        EncryptionMethod enc = header.getEncryptionMethod();
        int n = enc.cekBitLength();
        SecretKey secretKey = this.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"key");
        if (n != ByteUtils.bitLength((byte[])secretKey.getEncoded())) {
            throw (Throwable)new KeyLengthException(enc.cekBitLength(), (Algorithm)enc);
        }
        Base64URL encryptedKey = null;
        int n2 = enc.cekBitLength();
        SecretKey secretKey2 = this.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"key");
        if (n2 != ByteUtils.bitLength((byte[])secretKey2.getEncoded())) {
            throw (Throwable)new KeyLengthException("The Content Encryption Key length for " + enc + " must be " + enc.cekBitLength() + " bits");
        }
        byte[] plainText = DeflateHelper.applyCompression((JWEHeader)header, (byte[])clearText);
        byte[] aad = AAD.compute((JWEHeader)header);
        byte[] iv = null;
        AuthenticatedCipherText authCipherText = null;
        if (Intrinsics.areEqual((Object)header.getEncryptionMethod(), (Object)EncryptionMethod.A128CBC_HS256)) {
            iv = Crypto.INSTANCE.getGcmIvStoA(128, this.counter);
            SecretKey secretKey3 = this.getKey();
            JWEJCAContext jWEJCAContext = this.getJCAContext();
            Intrinsics.checkNotNullExpressionValue((Object)jWEJCAContext, (String)"jcaContext");
            Provider provider = jWEJCAContext.getContentEncryptionProvider();
            JWEJCAContext jWEJCAContext2 = this.getJCAContext();
            Intrinsics.checkNotNullExpressionValue((Object)jWEJCAContext2, (String)"jcaContext");
            AuthenticatedCipherText authenticatedCipherText = AESCBC.encryptAuthenticated((SecretKey)secretKey3, (byte[])iv, (byte[])plainText, (byte[])aad, (Provider)provider, (Provider)jWEJCAContext2.getMACProvider());
            Intrinsics.checkNotNullExpressionValue((Object)authenticatedCipherText, (String)"AESCBC.encryptAuthentica\u2026rovider\n                )");
            authCipherText = authenticatedCipherText;
        } else if (Intrinsics.areEqual((Object)header.getEncryptionMethod(), (Object)EncryptionMethod.A128GCM)) {
            iv = Crypto.INSTANCE.getGcmIvStoA(96, this.counter);
            AuthenticatedCipherText authenticatedCipherText = AESGCM.encrypt((SecretKey)this.getKey(), (Container)new Container((Object)iv), (byte[])plainText, (byte[])aad, null);
            Intrinsics.checkNotNullExpressionValue((Object)authenticatedCipherText, (String)"AESGCM.encrypt(key, Cont\u2026v), plainText, aad, null)");
            authCipherText = authenticatedCipherText;
        } else {
            throw (Throwable)new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod((EncryptionMethod)header.getEncryptionMethod(), (Collection)DirectCryptoProvider.SUPPORTED_ENCRYPTION_METHODS));
        }
        return new JWECryptoParts(header, encryptedKey, Base64URL.encode((byte[])iv), Base64URL.encode((byte[])authCipherText.getCipherText()), Base64URL.encode((byte[])authCipherText.getAuthenticationTag()));
    }

    public TransactionEncrypter(@NotNull byte[] key, byte counter) throws KeyLengthException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super((SecretKey)new SecretKeySpec(key, "AES"));
        this.counter = counter;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/stripe3ds2/security/TransactionEncrypter$Crypto;", "", "()V", "BITS_IN_BYTE", "", "getGcmId", "", "length", "pad", "", "counter", "getGcmIvAtoS", "sdkCounterAtoS", "getGcmIvStoA", "sdkCounterStoA", "3ds2sdk_release"})
    public static final class Crypto {
        private static final int BITS_IN_BYTE = 8;
        @NotNull
        public static final Crypto INSTANCE;

        @NotNull
        public final byte[] getGcmIvStoA(int length, byte sdkCounterStoA) {
            return this.getGcmId(length, (byte)0, sdkCounterStoA);
        }

        private final byte[] getGcmIvAtoS(int length, byte sdkCounterAtoS) {
            return this.getGcmId(length, (byte)255, sdkCounterAtoS);
        }

        private final byte[] getGcmId(int length, byte pad, byte counter) {
            byte[] iv = new byte[length / 8];
            Arrays.fill(iv, pad);
            iv[iv.length - 1] = counter;
            return iv;
        }

        private Crypto() {
        }

        static {
            Crypto crypto;
            INSTANCE = crypto = new Crypto();
        }
    }
}

