package com.stripe.android.stripe3ds2.transaction

import android.util.Log

internal interface Logger {
    fun error(msg: String, t: Throwable? = null)

    fun info(msg: String)

    companion object {
        private const val TAG = "StripeSdk"

        private val REAL_LOGGER = object : Logger {
            override fun info(msg: String) {
                Log.i(TAG, msg)
            }

            override fun error(msg: String, t: Throwable?) {
                Log.e(TAG, msg, t)
            }
        }

        private val NOOP_LOGGER = object : Logger {
            override fun info(msg: String) {
            }

            override fun error(msg: String, t: Throwable?) {
            }
        }

        internal fun real(): Logger {
            return REAL_LOGGER
        }

        internal fun noop(): Logger {
            return NOOP_LOGGER
        }
    }
}
