package com.stripe.android.stripe3ds2.init

import androidx.annotation.Keep

// NOTE: Copied from reference app spec

/**
 * The Warning class shall represent a warning that is produced by the 3DS SDK while performing
 * security checks during initialization.
 */
@Keep
data class Warning(

    /**
     * The warning ID.
     */
    val id: String,

    /**
     * The warning message.
     */
    val message: String,

    /**
     * The severity level of the warning.
     */
    val severity: Severity
) {
    enum class Severity {
        LOW,
        MEDIUM,
        HIGH
    }
}
