/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import android.content.Context;
import android.util.Base64;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.Algorithm;
import com.stripe.android.stripe3ds2.security.DirectoryServer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "", "context", "Landroid/content/Context;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "create", "Ljava/security/PublicKey;", "directoryServerId", "", "generateCertificate", "Ljava/security/cert/Certificate;", "fileName", "generatePublicKey", "algorithm", "Lcom/stripe/android/stripe3ds2/security/Algorithm;", "readFile", "Ljava/io/InputStream;", "readPublicKeyBytes", "", "keyFile", "3ds2sdk_release"})
public final class PublicKeyFactory {
    private final Context context;
    private final ErrorReporter errorReporter;

    @NotNull
    public final PublicKey create(@NotNull String directoryServerId) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        DirectoryServer directoryServer = DirectoryServer.Companion.lookup(directoryServerId);
        if (directoryServer.isCertificate()) {
            PublicKey publicKey2 = this.generateCertificate(directoryServer.getFileName()).getPublicKey();
            publicKey = publicKey2;
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generateCertificate(dire\u2026erver.fileName).publicKey");
        } else {
            publicKey = this.generatePublicKey(directoryServer.getFileName(), directoryServer.getAlgorithm());
        }
        return publicKey;
    }

    private final Certificate generateCertificate(String fileName) {
        Object object;
        PublicKeyFactory publicKeyFactory = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = publicKeyFactory;
            boolean bl2 = false;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            $this$runCatching = factory.generateCertificate(((PublicKeyFactory)$this$runCatching).readFile(fileName));
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        publicKeyFactory = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean $this$runCatching = false;
            boolean bl2 = false;
            Throwable throwable3 = throwable2;
            boolean bl5 = false;
            Throwable it = throwable3;
            boolean bl6 = false;
            this.errorReporter.reportError(it);
        }
        bl = false;
        boolean bl7 = false;
        Throwable throwable4 = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable4 != null) {
            Throwable it = throwable4;
            boolean bl8 = false;
            throw (Throwable)new SDKRuntimeException(it);
        }
        PublicKeyFactory publicKeyFactory2 = publicKeyFactory;
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyFactory2, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (Certificate)((Object)publicKeyFactory2);
    }

    private final PublicKey generatePublicKey(String fileName, Algorithm algorithm) {
        Object object;
        PublicKeyFactory publicKeyFactory = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = publicKeyFactory;
            boolean bl2 = false;
            $this$runCatching = KeyFactory.getInstance(algorithm.toString()).generatePublic(new X509EncodedKeySpec(((PublicKeyFactory)$this$runCatching).readPublicKeyBytes(fileName)));
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        publicKeyFactory = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean $this$runCatching = false;
            boolean bl2 = false;
            Throwable throwable3 = throwable2;
            boolean bl5 = false;
            Throwable it = throwable3;
            boolean bl6 = false;
            this.errorReporter.reportError(it);
        }
        bl = false;
        boolean bl7 = false;
        Throwable throwable4 = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable4 != null) {
            Throwable it = throwable4;
            boolean bl8 = false;
            throw (Throwable)new SDKRuntimeException(it);
        }
        PublicKeyFactory publicKeyFactory2 = publicKeyFactory;
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyFactory2, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (PublicKey)((Object)publicKeyFactory2);
    }

    private final byte[] readPublicKeyBytes(String keyFile) {
        Object object;
        PublicKeyFactory publicKeyFactory = this;
        boolean bl = false;
        try {
            String publicKey;
            object = Result.Companion;
            Object $this$runCatching = publicKeyFactory;
            boolean bl2 = false;
            String string = publicKey = new Scanner(((PublicKeyFactory)$this$runCatching).readFile(keyFile)).useDelimiter("\\A").next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publicKey");
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            $this$runCatching = Base64.decode((byte[])byArray, (int)0);
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        publicKeyFactory = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean $this$runCatching = false;
            boolean bl2 = false;
            Throwable throwable3 = throwable2;
            boolean bl6 = false;
            Throwable it = throwable3;
            boolean bl7 = false;
            this.errorReporter.reportError(it);
        }
        bl = false;
        boolean bl8 = false;
        Throwable throwable4 = Result.exceptionOrNull-impl((Object)publicKeyFactory);
        if (throwable4 != null) {
            Throwable it = throwable4;
            boolean bl9 = false;
            throw (Throwable)new SDKRuntimeException(it);
        }
        PublicKeyFactory publicKeyFactory2 = publicKeyFactory;
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyFactory2, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (byte[])publicKeyFactory2;
    }

    private final InputStream readFile(String fileName) throws IOException {
        InputStream inputStream = this.context.getAssets().open(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
        return inputStream;
    }

    public PublicKeyFactory(@NotNull Context context, @NotNull ErrorReporter errorReporter2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this.errorReporter = errorReporter2;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.context = context2;
    }
}

