package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException

interface TransactionTimerProvider {
    fun put(sdkTransactionId: SdkTransactionId, transactionTimer: TransactionTimer)
    operator fun get(sdkTransactionId: SdkTransactionId): TransactionTimer
    fun remove(sdkTransactionId: SdkTransactionId)
    fun clear()

    object Default : TransactionTimerProvider {
        private val transactionTimers: MutableMap<SdkTransactionId, TransactionTimer> = mutableMapOf()

        override fun put(sdkTransactionId: SdkTransactionId, transactionTimer: TransactionTimer) {
            transactionTimers[sdkTransactionId] = transactionTimer
        }

        override operator fun get(sdkTransactionId: SdkTransactionId): TransactionTimer {
            return transactionTimers[sdkTransactionId]
                ?: throw SDKRuntimeException(
                    "No TransactionTimer for transaction id $sdkTransactionId"
                )
        }

        override fun remove(sdkTransactionId: SdkTransactionId) {
            transactionTimers.remove(sdkTransactionId)
        }

        override fun clear() {
            transactionTimers.clear()
        }
    }
}
