package com.stripe.android.stripe3ds2.transaction

import android.content.Intent
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization
import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData
import com.stripe.android.stripe3ds2.views.ChallengeActivity
import com.stripe.android.stripe3ds2.views.ChallengeViewArgs

/**
 * Creates the [Intent] for starting a [ChallengeActivity], and starts it.
 */
class ChallengeStarter constructor(
    private val host: Stripe3ds2ActivityStarterHost,
    creqData: ChallengeRequestData,
    cresData: ChallengeResponseData,
    uiCustomization: StripeUiCustomization,
    creqExecutorConfig: ChallengeRequestExecutor.Config,
    creqExecutorFactory: ChallengeRequestExecutor.Factory,
    errorExecutorFactory: ErrorRequestExecutor.Factory
) {
    private val args = ChallengeViewArgs(
        cresData,
        creqData,
        uiCustomization,
        creqExecutorConfig,
        creqExecutorFactory,
        errorExecutorFactory
    )

    constructor(
        host: Stripe3ds2ActivityStarterHost,
        creqData: ChallengeRequestData,
        cresData: ChallengeResponseData,
        uiCustomization: StripeUiCustomization,
        creqExecutorConfig: ChallengeRequestExecutor.Config
    ) : this(
        host,
        creqData,
        cresData,
        uiCustomization,
        creqExecutorConfig,
        StripeChallengeRequestExecutor.Factory(),
        StripeErrorRequestExecutor.Factory()
    )

    fun start() {
        host.startActivity(
            Intent(host.activity, ChallengeActivity::class.java)
                .putExtras(args.toBundle())
        )
    }
}
