package com.stripe.android.stripe3ds2.views

import android.annotation.TargetApi
import android.net.Uri
import android.os.Build
import android.webkit.URLUtil
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.annotation.VisibleForTesting
import java.util.Locale

/**
 * A [WebViewClient] whose purpose is to block external resources from loading and prevent
 * navigation.
 */
internal class ThreeDS2WebViewClient : WebViewClient() {

    internal var listener: OnHtmlSubmitListener? = null

    override fun shouldInterceptRequest(view: WebView?, url: String): WebResourceResponse? {
        handleFormSubmitUrl(url)

        return if (shouldNotInterceptUrl(url)) {
            super.shouldInterceptRequest(view, url)
        } else {
            WebResourceResponse(null, null, null)
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun shouldInterceptRequest(view: WebView, request: WebResourceRequest): WebResourceResponse? {
        val url = request.url.toString()
        return shouldInterceptRequest(view, url)
    }

    @VisibleForTesting
    fun shouldNotInterceptUrl(url: String): Boolean {
        return URLUtil.isDataUrl(url)
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun shouldOverrideUrlLoading(view: WebView, request: WebResourceRequest): Boolean {
        return shouldOverrideUrlLoading(view, request.url.toString())
    }

    override fun shouldOverrideUrlLoading(view: WebView?, url: String): Boolean {
        handleFormSubmitUrl(url)
        return true
    }

    @VisibleForTesting
    fun handleFormSubmitUrl(url: String) {
        if (url.toLowerCase(Locale.ENGLISH).startsWith(CHALLENGE_URL)) {
            val uri = Uri.parse(url)
            val queryString = uri.query
            listener?.onHtmlSubmit(queryString)
        }
    }

    internal interface OnHtmlSubmitListener {
        fun onHtmlSubmit(data: String?)
    }

    companion object {
        const val CHALLENGE_URL = "https://emv3ds/challenge"
    }
}
