package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData
import com.stripe.android.stripe3ds2.transactions.ErrorData

sealed class ChallengeRequestResult {
    data class Success(
        val creqData: ChallengeRequestData,
        val cresData: ChallengeResponseData
    ) : ChallengeRequestResult()

    data class ProtocolError(
        val data: ErrorData
    ) : ChallengeRequestResult()

    data class RuntimeError(
        val throwable: Throwable
    ) : ChallengeRequestResult()

    data class Timeout(
        val data: ErrorData
    ) : ChallengeRequestResult()
}
