/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;

public abstract class BaseCustomization
implements Customization,
Parcelable {
    @Nullable
    private String mTextFontName;
    @Nullable
    private String mTextColor;
    private int mTextFontSize;

    BaseCustomization() {
    }

    BaseCustomization(@NonNull Parcel in) {
        this.mTextFontName = in.readString();
        this.mTextColor = in.readString();
        this.mTextFontSize = in.readInt();
    }

    @Override
    public void setTextFontName(@NonNull String textFontName) throws InvalidInputException {
        this.mTextFontName = CustomizeUtils.requireValidString(textFontName);
    }

    @Override
    public void setTextColor(@NonNull String textColor) throws InvalidInputException {
        this.mTextColor = CustomizeUtils.requireValidColor(textColor);
    }

    @Override
    public void setTextFontSize(int textFontSize) throws InvalidInputException {
        this.mTextFontSize = CustomizeUtils.requireValidFontSize(textFontSize);
    }

    @Override
    @Nullable
    public String getTextFontName() {
        return this.mTextFontName;
    }

    @Override
    @Nullable
    public String getTextColor() {
        return this.mTextColor;
    }

    @Override
    public int getTextFontSize() {
        return this.mTextFontSize;
    }

    @CallSuper
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mTextFontName);
        dest.writeString(this.mTextColor);
        dest.writeInt(this.mTextFontSize);
    }
}

