/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.util.X509CertChainUtils;
import com.nimbusds.jose.util.X509CertUtils;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.transaction.JwsValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u001a\u001a\u00020\u00032\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator;", "Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;", "isLiveMode", "", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "<init>", "(ZLjava/util/List;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "getPayload", "Lorg/json/JSONObject;", "jws", "", "certificateFromString", "base64", "isValid", "jwsObject", "Lcom/nimbusds/jose/JWSObject;", "getVerifier", "Lcom/nimbusds/jose/JWSVerifier;", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "getPublicKeyFromHeader", "Ljava/security/PublicKey;", "isCertificateChainValid", "encodedChainCerts", "Lcom/nimbusds/jose/util/Base64;", "Companion", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nJwsValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwsValidator.kt\ncom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1611#2,9:214\n1863#2:223\n1864#2:225\n1620#2:226\n1#3:224\n*S KotlinDebug\n*F\n+ 1 JwsValidator.kt\ncom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator\n*L\n72#1:214,9\n72#1:223\n72#1:225\n72#1:226\n72#1:224\n*E\n"})
public final class DefaultJwsValidator
implements JwsValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLiveMode;
    @NotNull
    private final List<X509Certificate> rootCerts;
    @NotNull
    private final ErrorReporter errorReporter;

    public DefaultJwsValidator(boolean isLiveMode, @NotNull List<? extends X509Certificate> rootCerts, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.isLiveMode = isLiveMode;
        this.rootCerts = rootCerts;
        this.errorReporter = errorReporter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JSONObject getPayload(@NotNull String jws) throws JSONException, ParseException, JOSEException, CertificateException {
        Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
        JWSObject jwsObject = JWSObject.parse((String)jws);
        if (!this.isLiveMode) {
            Collection collection = jwsObject.getHeader().getX509CertChain();
            if (!(collection == null || collection.isEmpty())) {
                void $this$mapNotNullTo$iv$iv;
                List list = jwsObject.getHeader().getX509CertChain();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getX509CertChain(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    X509Certificate it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    com.nimbusds.jose.util.Base64 it = (com.nimbusds.jose.util.Base64)element$iv$iv;
                    boolean bl2 = false;
                    String string2 = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    if (this.certificateFromString(string2) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List certificates = (List)destination$iv$iv;
                if (!((Collection)certificates).isEmpty()) {
                    Intrinsics.checkNotNull((Object)jwsObject);
                    if (this.isValid(jwsObject, certificates)) {
                        return new JSONObject(jwsObject.getPayload().toString());
                    }
                }
                throw new IllegalStateException("Could not validate JWS");
            }
            return new JSONObject(jwsObject.getPayload().toString());
        }
        Intrinsics.checkNotNull((Object)jwsObject);
        if (this.isValid(jwsObject, this.rootCerts)) {
            return new JSONObject(jwsObject.getPayload().toString());
        }
        throw new IllegalStateException("Could not validate JWS");
    }

    private final X509Certificate certificateFromString(String base64) {
        byte[] decoded = Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)base64, (int)0, (int)0, (int)6, null);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
        Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
        return certificate instanceof X509Certificate ? (X509Certificate)certificate : null;
    }

    private final boolean isValid(JWSObject jwsObject, List<? extends X509Certificate> rootCerts) throws JOSEException, CertificateException {
        if (jwsObject.getHeader().getJWK() != null) {
            this.errorReporter.reportError(new IllegalArgumentException("Encountered a JWK in " + jwsObject.getHeader()));
        }
        JWSHeader jWSHeader = jwsObject.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"getHeader(...)");
        JWSHeader jwsHeader = Companion.sanitizedJwsHeader$3ds2sdk_release(jWSHeader);
        if (!this.isCertificateChainValid(jwsHeader.getX509CertChain(), rootCerts)) {
            return false;
        }
        JWSVerifier verifier = this.getVerifier(jwsHeader);
        return jwsObject.verify(verifier);
    }

    private final JWSVerifier getVerifier(JWSHeader jwsHeader) throws JOSEException, CertificateException {
        DefaultJWSVerifierFactory verifierFactory = new DefaultJWSVerifierFactory();
        String supportAlgorithm = Intrinsics.areEqual((Object)jwsHeader.getAlgorithm(), (Object)JWSAlgorithm.ES256) ? "SHA256withECDSA" : "SHA256withRSA";
        verifierFactory.getJCAContext().setProvider(Signature.getInstance(supportAlgorithm).getProvider());
        JWSVerifier jWSVerifier = verifierFactory.createJWSVerifier(jwsHeader, (Key)this.getPublicKeyFromHeader(jwsHeader));
        Intrinsics.checkNotNullExpressionValue((Object)jWSVerifier, (String)"createJWSVerifier(...)");
        return jWSVerifier;
    }

    private final PublicKey getPublicKeyFromHeader(JWSHeader jwsHeader) throws CertificateException {
        List list = jwsHeader.getX509CertChain();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getX509CertChain(...)");
        PublicKey publicKey = X509CertUtils.parseWithException((byte[])((com.nimbusds.jose.util.Base64)CollectionsKt.first((List)list)).decode()).getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublicKey(...)");
        return publicKey;
    }

    @VisibleForTesting
    public final boolean isCertificateChainValid(@Nullable List<? extends com.nimbusds.jose.util.Base64> encodedChainCerts, @NotNull List<? extends X509Certificate> rootCerts) {
        Object object;
        block4: {
            Object object2;
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            object = this;
            try {
                DefaultJwsValidator $this$isCertificateChainValid_u24lambda_u243 = object;
                boolean bl = false;
                Collection collection = encodedChainCerts;
                if (!(!(collection == null || collection.isEmpty()))) {
                    boolean $i$a$-require-DefaultJwsValidator$isCertificateChainValid$1$32 = false;
                    String $i$a$-require-DefaultJwsValidator$isCertificateChainValid$1$32 = "JWSHeader's X.509 certificate chain is null or empty";
                    throw new IllegalArgumentException($i$a$-require-DefaultJwsValidator$isCertificateChainValid$1$32.toString());
                }
                if (!(!((Collection)rootCerts).isEmpty())) {
                    boolean bl2 = false;
                    String string2 = "Root certificates are empty";
                    throw new IllegalArgumentException(string2.toString());
                }
                DefaultJwsValidator.Companion.validateChain(encodedChainCerts, rootCerts);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block4;
            Object it = object2 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        return Result.isSuccess-impl((Object)object);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator$Companion;", "", "<init>", "()V", "validateChain", "", "encodedChainCerts", "", "Lcom/nimbusds/jose/util/Base64;", "rootCerts", "Ljava/security/cert/X509Certificate;", "createKeyStore", "Ljava/security/KeyStore;", "sanitizedJwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "jwsHeader", "sanitizedJwsHeader$3ds2sdk_release", "3ds2sdk_release"})
    @SourceDebugExtension(value={"SMAP\nJwsValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwsValidator.kt\ncom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1872#2,3:214\n*S KotlinDebug\n*F\n+ 1 JwsValidator.kt\ncom/stripe/android/stripe3ds2/transaction/DefaultJwsValidator$Companion\n*L\n194#1:214,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void validateChain(List<? extends com.nimbusds.jose.util.Base64> encodedChainCerts, List<? extends X509Certificate> rootCerts) throws GeneralSecurityException, IOException, ParseException {
            List chainCerts = X509CertChainUtils.parse(encodedChainCerts);
            KeyStore keyStore = this.createKeyStore(rootCerts);
            X509CertSelector target = new X509CertSelector();
            target.setCertificate((X509Certificate)chainCerts.get(0));
            PKIXBuilderParameters params = new PKIXBuilderParameters(keyStore, (CertSelector)target);
            params.setRevocationEnabled(false);
            params.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(chainCerts)));
            CertPathBuilder.getInstance("PKIX").build(params);
        }

        @VisibleForTesting
        @NotNull
        public final KeyStore createKeyStore(@NotNull List<? extends X509Certificate> rootCerts) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            Iterable $this$forEachIndexed$iv = rootCerts;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                X509Certificate cfr_ignored_0 = (X509Certificate)item$iv;
                int index = n;
                boolean bl = false;
                Locale locale = Locale.ROOT;
                String string2 = "ca_%d";
                Object[] objectArray = new Object[]{index};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                keyStore.setCertificateEntry(string3, rootCerts.get(index));
            }
            Intrinsics.checkNotNull((Object)keyStore);
            return keyStore;
        }

        @NotNull
        public final JWSHeader sanitizedJwsHeader$3ds2sdk_release(@NotNull JWSHeader jwsHeader) {
            Intrinsics.checkNotNullParameter((Object)jwsHeader, (String)"jwsHeader");
            JWSHeader jWSHeader = new JWSHeader.Builder(jwsHeader).jwk(null).build();
            Intrinsics.checkNotNullExpressionValue((Object)jWSHeader, (String)"build(...)");
            return jWSHeader;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

