/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.jwk.Curve;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.Algorithm;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.ECGenParameterSpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/security/StripeEphemeralKeyPairGenerator;", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "<init>", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "generate", "Ljava/security/KeyPair;", "Companion", "3ds2sdk_release"})
public final class StripeEphemeralKeyPairGenerator
implements EphemeralKeyPairGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private static final String ALGORITHM = Algorithm.EC.toString();

    public StripeEphemeralKeyPairGenerator(@NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
    }

    @Override
    @NotNull
    public KeyPair generate() {
        Object $this$generate_u24lambda_u240;
        Object object = this;
        try {
            $this$generate_u24lambda_u240 = object;
            boolean bl = false;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGenerator.initialize(new ECGenParameterSpec(Curve.P_256.getStdName()));
            $this$generate_u24lambda_u240 = Result.constructor-impl((Object)keyPairGenerator.generateKeyPair());
        }
        catch (Throwable bl) {
            $this$generate_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$generate_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$generate_u24lambda_u240 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (KeyPair)object2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/security/StripeEphemeralKeyPairGenerator$Companion;", "", "<init>", "()V", "ALGORITHM", "", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

