/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init;

import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "", "warning", "Lcom/stripe/android/stripe3ds2/init/Warning;", "<init>", "(Lcom/stripe/android/stripe3ds2/init/Warning;)V", "getWarning", "()Lcom/stripe/android/stripe3ds2/init/Warning;", "check", "", "RootedCheck", "Tampered", "Emulator", "DebuggerAttached", "UnsupportedOS", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "3ds2sdk_release"})
public abstract class SecurityCheck {
    @NotNull
    private final Warning warning;

    private SecurityCheck(Warning warning) {
        this.warning = warning;
    }

    @NotNull
    public final Warning getWarning() {
        return this.warning;
    }

    public abstract boolean check();

    public /* synthetic */ SecurityCheck(Warning warning, DefaultConstructorMarker $constructor_marker) {
        this(warning);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "isDebuggerConnected", "", "<init>", "(Z)V", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class DebuggerAttached
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private final boolean isDebuggerConnected;
        @NotNull
        private static final Warning WARNING = new Warning("SW04", "A debugger is attached to the App.", Warning.Severity.MEDIUM);

        public DebuggerAttached(boolean isDebuggerConnected) {
            super(WARNING, null);
            this.isDebuggerConnected = isDebuggerConnected;
        }

        public /* synthetic */ DebuggerAttached(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = Debug.isDebuggerConnected();
            }
            this(bl);
        }

        public final boolean isDebuggerConnected() {
            return this.isDebuggerConnected;
        }

        @Override
        public boolean check() {
            return this.isDebuggerConnected;
        }

        public DebuggerAttached() {
            this(false, 1, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached$Companion;", "", "<init>", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "<init>", "()V", "isEmulator", "", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class Emulator
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Warning WARNING = new Warning("SW02", "An emulator is being used to run the App.", Warning.Severity.HIGH);

        public Emulator() {
            super(WARNING, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmulator() {
            String string = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
            if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
            String string2 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FINGERPRINT");
            if (StringsKt.startsWith$default((String)string2, (String)"unknown", (boolean)false, (int)2, null)) return true;
            String string3 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
            String string4 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
            String string5 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
            String string6 = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MANUFACTURER");
            if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
            String string7 = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"BRAND");
            if (StringsKt.startsWith$default((String)string7, (String)"generic", (boolean)false, (int)2, null)) {
                String string8 = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"DEVICE");
                if (StringsKt.startsWith$default((String)string8, (String)"generic", (boolean)false, (int)2, null)) return true;
            }
            if (!Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) return false;
            return true;
        }

        @Override
        public boolean check() {
            return this.isEmulator();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator$Companion;", "", "<init>", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "<init>", "()V", "check", "", "findSuBinary", "findSuperuserApk", "Companion", "3ds2sdk_release"})
    @SourceDebugExtension(value={"SMAP\nSecurityCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityCheck.kt\ncom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1755#2,3:125\n*S KotlinDebug\n*F\n+ 1 SecurityCheck.kt\ncom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck\n*L\n22#1:125,3\n*E\n"})
    public static final class RootedCheck
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<String> BINARY_PATHS;
        @NotNull
        private static final Warning WARNING;

        public RootedCheck() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return this.findSuBinary() || this.findSuperuserApk();
        }

        private final boolean findSuBinary() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = BINARY_PATHS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!new File(it + "su").exists()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean findSuperuserApk() {
            return new File(Environment.getRootDirectory() + "/Superuser").isDirectory();
        }

        static {
            Object[] objectArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"};
            BINARY_PATHS = CollectionsKt.listOf((Object[])objectArray);
            WARNING = new Warning("SW01", "The device is jailbroken.", Warning.Severity.HIGH);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck$Companion;", "", "<init>", "()V", "BINARY_PATHS", "", "", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "<init>", "()V", "check", "", "hasValidFields", "hasValidMethods", "Companion", "3ds2sdk_release"})
    @SourceDebugExtension(value={"SMAP\nSecurityCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityCheck.kt\ncom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n3829#2:125\n4344#2,2:126\n3829#2:128\n4344#2,2:129\n*S KotlinDebug\n*F\n+ 1 SecurityCheck.kt\ncom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered\n*L\n55#1:125\n55#1:126,2\n60#1:128\n60#1:129,2\n*E\n"})
    public static final class Tampered
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Warning WARNING = new Warning("SW02", "The integrity of the SDK has been tampered.", Warning.Severity.HIGH);

        public Tampered() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return !this.hasValidFields() || !this.hasValidMethods();
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasValidFields() {
            void $this$filterTo$iv$iv;
            Field[] fieldArray = StripeThreeDs2ServiceImpl.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(!it.isSynthetic())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int fieldCount = ((List)destination$iv$iv).size();
            return fieldCount == 8;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasValidMethods() {
            void $this$filterTo$iv$iv;
            Method[] methodArray = StripeThreeDs2ServiceImpl.class.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                if (!(!it.isSynthetic())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int methodCount = ((List)destination$iv$iv).size();
            return methodCount == 5;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered$Companion;", "", "<init>", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "<init>", "()V", "check", "", "Companion", "3ds2sdk_release"})
    public static final class UnsupportedOS
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Warning WARNING = new Warning("SW05", "The OS or the OS version is not supported.", Warning.Severity.HIGH);

        public UnsupportedOS() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return false;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS$Companion;", "", "<init>", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

