/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.stripe.android.stripe3ds2.security.MessageTransformer;
import com.stripe.android.stripe3ds2.security.TransactionEncrypter;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseParseException;
import com.stripe.android.stripe3ds2.transactions.ProtocolError;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 02\u00020\u0001:\u00010B!\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b$J\t\u0010%\u001a\u00020\u0003H\u00c2\u0003J\t\u0010&\u001a\u00020\u0005H\u00c2\u0003J\t\u0010'\u001a\u00020\u0005H\u00c2\u0003J,\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c0\u0001\u00a2\u0006\u0002\b)J\u0013\u0010*\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/android/stripe3ds2/security/DefaultMessageTransformer;", "Lcom/stripe/android/stripe3ds2/security/MessageTransformer;", "isLiveMode", "", "counterSdkToAcs", "", "counterAcsToSdk", "<init>", "(ZBB)V", "(Z)V", "encrypt", "", "challengeRequest", "Lorg/json/JSONObject;", "secretKey", "Ljavax/crypto/SecretKey;", "decrypt", "message", "validateAcsToSdkCounter", "", "cres", "validateAcsToSdkCounter$3ds2sdk_release", "decryptMessage", "decryptMessage$3ds2sdk_release", "createEncryptionHeader", "Lcom/nimbusds/jose/JWEHeader;", "keyId", "createEncryptionHeader$3ds2sdk_release", "isValidPayloadPart", "part", "getDecryptionKey", "", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "getDecryptionKey$3ds2sdk_release", "getEncryptionKey", "getEncryptionKey$3ds2sdk_release", "component1", "component2", "component3", "copy", "copy$3ds2sdk_release", "equals", "other", "", "hashCode", "", "toString", "Companion", "3ds2sdk_release"})
public final class DefaultMessageTransformer
implements MessageTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLiveMode;
    private byte counterSdkToAcs;
    private byte counterAcsToSdk;
    @NotNull
    public static final String FIELD_ACS_COUNTER_ACS_TO_SDK = "acsCounterAtoS";
    @NotNull
    public static final String FIELD_SDK_COUNTER_SDK_TO_ACS = "sdkCounterStoA";
    private static final EncryptionMethod ENCRYPTION_METHOD = EncryptionMethod.A128CBC_HS256;
    public static final int BITS_IN_BYTE = 8;

    @VisibleForTesting
    public DefaultMessageTransformer(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        this.isLiveMode = isLiveMode;
        this.counterSdkToAcs = counterSdkToAcs;
        this.counterAcsToSdk = counterAcsToSdk;
    }

    public DefaultMessageTransformer(boolean isLiveMode) {
        this(isLiveMode, 0, 0);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull JSONObject challengeRequest, @NotNull SecretKey secretKey) throws JOSEException, JSONException {
        Intrinsics.checkNotNullParameter((Object)challengeRequest, (String)"challengeRequest");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        String string = challengeRequest.getString("acsTransID");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        JWEHeader header = this.createEncryptionHeader$3ds2sdk_release(string);
        Locale locale = Locale.ROOT;
        String string2 = "%03d";
        Object[] objectArray = new Object[]{this.counterSdkToAcs};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        challengeRequest.put(FIELD_SDK_COUNTER_SDK_TO_ACS, (Object)string3);
        JWEObject jweObject = new JWEObject(header, new Payload(challengeRequest.toString()));
        EncryptionMethod encryptionMethod = header.getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)encryptionMethod, (String)"getEncryptionMethod(...)");
        jweObject.encrypt((JWEEncrypter)new TransactionEncrypter(this.getEncryptionKey$3ds2sdk_release(secretKey, encryptionMethod), this.counterSdkToAcs));
        byte by = this.counterSdkToAcs;
        this.counterSdkToAcs = (byte)(by + 1);
        if (!(this.counterSdkToAcs != 0)) {
            boolean bl = false;
            String string4 = "SDK to ACS counter is zero";
            throw new IllegalArgumentException(string4.toString());
        }
        String string5 = jweObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"serialize(...)");
        return string5;
    }

    @Override
    @NotNull
    public JSONObject decrypt(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException, ChallengeResponseParseException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        JSONObject challengeResponse = this.decryptMessage$3ds2sdk_release(message, secretKey);
        this.validateAcsToSdkCounter$3ds2sdk_release(challengeResponse);
        byte by = this.counterAcsToSdk;
        this.counterAcsToSdk = (byte)(by + 1);
        if (!(this.counterAcsToSdk != 0)) {
            boolean bl = false;
            String string = "ACS to SDK counter is zero";
            throw new IllegalArgumentException(string.toString());
        }
        return challengeResponse;
    }

    @VisibleForTesting
    public final void validateAcsToSdkCounter$3ds2sdk_release(@NotNull JSONObject cres) throws ChallengeResponseParseException, JSONException {
        Object $this$validateAcsToSdkCounter_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)cres, (String)"cres");
        if (!this.isLiveMode) {
            return;
        }
        if (!cres.has(FIELD_ACS_COUNTER_ACS_TO_SDK)) {
            throw ChallengeResponseParseException.Companion.createRequiredDataElementMissing(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        Object object = this;
        try {
            $this$validateAcsToSdkCounter_u24lambda_u242 = object;
            boolean bl = false;
            String string = cres.getString(FIELD_ACS_COUNTER_ACS_TO_SDK);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            $this$validateAcsToSdkCounter_u24lambda_u242 = Result.constructor-impl((Object)Byte.parseByte(string));
        }
        catch (Throwable bl) {
            $this$validateAcsToSdkCounter_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$validateAcsToSdkCounter_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw ChallengeResponseParseException.Companion.createInvalidDataElementFormat(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        byte acsCounterAcsToSdk = ((Number)object).byteValue();
        if (this.counterAcsToSdk != acsCounterAcsToSdk) {
            throw new ChallengeResponseParseException(ProtocolError.DataDecryptionFailure, "Counters are not equal. SDK counter: " + this.counterAcsToSdk + ", ACS counter: " + acsCounterAcsToSdk);
        }
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @NotNull
    public final JSONObject decryptMessage$3ds2sdk_release(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        jweObject = JWEObject.parse((String)message);
        v0 = jweObject.getHeader().getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getEncryptionMethod(...)");
        key = this.getDecryptionKey$3ds2sdk_release(secretKey, v0);
        jweObject.decrypt((JWEDecrypter)new DirectDecrypter(key));
        v1 = jweObject.getHeader().toString();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
        if (!this.isValidPayloadPart(v1)) ** GOTO lbl-1000
        v2 = jweObject.getIV().toString();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
        if (!this.isValidPayloadPart(v2)) ** GOTO lbl-1000
        v3 = jweObject.getCipherText().toString();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
        if (!this.isValidPayloadPart(v3)) ** GOTO lbl-1000
        v4 = jweObject.getAuthTag().toString();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toString(...)");
        if (!this.isValidPayloadPart(v4)) lbl-1000:
        // 4 sources

        {
            v5 = true;
        } else {
            v5 = invalidPayload = false;
        }
        if (invalidPayload) {
            throw new ChallengeResponseParseException(ProtocolError.DataDecryptionFailure, "Invalid encryption.");
        }
        return new JSONObject(jweObject.getPayload().toString());
    }

    @VisibleForTesting
    @NotNull
    public final JWEHeader createEncryptionHeader$3ds2sdk_release(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWEHeader jWEHeader = new JWEHeader.Builder(JWEAlgorithm.DIR, ENCRYPTION_METHOD).keyID(keyId).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWEHeader, (String)"build(...)");
        return jWEHeader;
    }

    private final boolean isValidPayloadPart(String part) {
        return !StringsKt.endsWith$default((String)part, (String)"=", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)part, (CharSequence)" ", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)part, (CharSequence)"+", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)part, (CharSequence)"\n", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)part, (CharSequence)"/", (boolean)false, (int)2, null);
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getDecryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, encodedKey.length - EncryptionMethod.A128GCM.cekBitLength() / 8, encodedKey.length);
            Intrinsics.checkNotNull((Object)byArray2);
            byArray = byArray2;
        } else {
            byte[] byArray3 = encodedKey;
            Intrinsics.checkNotNull((Object)byArray3);
            byArray = byArray3;
        }
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getEncryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, 0, EncryptionMethod.A128GCM.cekBitLength() / 8);
            Intrinsics.checkNotNull((Object)byArray2);
            byArray = byArray2;
        } else {
            byte[] byArray3 = encodedKey;
            Intrinsics.checkNotNull((Object)byArray3);
            byArray = byArray3;
        }
        return byArray;
    }

    private final boolean component1() {
        return this.isLiveMode;
    }

    private final byte component2() {
        return this.counterSdkToAcs;
    }

    private final byte component3() {
        return this.counterAcsToSdk;
    }

    @NotNull
    public final DefaultMessageTransformer copy$3ds2sdk_release(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        return new DefaultMessageTransformer(isLiveMode, counterSdkToAcs, counterAcsToSdk);
    }

    public static /* synthetic */ DefaultMessageTransformer copy$3ds2sdk_release$default(DefaultMessageTransformer defaultMessageTransformer, boolean bl, byte by, byte by2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = defaultMessageTransformer.isLiveMode;
        }
        if ((n & 2) != 0) {
            by = defaultMessageTransformer.counterSdkToAcs;
        }
        if ((n & 4) != 0) {
            by2 = defaultMessageTransformer.counterAcsToSdk;
        }
        return defaultMessageTransformer.copy$3ds2sdk_release(bl, by, by2);
    }

    @NotNull
    public String toString() {
        return "DefaultMessageTransformer(isLiveMode=" + this.isLiveMode + ", counterSdkToAcs=" + this.counterSdkToAcs + ", counterAcsToSdk=" + this.counterAcsToSdk + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.isLiveMode);
        result = result * 31 + Byte.hashCode(this.counterSdkToAcs);
        result = result * 31 + Byte.hashCode(this.counterAcsToSdk);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultMessageTransformer)) {
            return false;
        }
        DefaultMessageTransformer defaultMessageTransformer = (DefaultMessageTransformer)other;
        if (this.isLiveMode != defaultMessageTransformer.isLiveMode) {
            return false;
        }
        if (this.counterSdkToAcs != defaultMessageTransformer.counterSdkToAcs) {
            return false;
        }
        return this.counterAcsToSdk == defaultMessageTransformer.counterAcsToSdk;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/stripe3ds2/security/DefaultMessageTransformer$Companion;", "", "<init>", "()V", "FIELD_ACS_COUNTER_ACS_TO_SDK", "", "FIELD_SDK_COUNTER_SDK_TO_ACS", "ENCRYPTION_METHOD", "Lcom/nimbusds/jose/EncryptionMethod;", "kotlin.jvm.PlatformType", "Lcom/nimbusds/jose/EncryptionMethod;", "BITS_IN_BYTE", "", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

