/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.service;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.a.i;
import com.stripe.android.stripe3ds2.a.l;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.exceptions.SDKAlreadyInitializedException;
import com.stripe.android.stripe3ds2.exceptions.SDKNotInitializedException;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.init.c;
import com.stripe.android.stripe3ds2.init.d;
import com.stripe.android.stripe3ds2.init.e;
import com.stripe.android.stripe3ds2.init.g;
import com.stripe.android.stripe3ds2.init.h;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.b;
import com.stripe.android.stripe3ds2.transaction.j;
import com.stripe.android.stripe3ds2.transaction.r;
import com.stripe.android.stripe3ds2.transaction.s;
import com.stripe.android.stripe3ds2.transaction.v;
import com.stripe.android.stripe3ds2.utils.a;
import com.stripe.android.stripe3ds2.views.j;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;

public final class StripeThreeDs2ServiceImpl
implements StripeThreeDs2Service {
    @Nullable
    @VisibleForTesting
    StripeUiCustomization a;
    @NonNull
    private final AtomicBoolean b = new AtomicBoolean(false);
    @NonNull
    private final h c = new h();
    @NonNull
    private final s d;
    @NonNull
    private final com.stripe.android.stripe3ds2.a.j e;
    @NonNull
    private final MessageVersionRegistry f;
    @NonNull
    private final a g;
    @NonNull
    private final com.stripe.android.stripe3ds2.transaction.h h;
    @NonNull
    private final v i;
    @NonNull
    private final e j;
    private final boolean k;

    public StripeThreeDs2ServiceImpl(@NonNull Context context) {
        this(context, null);
    }

    public StripeThreeDs2ServiceImpl(@NonNull Context context, @Nullable SSLSocketFactory sSLSocketFactory) {
        this(context, "3DS_LOA_SDK_STIN_020100_00142", sSLSocketFactory);
    }

    public StripeThreeDs2ServiceImpl(@NonNull Context context, @NonNull String string, @Nullable SSLSocketFactory sSLSocketFactory) {
        this(context, new e(context), com.stripe.android.stripe3ds2.utils.a.a(), com.stripe.android.stripe3ds2.transaction.h.a(), v.a(), string, sSLSocketFactory);
    }

    private StripeThreeDs2ServiceImpl(@NonNull Context context, @NonNull e e2, @NonNull a object, @NonNull com.stripe.android.stripe3ds2.transaction.h object2, @NonNull v v2, @NonNull String string, @Nullable SSLSocketFactory sSLSocketFactory) {
        this.k = false;
        this.g = object;
        this.h = object2;
        this.i = v2;
        this.j = e2;
        object = new l();
        this.f = new MessageVersionRegistry();
        this.e = new com.stripe.android.stripe3ds2.a.j(context);
        object2 = new d(context);
        this.d = new s(new b(new com.stripe.android.stripe3ds2.init.a(context.getApplicationContext(), e2, (d)object2, this.k), new c(context.getApplicationContext(), e2, (d)object2), this.c, (com.stripe.android.stripe3ds2.a.e)object, new g(context), this.f, string), (com.stripe.android.stripe3ds2.a.e)object, this.f, string);
        if (sSLSocketFactory != null) {
            com.stripe.android.stripe3ds2.transaction.j.a = sSLSocketFactory;
        }
    }

    @Override
    public final void initialize(@NonNull Context object, @NonNull ConfigParameters creator, @Nullable String string, @Nullable UiCustomization uiCustomization) throws InvalidInputException, SDKAlreadyInitializedException, SDKRuntimeException {
        if (!this.b.compareAndSet(false, true)) {
            throw new SDKAlreadyInitializedException(new RuntimeException());
        }
        if (creator == null) {
            throw new InvalidInputException(new RuntimeException("ConfigParameters must be not null"));
        }
        if (uiCustomization == null || uiCustomization instanceof StripeUiCustomization) {
            StripeUiCustomization stripeUiCustomization;
            if (uiCustomization != null) {
                creator = StripeUiCustomization.CREATOR;
                object = (StripeUiCustomization)uiCustomization;
                string = Parcel.obtain();
                object.writeToParcel((Parcel)string, object.describeContents());
                string.setDataPosition(0);
                stripeUiCustomization = (StripeUiCustomization)((Parcelable)creator.createFromParcel((Parcel)string));
            } else {
                stripeUiCustomization = null;
            }
            this.a = stripeUiCustomization;
            return;
        }
        throw new InvalidInputException(new RuntimeException("UiCustomization must be an instance of StripeUiCustomization"));
    }

    @Override
    @NonNull
    public final Transaction createTransaction(@NonNull String string, @Nullable String string2) {
        return this.createTransaction(string, string2, true, "visa");
    }

    @Override
    @NonNull
    public final Transaction createTransaction(@NonNull String string, @Nullable String string2, boolean bl, @NonNull String string3) throws InvalidInputException, SDKNotInitializedException, SDKRuntimeException {
        Object object = string;
        Object object2 = this.e;
        object = com.stripe.android.stripe3ds2.a.c.a(object);
        object2 = ((com.stripe.android.stripe3ds2.a.c)((Object)object)).j ? ((com.stripe.android.stripe3ds2.a.j)object2).a(((com.stripe.android.stripe3ds2.a.c)((Object)object)).i).getPublicKey() : ((com.stripe.android.stripe3ds2.a.j)object2).a(((com.stripe.android.stripe3ds2.a.c)((Object)object)).i, ((com.stripe.android.stripe3ds2.a.c)((Object)object)).h);
        return this.createTransaction(string, string2, bl, string3, Collections.emptyList(), (PublicKey)object2, null);
    }

    @Override
    @NonNull
    public final Transaction createTransaction(@NonNull String object, @Nullable String object2, boolean bl, @NonNull String object3, @NonNull List<X509Certificate> object4, @NonNull PublicKey publicKey, @Nullable String string2) throws InvalidInputException, SDKNotInitializedException, SDKRuntimeException {
        String string3;
        PublicKey publicKey2;
        this.a();
        if (!this.f.isSupported((String)object2)) {
            throw new InvalidInputException(new RuntimeException("Message version is unsupported: ".concat(String.valueOf(object2))));
        }
        if (this.k) {
            object2 = this.j;
            if (((e)object2).a != null) {
                if (((e)object2).c) {
                    ((e)object2).b = ((e)object2).a.getLastKnownLocation("gps");
                }
                if (((e)object2).b == null) {
                    ((e)object2).b = ((e)object2).a.getLastKnownLocation("network");
                }
                if (((e)object2).c && ((e)object2).b == null) {
                    ((e)object2).b = ((e)object2).a.getLastKnownLocation("passive");
                }
                if (((e)object2).b == null) {
                    LocationManager locationManager = ((e)object2).a;
                    publicKey2 = new Criteria();
                    publicKey2.setAccuracy(2);
                    string3 = locationManager.getBestProvider((Criteria)publicKey2, true);
                    if (string3 != null) {
                        ((e)object2).a.requestSingleUpdate(string3, new LocationListener(){

                            public final void onLocationChanged(Location location) {
                                e.this.b = location;
                            }

                            public final void onStatusChanged(String string, int n2, Bundle bundle) {
                            }

                            public final void onProviderEnabled(String string) {
                            }

                            public final void onProviderDisabled(String string) {
                            }
                        }, Looper.getMainLooper());
                    }
                }
            }
        }
        object2 = UUID.randomUUID().toString();
        object3 = j.a.a(object3);
        String string4 = object;
        List<X509Certificate> list = object4;
        String string5 = string2;
        string2 = object3;
        boolean bl2 = bl;
        object4 = this.a;
        object3 = object2;
        String string6 = string5;
        publicKey2 = publicKey;
        object = list;
        string3 = string4;
        object2 = this.d;
        KeyPair keyPair = ((s)object2).e.a();
        i i2 = new i(bl2);
        return new r(((s)object2).a, ((s)object2).b, ((s)object2).f, ((s)object2).g, ((s)object2).h, ((s)object2).c, ((s)object2).d, string3, publicKey2, string6, (String)object3, keyPair, bl2, (List<X509Certificate>)object, i2, (StripeUiCustomization)object4, (j.a)((Object)string2));
    }

    @Override
    public final void cleanup(@NonNull Context context) throws SDKNotInitializedException {
        this.a();
        this.g.a.evictAll();
        this.h.a.clear();
        this.i.a.clear();
    }

    @Override
    @NonNull
    public final String getSDKVersion() throws SDKNotInitializedException, SDKRuntimeException {
        this.a();
        return "1.0.0";
    }

    @Override
    @NonNull
    public final List<Warning> getWarnings() {
        return this.c.a();
    }

    private void a() {
        if (!this.b.get()) {
            throw new SDKNotInitializedException(new RuntimeException());
        }
    }
}

