/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ProgressBar;
import com.stripe.android.stripe3ds2.R;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import java.util.Locale;

public final class CustomizeUtils {
    public static void applyProgressBarColor(@NonNull ProgressBar progressBar) {
        Context context = progressBar.getContext();
        TypedValue typedValue = new TypedValue();
        int n2 = context.getTheme().resolveAttribute(R.attr.stripe3DS2ProgressBarColor, typedValue, true) ? (typedValue.resourceId == 0 ? typedValue.data : ContextCompat.getColor((Context)context, (int)typedValue.resourceId)) : ContextCompat.getColor((Context)context, (int)R.color.stripe_3ds2_progress_bar);
        if (Build.VERSION.SDK_INT >= 21) {
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n2));
            return;
        }
        typedValue = progressBar.getIndeterminateDrawable().mutate();
        typedValue.setColorFilter(n2, PorterDuff.Mode.SRC_IN);
        progressBar.setIndeterminateDrawable((Drawable)typedValue);
    }

    public static void setStatusBarColor(@NonNull AppCompatActivity appCompatActivity, @ColorInt int n2) {
        if (Build.VERSION.SDK_INT >= 21) {
            appCompatActivity.getWindow().setStatusBarColor(CustomizeUtils.darken(n2));
        }
    }

    public static int darken(@ColorInt int n2) {
        return CustomizeUtils.darken(n2, 0.8f);
    }

    @ColorInt
    public static int darken(@ColorInt int n2, float f2) {
        int n3 = Color.alpha((int)n2);
        int n4 = (int)((float)Color.red((int)n2) * f2);
        int n5 = (int)((float)Color.green((int)n2) * f2);
        n2 = (int)((float)Color.blue((int)n2) * f2);
        return Color.argb((int)n3, (int)Math.min(Math.max(n4, 0), 255), (int)Math.min(Math.max(n5, 0), 255), (int)Math.min(Math.max(n2, 0), 255));
    }

    @NonNull
    public static String colorIntToHex(@ColorInt int n2) {
        int n3 = Color.alpha((int)n2);
        int n4 = Color.blue((int)n2);
        int n5 = Color.green((int)n2);
        n2 = Color.red((int)n2);
        return "#" + String.format(Locale.ENGLISH, "%02X", n3) + String.format(Locale.ENGLISH, "%02X", n2) + String.format(Locale.ENGLISH, "%02X", n5) + String.format(Locale.ENGLISH, "%02X", n4);
    }

    @NonNull
    public static SpannableString buildStyledText(@NonNull Context context, @NonNull String string, @NonNull Customization customization) {
        ForegroundColorSpan foregroundColorSpan;
        string = new SpannableString((CharSequence)string);
        if (customization.getTextColor() != null) {
            int n2 = Color.parseColor((String)customization.getTextColor());
            foregroundColorSpan = new ForegroundColorSpan(n2);
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        if (customization.getTextFontSize() > 0) {
            int n3 = (int)TypedValue.applyDimension((int)2, (float)customization.getTextFontSize(), (DisplayMetrics)context.getResources().getDisplayMetrics());
            foregroundColorSpan = new AbsoluteSizeSpan(n3);
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        if (customization.getTextFontName() != null) {
            foregroundColorSpan = new TypefaceSpan(customization.getTextFontName());
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        return string;
    }
}

