/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.design.button.MaterialButton;
import android.util.AttributeSet;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;

public class ThreeDS2Button
extends MaterialButton {
    public ThreeDS2Button(Context context) {
        this(context, null);
    }

    public ThreeDS2Button(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ThreeDS2Button(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    void setButtonCustomization(@Nullable ButtonCustomization buttonCustomization) {
        int n2;
        if (buttonCustomization == null) {
            return;
        }
        if (buttonCustomization.getTextColor() != null) {
            this.setTextColor(Color.parseColor((String)buttonCustomization.getTextColor()));
        }
        if (buttonCustomization.getBackgroundColor() != null) {
            ColorStateList colorStateList = ColorStateList.valueOf((int)Color.parseColor((String)buttonCustomization.getBackgroundColor()));
            this.setBackgroundTintList(colorStateList);
        }
        if ((n2 = buttonCustomization.getCornerRadius()) >= 0) {
            this.setCornerRadius(n2);
        }
        if (buttonCustomization.getTextFontSize() > 0) {
            this.setTextSize(2, buttonCustomization.getTextFontSize());
        }
        if (buttonCustomization.getTextFontName() != null) {
            Typeface typeface = Typeface.create((String)buttonCustomization.getTextFontName(), (int)0);
            this.setTypeface(typeface);
        }
    }
}

