/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.viewmodels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentOptionsItem;
import com.stripe.android.paymentsheet.PaymentOptionsStateFactory;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bs\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u001a\u0010\t\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010\u00a2\u0006\u0002\u0010\u0011J=\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0003H\u0086\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\f\u0012\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/viewmodels/PaymentOptionsItemsMapper;", "", "customerState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "isGooglePayReady", "", "isLinkEnabled", "canRemovePaymentMethods", "nameProvider", "Lkotlin/Function1;", "", "Lcom/stripe/android/model/PaymentMethodCode;", "Lcom/stripe/android/core/strings/ResolvableString;", "isNotPaymentFlow", "isCbcEligible", "Lkotlin/Function0;", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlin/jvm/functions/Function1;ZLkotlin/jvm/functions/Function0;)V", "createPaymentOptionsItems", "", "Lcom/stripe/android/paymentsheet/PaymentOptionsItem;", "paymentMethods", "Lcom/stripe/android/model/PaymentMethod;", "(Ljava/util/List;Ljava/lang/Boolean;ZZ)Ljava/util/List;", "invoke", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class PaymentOptionsItemsMapper {
    @NotNull
    private final StateFlow<CustomerState> customerState;
    @NotNull
    private final StateFlow<Boolean> isGooglePayReady;
    @NotNull
    private final StateFlow<Boolean> isLinkEnabled;
    @NotNull
    private final StateFlow<Boolean> canRemovePaymentMethods;
    @NotNull
    private final Function1<String, ResolvableString> nameProvider;
    private final boolean isNotPaymentFlow;
    @NotNull
    private final Function0<Boolean> isCbcEligible;
    public static final int $stable = 8;

    public PaymentOptionsItemsMapper(@NotNull StateFlow<CustomerState> customerState, @NotNull StateFlow<Boolean> isGooglePayReady2, @NotNull StateFlow<Boolean> isLinkEnabled, @NotNull StateFlow<Boolean> canRemovePaymentMethods, @NotNull Function1<? super String, ? extends ResolvableString> nameProvider, boolean isNotPaymentFlow, @NotNull Function0<Boolean> isCbcEligible) {
        Intrinsics.checkNotNullParameter(customerState, (String)"customerState");
        Intrinsics.checkNotNullParameter(isGooglePayReady2, (String)"isGooglePayReady");
        Intrinsics.checkNotNullParameter(isLinkEnabled, (String)"isLinkEnabled");
        Intrinsics.checkNotNullParameter(canRemovePaymentMethods, (String)"canRemovePaymentMethods");
        Intrinsics.checkNotNullParameter(nameProvider, (String)"nameProvider");
        Intrinsics.checkNotNullParameter(isCbcEligible, (String)"isCbcEligible");
        this.customerState = customerState;
        this.isGooglePayReady = isGooglePayReady2;
        this.isLinkEnabled = isLinkEnabled;
        this.canRemovePaymentMethods = canRemovePaymentMethods;
        this.nameProvider = nameProvider;
        this.isNotPaymentFlow = isNotPaymentFlow;
        this.isCbcEligible = isCbcEligible;
    }

    @NotNull
    public final StateFlow<List<PaymentOptionsItem>> invoke() {
        return StateFlowsKt.combineAsStateFlow(this.customerState, this.isLinkEnabled, this.isGooglePayReady, this.canRemovePaymentMethods, (Function4)((Function4)new Function4<CustomerState, Boolean, Boolean, Boolean, List<? extends PaymentOptionsItem>>(this){
            final /* synthetic */ PaymentOptionsItemsMapper this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final List<PaymentOptionsItem> invoke(@Nullable CustomerState customerState, @Nullable Boolean isLinkEnabled, boolean isGooglePayReady2, boolean canRemove2) {
                List list;
                Object object = customerState;
                if (object == null || (object = ((CustomerState)object).getPaymentMethods()) == null) {
                    object = CollectionsKt.emptyList();
                }
                if ((list = PaymentOptionsItemsMapper.access$createPaymentOptionsItems(this.this$0, (List)object, isLinkEnabled, isGooglePayReady2, canRemove2)) == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }));
    }

    private final List<PaymentOptionsItem> createPaymentOptionsItems(List<PaymentMethod> paymentMethods2, Boolean isLinkEnabled, boolean isGooglePayReady2, boolean canRemovePaymentMethods) {
        if (isLinkEnabled == null) {
            return null;
        }
        PaymentOptionsStateFactory paymentOptionsStateFactory = PaymentOptionsStateFactory.INSTANCE;
        boolean bl = isGooglePayReady2 && this.isNotPaymentFlow;
        boolean bl2 = isLinkEnabled != false && this.isNotPaymentFlow;
        Function1<String, ResolvableString> function1 = this.nameProvider;
        boolean bl3 = (Boolean)this.isCbcEligible.invoke();
        return paymentOptionsStateFactory.createPaymentOptionsList(paymentMethods2, bl, bl2, function1, canRemovePaymentMethods, bl3);
    }

    public static final /* synthetic */ List access$createPaymentOptionsItems(PaymentOptionsItemsMapper $this, List paymentMethods2, Boolean isLinkEnabled, boolean isGooglePayReady2, boolean canRemovePaymentMethods) {
        return $this.createPaymentOptionsItems(paymentMethods2, isLinkEnabled, isGooglePayReady2, canRemovePaymentMethods);
    }
}

