/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.paymentdatacollection.ach;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.core.strings.transformations.Replace;
import com.stripe.android.paymentsheet.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountTextBuilder;", "", "()V", "buildMandateAndMicrodepositsText", "Lcom/stripe/android/core/strings/ResolvableString;", "merchantName", "", "isVerifyingMicrodeposits", "", "isSaveForFutureUseSelected", "isInstantDebits", "isSetupFlow", "buildMandateText", "getTermsLink", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class USBankAccountTextBuilder {
    @NotNull
    public static final USBankAccountTextBuilder INSTANCE = new USBankAccountTextBuilder();
    public static final int $stable;

    private USBankAccountTextBuilder() {
    }

    @NotNull
    public final ResolvableString buildMandateAndMicrodepositsText(@NotNull String merchantName, boolean isVerifyingMicrodeposits, boolean isSaveForFutureUseSelected, boolean isInstantDebits, boolean isSetupFlow) {
        ResolvableString resolvableString;
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        ResolvableString mandateText = this.buildMandateText(merchantName, isSaveForFutureUseSelected, isInstantDebits, isSetupFlow);
        if (isVerifyingMicrodeposits) {
            Object[] objectArray = new Object[]{merchantName};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_microdeposit, (Object[])objectArray, null, (int)4, null);
        } else {
            resolvableString = null;
        }
        ResolvableString microdepositsText = resolvableString;
        return microdepositsText != null ? ResolvableStringUtilsKt.plus((ResolvableString)ResolvableStringUtilsKt.plus(microdepositsText, (ResolvableString)ResolvableStringUtilsKt.getResolvableString((String)" ")), (ResolvableString)mandateText) : mandateText;
    }

    @VisibleForTesting
    @NotNull
    public final ResolvableString buildMandateText(@NotNull String merchantName, boolean isSaveForFutureUseSelected, boolean isInstantDebits, boolean isSetupFlow) {
        ResolvableString resolvableString;
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Object[] objectArray = new Replace[]{new Replace("<terms>", "<a href=\"" + this.getTermsLink(isInstantDebits) + "\">"), new Replace("</terms>", "</a>")};
        List transforms = CollectionsKt.listOf((Object[])objectArray);
        if (isSaveForFutureUseSelected || isSetupFlow) {
            Object[] objectArray2 = new Object[]{merchantName};
            resolvableString = ResolvableStringUtilsKt.resolvableString((int)R.string.stripe_paymentsheet_ach_save_mandate, (Object[])objectArray2, (List)transforms);
        } else {
            resolvableString = ResolvableStringUtilsKt.resolvableString((int)R.string.stripe_paymentsheet_ach_continue_mandate, (Object[])new Object[0], (List)transforms);
        }
        ResolvableString text = resolvableString;
        return text;
    }

    private final String getTermsLink(boolean isInstantDebits) {
        String string2;
        boolean bl = isInstantDebits;
        if (bl) {
            string2 = "https://link.com/terms/ach-authorization";
        } else if (!bl) {
            string2 = "https://stripe.com/ach-payments/authorization";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }
}

