/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.IntentConfigurationKtxKt;
import com.stripe.android.paymentsheet.PaymentSheet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/DeferredIntentValidator;", "", "()V", "validate", "Lcom/stripe/android/model/StripeIntent;", "stripeIntent", "intentConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$IntentConfiguration;", "isFlowController", "", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class DeferredIntentValidator {
    @NotNull
    public static final DeferredIntentValidator INSTANCE = new DeferredIntentValidator();
    public static final int $stable;

    private DeferredIntentValidator() {
    }

    @NotNull
    public final StripeIntent validate(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.IntentConfiguration intentConfiguration, boolean isFlowController) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)intentConfiguration, (String)"intentConfiguration");
        DeferredIntentParams params = IntentConfigurationKtxKt.toDeferredIntentParams(intentConfiguration);
        StripeIntent stripeIntent2 = stripeIntent;
        if (stripeIntent2 instanceof PaymentIntent) {
            String string2;
            DeferredIntentParams.Mode mode = params.getMode();
            DeferredIntentParams.Mode.Payment payment = mode instanceof DeferredIntentParams.Mode.Payment ? (DeferredIntentParams.Mode.Payment)mode : null;
            if (payment == null) {
                boolean $i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22 = false;
                String $i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22 = "You returned a PaymentIntent client secret but used a PaymentSheet.IntentConfiguration in setup mode.";
                throw new IllegalArgumentException($i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22.toString());
            }
            DeferredIntentParams.Mode.Payment paymentMode = payment;
            String string3 = paymentMode.getCurrency().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = ((PaymentIntent)stripeIntent).getCurrency();
            if (string4 != null) {
                String string5 = string4.toLowerCase(Locale.ROOT);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            } else {
                string2 = null;
            }
            if (!Intrinsics.areEqual((Object)string3, (Object)string2)) {
                String string6;
                boolean $i$a$-require-DeferredIntentValidator$validate$62 = false;
                String string7 = ((PaymentIntent)stripeIntent).getCurrency();
                if (string7 != null) {
                    String string8 = string7.toLowerCase(Locale.ROOT);
                    string6 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                } else {
                    string6 = null;
                }
                String string9 = paymentMode.getCurrency().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                String $i$a$-require-DeferredIntentValidator$validate$62 = "Your PaymentIntent currency (" + string6 + ") does not match the PaymentSheet.IntentConfiguration currency (" + string9 + ").";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$62.toString());
            }
            if (!(paymentMode.getSetupFutureUsage() == ((PaymentIntent)stripeIntent).getSetupFutureUsage())) {
                boolean $i$a$-require-DeferredIntentValidator$validate$72 = false;
                String $i$a$-require-DeferredIntentValidator$validate$72 = "Your PaymentIntent setupFutureUsage (" + ((PaymentIntent)stripeIntent).getSetupFutureUsage() + ") does not match the PaymentSheet.IntentConfiguration setupFutureUsage (" + paymentMode.getSetupFutureUsage() + ").";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$72.toString());
            }
            if (!(paymentMode.getCaptureMethod() == ((PaymentIntent)stripeIntent).getCaptureMethod())) {
                boolean $i$a$-require-DeferredIntentValidator$validate$82 = false;
                String $i$a$-require-DeferredIntentValidator$validate$82 = "Your PaymentIntent captureMethod (" + ((PaymentIntent)stripeIntent).getCaptureMethod() + ") does not match the PaymentSheet.IntentConfiguration captureMethod (" + paymentMode.getCaptureMethod() + ").";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$82.toString());
            }
            if (!(((PaymentIntent)stripeIntent).getConfirmationMethod() != PaymentIntent.ConfirmationMethod.Manual || isFlowController)) {
                boolean $i$a$-require-DeferredIntentValidator$validate$92 = false;
                String $i$a$-require-DeferredIntentValidator$validate$92 = "Your PaymentIntent confirmationMethod (" + ((PaymentIntent)stripeIntent).getConfirmationMethod() + ") can only be used with PaymentSheet.FlowController.";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$92.toString());
            }
        } else if (stripeIntent2 instanceof SetupIntent) {
            DeferredIntentParams.Mode mode = params.getMode();
            DeferredIntentParams.Mode.Setup setup = mode instanceof DeferredIntentParams.Mode.Setup ? (DeferredIntentParams.Mode.Setup)mode : null;
            if (setup == null) {
                boolean $i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22 = false;
                String $i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22 = "You returned a SetupIntent client secret but used a PaymentSheet.IntentConfiguration in payment mode.";
                throw new IllegalArgumentException($i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22.toString());
            }
            DeferredIntentParams.Mode.Setup setupMode = setup;
            if (!(setupMode.getSetupFutureUsage() == ((SetupIntent)stripeIntent).getUsage())) {
                boolean bl = false;
                String string10 = "Your SetupIntent usage (" + ((SetupIntent)stripeIntent).getUsage() + ") does not match the PaymentSheet.IntentConfiguration usage (" + ((SetupIntent)stripeIntent).getUsage() + ").";
                throw new IllegalArgumentException(string10.toString());
            }
        }
        return stripeIntent;
    }
}

