/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.data;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c2\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/customersheet/data/CachedCustomerEphemeralKey;", "", "customerId", "", "customerSessionClientSecret", "ephemeralKey", "expiresAt", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getCustomerId", "()Ljava/lang/String;", "getCustomerSessionClientSecret", "getEphemeralKey", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "shouldRefresh", "currentTimeInMillis", "", "toString", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CachedCustomerEphemeralKey {
    @NotNull
    private final String customerId;
    @NotNull
    private final String customerSessionClientSecret;
    @NotNull
    private final String ephemeralKey;
    private final int expiresAt;
    public static final int $stable;

    public CachedCustomerEphemeralKey(@NotNull String customerId, @NotNull String customerSessionClientSecret, @NotNull String ephemeralKey, int expiresAt) {
        Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
        Intrinsics.checkNotNullParameter((Object)customerSessionClientSecret, (String)"customerSessionClientSecret");
        Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
        this.customerId = customerId;
        this.customerSessionClientSecret = customerSessionClientSecret;
        this.ephemeralKey = ephemeralKey;
        this.expiresAt = expiresAt;
    }

    @NotNull
    public final String getCustomerId() {
        return this.customerId;
    }

    @NotNull
    public final String getCustomerSessionClientSecret() {
        return this.customerSessionClientSecret;
    }

    @NotNull
    public final String getEphemeralKey() {
        return this.ephemeralKey;
    }

    public final boolean shouldRefresh(long currentTimeInMillis) {
        long remainingTime = (long)this.expiresAt - Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((long)currentTimeInMillis, (DurationUnit)DurationUnit.MILLISECONDS));
        return remainingTime <= Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
    }

    @NotNull
    public final String component1() {
        return this.customerId;
    }

    @NotNull
    public final String component2() {
        return this.customerSessionClientSecret;
    }

    @NotNull
    public final String component3() {
        return this.ephemeralKey;
    }

    private final int component4() {
        return this.expiresAt;
    }

    @NotNull
    public final CachedCustomerEphemeralKey copy(@NotNull String customerId, @NotNull String customerSessionClientSecret, @NotNull String ephemeralKey, int expiresAt) {
        Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
        Intrinsics.checkNotNullParameter((Object)customerSessionClientSecret, (String)"customerSessionClientSecret");
        Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
        return new CachedCustomerEphemeralKey(customerId, customerSessionClientSecret, ephemeralKey, expiresAt);
    }

    public static /* synthetic */ CachedCustomerEphemeralKey copy$default(CachedCustomerEphemeralKey cachedCustomerEphemeralKey, String string2, String string3, String string4, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = cachedCustomerEphemeralKey.customerId;
        }
        if ((n2 & 2) != 0) {
            string3 = cachedCustomerEphemeralKey.customerSessionClientSecret;
        }
        if ((n2 & 4) != 0) {
            string4 = cachedCustomerEphemeralKey.ephemeralKey;
        }
        if ((n2 & 8) != 0) {
            n = cachedCustomerEphemeralKey.expiresAt;
        }
        return cachedCustomerEphemeralKey.copy(string2, string3, string4, n);
    }

    @NotNull
    public String toString() {
        return "CachedCustomerEphemeralKey(customerId=" + this.customerId + ", customerSessionClientSecret=" + this.customerSessionClientSecret + ", ephemeralKey=" + this.ephemeralKey + ", expiresAt=" + this.expiresAt + ")";
    }

    public int hashCode() {
        int result2 = this.customerId.hashCode();
        result2 = result2 * 31 + this.customerSessionClientSecret.hashCode();
        result2 = result2 * 31 + this.ephemeralKey.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.expiresAt);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CachedCustomerEphemeralKey)) {
            return false;
        }
        CachedCustomerEphemeralKey cachedCustomerEphemeralKey = (CachedCustomerEphemeralKey)other;
        if (!Intrinsics.areEqual((Object)this.customerId, (Object)cachedCustomerEphemeralKey.customerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customerSessionClientSecret, (Object)cachedCustomerEphemeralKey.customerSessionClientSecret)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ephemeralKey, (Object)cachedCustomerEphemeralKey.ephemeralKey)) {
            return false;
        }
        return this.expiresAt == cachedCustomerEphemeralKey.expiresAt;
    }
}

