/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/PaymentUtils;", "", "()V", "formatPriceString", "", "amount", "", "currency", "Ljava/util/Currency;", "formatPriceString$payments_core_release", "formatPriceStringUsingFree", "", "free", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class PaymentUtils {
    @NotNull
    public static final PaymentUtils INSTANCE = new PaymentUtils();
    public static final int $stable;

    private PaymentUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String formatPriceStringUsingFree(long amount, @NotNull Currency currency, @NotNull String free) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)free, (String)"free");
        if (amount == 0L) {
            return free;
        }
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
        decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
        ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        return INSTANCE.formatPriceString$payments_core_release(amount, currency);
    }

    public final /* synthetic */ String formatPriceString$payments_core_release(double amount, Currency currency) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double majorUnitAmount = amount / Math.pow(10.0, currency.getDefaultFractionDigits());
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        try {
            Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            string2 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (ClassCastException e) {
            String string3 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }
}

