/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.databinding.StripeAddPaymentMethodRowBinding;
import com.stripe.android.databinding.StripeGooglePayRowBinding;
import com.stripe.android.databinding.StripeMaskedCardRowBinding;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.ThemeConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0019\b\u0000\u0018\u0000 Q2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004QRSTBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-H\u0002J\u0015\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020\u0016H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020\u0016H\u0016J\u0010\u0010=\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016H\u0016J\u0015\u0010>\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016H\u0002J\u0019\u0010A\u001a\u0004\u0018\u00010\u00162\u0006\u00106\u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\bB\u0010CJ\u0010\u0010D\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0016H\u0002J\u0010\u0010E\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0016H\u0002J\u0018\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0016H\u0016J\u0018\u0010H\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010I\u001a\u00020\u0016H\u0016J\u0015\u0010J\u001a\u0002052\u0006\u00109\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u0002052\u0006\u00106\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bMJ\u001b\u0010N\u001a\u0002052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0006H\u0000\u00a2\u0006\u0002\bOJ\u0010\u0010P\u001a\u0002052\u0006\u00109\u001a\u00020\u0016H\u0002R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "intentArgs", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "addableTypes", "", "Lcom/stripe/android/model/PaymentMethod$Type;", "initiallySelectedPaymentMethodId", "", "shouldShowGooglePay", "", "useGooglePay", "canDeletePaymentMethods", "(Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;Ljava/util/List;Ljava/lang/String;ZZZ)V", "addCardArgs", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "getAddCardArgs$payments_core_release", "()Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "addFpxArgs", "getAddFpxArgs$payments_core_release", "googlePayCount", "", "listener", "Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "getListener$payments_core_release", "()Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "setListener$payments_core_release", "(Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;)V", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethods$payments_core_release", "()Ljava/util/List;", "selectedPaymentMethod", "getSelectedPaymentMethod$payments_core_release", "()Lcom/stripe/android/model/PaymentMethod;", "selectedPaymentMethodId", "getSelectedPaymentMethodId$payments_core_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$payments_core_release", "(Ljava/lang/String;)V", "createAddCardPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddCardPaymentMethodViewHolder;", "parent", "Landroid/view/ViewGroup;", "createAddFpxPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddFpxPaymentMethodViewHolder;", "createGooglePayViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$GooglePayViewHolder;", "createPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "deletePaymentMethod", "", "paymentMethod", "deletePaymentMethod$payments_core_release", "getAddableTypesPosition", "position", "getItemCount", "getItemId", "", "getItemViewType", "getPaymentMethodAtPosition", "getPaymentMethodAtPosition$payments_core_release", "getPaymentMethodIndex", "getPosition", "getPosition$payments_core_release", "(Lcom/stripe/android/model/PaymentMethod;)Ljava/lang/Integer;", "isGooglePayPosition", "isPaymentMethodsPosition", "onBindViewHolder", "holder", "onCreateViewHolder", "viewType", "onPositionClicked", "onPositionClicked$payments_core_release", "resetPaymentMethod", "resetPaymentMethod$payments_core_release", "setPaymentMethods", "setPaymentMethods$payments_core_release", "updateSelectedPaymentMethod", "Companion", "Listener", "ViewHolder", "ViewType", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentMethodsAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodsAdapter.kt\ncom/stripe/android/view/PaymentMethodsAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1#2:384\n288#3,2:385\n350#3,7:387\n*S KotlinDebug\n*F\n+ 1 PaymentMethodsAdapter.kt\ncom/stripe/android/view/PaymentMethodsAdapter\n*L\n35#1:385,2\n160#1:387,7\n*E\n"})
public final class PaymentMethodsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PaymentMethod.Type> addableTypes;
    private final boolean shouldShowGooglePay;
    private final boolean useGooglePay;
    private final boolean canDeletePaymentMethods;
    @NotNull
    private final List<PaymentMethod> paymentMethods;
    @Nullable
    private String selectedPaymentMethodId;
    @Nullable
    private Listener listener;
    private final int googlePayCount;
    @NotNull
    private final AddPaymentMethodActivityStarter.Args addCardArgs;
    @NotNull
    private final AddPaymentMethodActivityStarter.Args addFpxArgs;
    public static final int $stable = 8;
    private static final long GOOGLE_PAY_ITEM_ID = "pm_google_pay".hashCode();

    public PaymentMethodsAdapter(@NotNull PaymentMethodsActivityStarter.Args intentArgs, @NotNull List<? extends PaymentMethod.Type> addableTypes, @Nullable String initiallySelectedPaymentMethodId, boolean shouldShowGooglePay, boolean useGooglePay, boolean canDeletePaymentMethods) {
        Intrinsics.checkNotNullParameter((Object)intentArgs, (String)"intentArgs");
        Intrinsics.checkNotNullParameter(addableTypes, (String)"addableTypes");
        this.addableTypes = addableTypes;
        this.shouldShowGooglePay = shouldShowGooglePay;
        this.useGooglePay = useGooglePay;
        this.canDeletePaymentMethods = canDeletePaymentMethods;
        this.paymentMethods = new ArrayList();
        this.selectedPaymentMethodId = initiallySelectedPaymentMethodId;
        Integer n = 1;
        int n2 = ((Number)n).intValue();
        PaymentMethodsAdapter paymentMethodsAdapter = this;
        boolean bl = false;
        boolean bl2 = this.shouldShowGooglePay;
        Integer n3 = bl2 ? n : null;
        paymentMethodsAdapter.googlePayCount = n3 != null ? n3 : 0;
        this.addCardArgs = new AddPaymentMethodActivityStarter.Args.Builder().setBillingAddressFields(intentArgs.getBillingAddressFields$payments_core_release()).setShouldAttachToCustomer(true).setIsPaymentSessionActive$payments_core_release(intentArgs.isPaymentSessionActive$payments_core_release()).setPaymentMethodType(PaymentMethod.Type.Card).setAddPaymentMethodFooter(intentArgs.getAddPaymentMethodFooterLayoutId()).setPaymentConfiguration(intentArgs.getPaymentConfiguration$payments_core_release()).setWindowFlags(intentArgs.getWindowFlags$payments_core_release()).build();
        this.addFpxArgs = new AddPaymentMethodActivityStarter.Args.Builder().setIsPaymentSessionActive$payments_core_release(intentArgs.isPaymentSessionActive$payments_core_release()).setPaymentMethodType(PaymentMethod.Type.Fpx).setPaymentConfiguration(intentArgs.getPaymentConfiguration$payments_core_release()).build();
        this.setHasStableIds(true);
    }

    public /* synthetic */ PaymentMethodsAdapter(PaymentMethodsActivityStarter.Args args2, List list, String string2, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf((Object)((Object)PaymentMethod.Type.Card));
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        this(args2, list, string2, bl, bl2, bl3);
    }

    @NotNull
    public final List<PaymentMethod> getPaymentMethods$payments_core_release() {
        return this.paymentMethods;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$payments_core_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$payments_core_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    @Nullable
    public final PaymentMethod getSelectedPaymentMethod$payments_core_release() {
        PaymentMethod paymentMethod;
        String string2 = this.selectedPaymentMethodId;
        if (string2 != null) {
            Object v1;
            block3: {
                String selectedPaymentMethodId = string2;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.paymentMethods;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethod it = (PaymentMethod)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.id, (Object)selectedPaymentMethodId)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            paymentMethod = v1;
        } else {
            paymentMethod = null;
        }
        return paymentMethod;
    }

    @Nullable
    public final Listener getListener$payments_core_release() {
        return this.listener;
    }

    public final void setListener$payments_core_release(@Nullable Listener listener) {
        this.listener = listener;
    }

    @NotNull
    public final AddPaymentMethodActivityStarter.Args getAddCardArgs$payments_core_release() {
        return this.addCardArgs;
    }

    @NotNull
    public final AddPaymentMethodActivityStarter.Args getAddFpxArgs$payments_core_release() {
        return this.addFpxArgs;
    }

    public final /* synthetic */ void setPaymentMethods$payments_core_release(List paymentMethods) {
        Intrinsics.checkNotNullParameter((Object)paymentMethods, (String)"paymentMethods");
        this.paymentMethods.clear();
        this.paymentMethods.addAll(paymentMethods);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.paymentMethods.size() + this.addableTypes.size() + this.googlePayCount;
    }

    public int getItemViewType(int position) {
        int n;
        if (this.isGooglePayPosition(position)) {
            n = ViewType.GooglePay.ordinal();
        } else if (this.isPaymentMethodsPosition(position)) {
            PaymentMethod.Type type = this.getPaymentMethodAtPosition$payments_core_release((int)position).type;
            n = PaymentMethod.Type.Card == type ? ViewType.Card.ordinal() : super.getItemViewType(position);
        } else {
            int n2;
            PaymentMethod.Type paymentMethodType2 = this.addableTypes.get(this.getAddableTypesPosition(position));
            switch (WhenMappings.$EnumSwitchMapping$0[paymentMethodType2.ordinal()]) {
                case 1: {
                    n2 = ViewType.AddCard.ordinal();
                    break;
                }
                case 2: {
                    n2 = ViewType.AddFpx.ordinal();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported PaymentMethod type: " + paymentMethodType2.code);
                }
            }
            return n2;
        }
        return n;
    }

    private final boolean isGooglePayPosition(int position) {
        return this.shouldShowGooglePay && position == 0;
    }

    private final boolean isPaymentMethodsPosition(int position) {
        IntRange range = this.shouldShowGooglePay ? new IntRange(1, this.paymentMethods.size()) : RangesKt.until((int)0, (int)this.paymentMethods.size());
        int n = range.getFirst();
        return position <= range.getLast() ? n <= position : false;
    }

    public long getItemId(int position) {
        return this.isGooglePayPosition(position) ? GOOGLE_PAY_ITEM_ID : (this.isPaymentMethodsPosition(position) ? (long)this.getPaymentMethodAtPosition$payments_core_release(position).hashCode() : (long)this.addableTypes.get((int)this.getAddableTypesPosition((int)position)).code.hashCode());
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RecyclerView.ViewHolder viewHolder = holder;
        if (viewHolder instanceof ViewHolder.PaymentMethodViewHolder) {
            PaymentMethod paymentMethod = this.getPaymentMethodAtPosition$payments_core_release(position);
            ((ViewHolder.PaymentMethodViewHolder)holder).setPaymentMethod(paymentMethod);
            ((ViewHolder.PaymentMethodViewHolder)holder).setSelected(Intrinsics.areEqual((Object)paymentMethod.id, (Object)this.selectedPaymentMethodId));
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda$3(this, holder, arg_0));
        } else if (viewHolder instanceof ViewHolder.GooglePayViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda$4(this, arg_0));
            ((ViewHolder.GooglePayViewHolder)holder).bind(this.useGooglePay);
        } else if (viewHolder instanceof ViewHolder.AddCardPaymentMethodViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda$5(this, arg_0));
        } else if (viewHolder instanceof ViewHolder.AddFpxPaymentMethodViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda$6(this, arg_0));
        }
    }

    public final /* synthetic */ void onPositionClicked$payments_core_release(int position) {
        block0: {
            this.updateSelectedPaymentMethod(position);
            Listener listener = this.listener;
            if (listener == null) break block0;
            listener.onPaymentMethodClick(this.getPaymentMethodAtPosition$payments_core_release(position));
        }
    }

    private final void updateSelectedPaymentMethod(int position) {
        int currentlySelectedPosition;
        block3: {
            int n;
            List<PaymentMethod> $this$indexOfFirst$iv = this.paymentMethods;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaymentMethod> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod item$iv;
                PaymentMethod it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.id, (Object)this.selectedPaymentMethodId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = currentlySelectedPosition = -1;
        }
        if (currentlySelectedPosition != position) {
            this.notifyItemChanged(currentlySelectedPosition);
            PaymentMethod paymentMethod = (PaymentMethod)CollectionsKt.getOrNull(this.paymentMethods, (int)position);
            this.selectedPaymentMethodId = paymentMethod != null ? paymentMethod.id : null;
        }
        this.notifyItemChanged(position);
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        switch (WhenMappings.$EnumSwitchMapping$1[((ViewType)((Object)ViewType.getEntries().get(viewType))).ordinal()]) {
            case 1: {
                viewHolder = this.createPaymentMethodViewHolder(parent);
                break;
            }
            case 2: {
                viewHolder = this.createAddCardPaymentMethodViewHolder(parent);
                break;
            }
            case 3: {
                viewHolder = this.createAddFpxPaymentMethodViewHolder(parent);
                break;
            }
            case 4: {
                viewHolder = this.createGooglePayViewHolder(parent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return viewHolder;
    }

    private final ViewHolder.AddCardPaymentMethodViewHolder createAddCardPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return new ViewHolder.AddCardPaymentMethodViewHolder(context, parent);
    }

    private final ViewHolder.AddFpxPaymentMethodViewHolder createAddFpxPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return new ViewHolder.AddFpxPaymentMethodViewHolder(context, parent);
    }

    private final ViewHolder.PaymentMethodViewHolder createPaymentMethodViewHolder(ViewGroup parent) {
        ViewHolder.PaymentMethodViewHolder viewHolder = new ViewHolder.PaymentMethodViewHolder(parent);
        if (this.canDeletePaymentMethods) {
            ViewCompat.addAccessibilityAction((View)viewHolder.itemView, (CharSequence)parent.getContext().getString(R.string.stripe_delete_payment_method), (arg_0, arg_1) -> PaymentMethodsAdapter.createPaymentMethodViewHolder$lambda$8(this, viewHolder, arg_0, arg_1));
        }
        return viewHolder;
    }

    private final ViewHolder.GooglePayViewHolder createGooglePayViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return new ViewHolder.GooglePayViewHolder(context, parent);
    }

    public final /* synthetic */ void deletePaymentMethod$payments_core_release(PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            Integer n = this.getPosition$payments_core_release(paymentMethod);
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.paymentMethods.remove(paymentMethod);
            this.notifyItemRemoved(it);
        }
    }

    public final /* synthetic */ void resetPaymentMethod$payments_core_release(PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            Integer n = this.getPosition$payments_core_release(paymentMethod);
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.notifyItemChanged(it);
        }
    }

    public final /* synthetic */ PaymentMethod getPaymentMethodAtPosition$payments_core_release(int position) {
        return this.paymentMethods.get(this.getPaymentMethodIndex(position));
    }

    private final int getPaymentMethodIndex(int position) {
        return position - this.googlePayCount;
    }

    @Nullable
    public final Integer getPosition$payments_core_release(@NotNull PaymentMethod paymentMethod) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Integer n2 = this.paymentMethods.indexOf(paymentMethod);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl2 = false;
            n = it + this.googlePayCount;
        } else {
            n = null;
        }
        return n;
    }

    private final int getAddableTypesPosition(int position) {
        return position - this.paymentMethods.size() - this.googlePayCount;
    }

    private static final void onBindViewHolder$lambda$3(PaymentMethodsAdapter this$0, RecyclerView.ViewHolder $holder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$holder, (String)"$holder");
        this$0.onPositionClicked$payments_core_release(((ViewHolder.PaymentMethodViewHolder)$holder).getBindingAdapterPosition());
    }

    private static final void onBindViewHolder$lambda$4(PaymentMethodsAdapter this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.selectedPaymentMethodId = null;
            Listener listener = this$0.listener;
            if (listener == null) break block0;
            listener.onGooglePayClick();
        }
    }

    private static final void onBindViewHolder$lambda$5(PaymentMethodsAdapter this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Listener listener = this$0.listener;
            if (listener == null) break block0;
            listener.onAddPaymentMethodClick(this$0.addCardArgs);
        }
    }

    private static final void onBindViewHolder$lambda$6(PaymentMethodsAdapter this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Listener listener = this$0.listener;
            if (listener == null) break block0;
            listener.onAddPaymentMethodClick(this$0.addFpxArgs);
        }
    }

    private static final boolean createPaymentMethodViewHolder$lambda$8(PaymentMethodsAdapter this$0, ViewHolder.PaymentMethodViewHolder $viewHolder, View view, AccessibilityViewCommand.CommandArguments commandArguments) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
            Intrinsics.checkNotNullParameter((Object)view, (String)"<anonymous parameter 0>");
            Listener listener = this$0.listener;
            if (listener == null) break block0;
            listener.onDeletePaymentMethodAction(this$0.getPaymentMethodAtPosition$payments_core_release($viewHolder.getBindingAdapterPosition()));
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Companion;", "", "()V", "GOOGLE_PAY_ITEM_ID", "", "getGOOGLE_PAY_ITEM_ID$payments_core_release", "()J", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getGOOGLE_PAY_ITEM_ID$payments_core_release() {
            return GOOGLE_PAY_ITEM_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0003H&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "", "onAddPaymentMethodClick", "", "args", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "onDeletePaymentMethodAction", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "onGooglePayClick", "onPaymentMethodClick", "payments-core_release"})
    public static interface Listener {
        public void onPaymentMethodClick(@NotNull PaymentMethod var1);

        public void onGooglePayClick();

        public void onAddPaymentMethodClick(@NotNull AddPaymentMethodActivityStarter.Args var1);

        public void onDeletePaymentMethodAction(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0001\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "AddCardPaymentMethodViewHolder", "AddFpxPaymentMethodViewHolder", "GooglePayViewHolder", "PaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        public static final int $stable;

        private ViewHolder(View itemView) {
            super(itemView);
        }

        public /* synthetic */ ViewHolder(View itemView, DefaultConstructorMarker $constructor_marker) {
            this(itemView);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddCardPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/StripeAddPaymentMethodRowBinding;", "(Lcom/stripe/android/databinding/StripeAddPaymentMethodRowBinding;)V", "payments-core_release"})
        @StabilityInferred(parameters=1)
        public static final class AddCardPaymentMethodViewHolder
        extends RecyclerView.ViewHolder {
            public static final int $stable;

            public AddCardPaymentMethodViewHolder(@NotNull StripeAddPaymentMethodRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.itemView.setId(R.id.stripe_payment_methods_add_card);
                this.itemView.setContentDescription((CharSequence)this.itemView.getResources().getString(R.string.stripe_payment_method_add_new_card));
                viewBinding2.label.setText((CharSequence)this.itemView.getResources().getString(R.string.stripe_payment_method_add_new_card));
            }

            public AddCardPaymentMethodViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                StripeAddPaymentMethodRowBinding stripeAddPaymentMethodRowBinding = StripeAddPaymentMethodRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)stripeAddPaymentMethodRowBinding, (String)"inflate(...)");
                this(stripeAddPaymentMethodRowBinding);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddFpxPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/StripeAddPaymentMethodRowBinding;", "(Lcom/stripe/android/databinding/StripeAddPaymentMethodRowBinding;)V", "payments-core_release"})
        @StabilityInferred(parameters=1)
        public static final class AddFpxPaymentMethodViewHolder
        extends RecyclerView.ViewHolder {
            public static final int $stable;

            public AddFpxPaymentMethodViewHolder(@NotNull StripeAddPaymentMethodRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.itemView.setId(R.id.stripe_payment_methods_add_fpx);
                this.itemView.setContentDescription((CharSequence)this.itemView.getResources().getString(R.string.stripe_payment_method_add_new_fpx));
                viewBinding2.label.setText((CharSequence)this.itemView.getResources().getString(R.string.stripe_payment_method_add_new_fpx));
            }

            public AddFpxPaymentMethodViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                StripeAddPaymentMethodRowBinding stripeAddPaymentMethodRowBinding = StripeAddPaymentMethodRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)stripeAddPaymentMethodRowBinding, (String)"inflate(...)");
                this(stripeAddPaymentMethodRowBinding);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$GooglePayViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/StripeGooglePayRowBinding;", "(Lcom/stripe/android/databinding/StripeGooglePayRowBinding;)V", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "bind", "", "isSelected", "", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class GooglePayViewHolder
        extends RecyclerView.ViewHolder {
            @NotNull
            private final StripeGooglePayRowBinding viewBinding;
            @NotNull
            private final ThemeConfig themeConfig;
            public static final int $stable = 8;

            public GooglePayViewHolder(@NotNull StripeGooglePayRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.viewBinding = viewBinding2;
                Context context = this.itemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                this.themeConfig = new ThemeConfig(context);
                ImageViewCompat.setImageTintList((ImageView)((ImageView)this.viewBinding.checkIcon), (ColorStateList)ColorStateList.valueOf((int)this.themeConfig.getTintColor$payments_core_release(true)));
            }

            public GooglePayViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                StripeGooglePayRowBinding stripeGooglePayRowBinding = StripeGooglePayRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)stripeGooglePayRowBinding, (String)"inflate(...)");
                this(stripeGooglePayRowBinding);
            }

            public final void bind(boolean isSelected) {
                this.viewBinding.label.setTextColor(ColorStateList.valueOf((int)this.themeConfig.getTextColor$payments_core_release(isSelected)));
                this.viewBinding.checkIcon.setVisibility(isSelected ? 0 : 4);
                this.itemView.setSelected(isSelected);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/StripeMaskedCardRowBinding;", "(Lcom/stripe/android/databinding/StripeMaskedCardRowBinding;)V", "setPaymentMethod", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class PaymentMethodViewHolder
        extends ViewHolder {
            @NotNull
            private final StripeMaskedCardRowBinding viewBinding;
            public static final int $stable = 8;

            public PaymentMethodViewHolder(@NotNull StripeMaskedCardRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                FrameLayout frameLayout = viewBinding2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"getRoot(...)");
                super((View)frameLayout, null);
                this.viewBinding = viewBinding2;
            }

            public PaymentMethodViewHolder(@NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                StripeMaskedCardRowBinding stripeMaskedCardRowBinding = StripeMaskedCardRowBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)stripeMaskedCardRowBinding, (String)"inflate(...)");
                this(stripeMaskedCardRowBinding);
            }

            public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                this.viewBinding.maskedCardItem.setPaymentMethod(paymentMethod);
            }

            public final void setSelected(boolean selected) {
                this.viewBinding.maskedCardItem.setSelected(selected);
                this.itemView.setSelected(selected);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewType;", "", "(Ljava/lang/String;I)V", "Card", "AddCard", "AddFpx", "GooglePay", "payments-core_release"})
    public static final class ViewType
    extends Enum<ViewType> {
        public static final /* enum */ ViewType Card = new ViewType();
        public static final /* enum */ ViewType AddCard = new ViewType();
        public static final /* enum */ ViewType AddFpx = new ViewType();
        public static final /* enum */ ViewType GooglePay = new ViewType();
        private static final /* synthetic */ ViewType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ViewType[] values() {
            return (ViewType[])$VALUES.clone();
        }

        public static ViewType valueOf(String value) {
            return Enum.valueOf(ViewType.class, value);
        }

        @NotNull
        public static EnumEntries<ViewType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = viewTypeArray = new ViewType[]{ViewType.Card, ViewType.AddCard, ViewType.AddFpx, ViewType.GooglePay};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.Fpx.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ViewType.values().length];
            try {
                nArray[ViewType.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewType.AddCard.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewType.AddFpx.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewType.GooglePay.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

