/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.model.ExpirationDate;
import com.stripe.android.uicore.R;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0016H\u0007J#\u0010)\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0004\b,\u0010-J-\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b3J\u0012\u00104\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00066"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accessibilityText", "", "getAccessibilityText", "()Ljava/lang/String;", "completionCallback", "Lkotlin/Function0;", "", "getCompletionCallback$payments_core_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$payments_core_release", "(Lkotlin/jvm/functions/Function0;)V", "dateDigitsLength", "<set-?>", "", "includeSeparatorGaps", "getIncludeSeparatorGaps$payments_core_release", "()Z", "setIncludeSeparatorGaps$payments_core_release", "(Z)V", "includeSeparatorGaps$delegate", "Lkotlin/properties/ReadWriteProperty;", "isDateValid", "separator", "validatedDate", "Lcom/stripe/android/model/ExpirationDate$Validated;", "getValidatedDate", "()Lcom/stripe/android/model/ExpirationDate$Validated;", "month", "year", "listenForTextChanges", "setIncludeSeparatorGaps", "include", "setText", "expiryMonth", "expiryYear", "setText$payments_core_release", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "maxInputLength", "updateSelectionIndex$payments_core_release", "updateSeparatorUi", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nExpiryDateEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpiryDateEditText.kt\ncom/stripe/android/view/ExpiryDateEditText\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,328:1\n33#2,3:329\n37#3,2:332\n*S KotlinDebug\n*F\n+ 1 ExpiryDateEditText.kt\ncom/stripe/android/view/ExpiryDateEditText\n*L\n57#1:329,3\n98#1:332,2\n*E\n"})
public final class ExpiryDateEditText
extends StripeEditText {
    @NotNull
    private static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isDateValid;
    @NotNull
    private final ReadWriteProperty includeSeparatorGaps$delegate;
    private final int dateDigitsLength;
    @NotNull
    private String separator;
    public static final int $stable;
    private static final int INVALID_INPUT = -1;
    @NotNull
    private static final String SEPARATOR_WITHOUT_GAPS = "/";
    @NotNull
    private static final String SEPARATOR_WITH_GAPS = " / ";
    private static final boolean INCLUDE_SEPARATOR_GAPS_DEFAULT = false;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.completionCallback = completionCallback.1.INSTANCE;
        String[] stringArray = Delegates.INSTANCE;
        Boolean bl = false;
        boolean $i$f$observable = false;
        this.includeSeparatorGaps$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ ExpiryDateEditText this$0;
            {
                this.this$0 = expiryDateEditText;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                ((Boolean)oldValue).booleanValue();
                boolean bl2 = false;
                ExpiryDateEditText.access$updateSeparatorUi(this.this$0, (boolean)newValue2);
            }
        };
        this.dateDigitsLength = context.getResources().getInteger(R.integer.stripe_date_digits_length);
        this.separator = SEPARATOR_WITHOUT_GAPS;
        this.setNumberOnlyInputType();
        ExpiryDateEditText.updateSeparatorUi$default(this, false, 1, null);
        this.listenForTextChanges();
        if (Build.VERSION.SDK_INT >= 26) {
            stringArray = new String[]{"creditCardExpirationDate"};
            this.setAutofillHints(stringArray);
        }
        this.getInternalFocusChangeListeners().add((arg_0, arg_1) -> ExpiryDateEditText._init_$lambda$1(this, arg_0, arg_1));
        this.setLayoutDirection(0);
    }

    public /* synthetic */ ExpiryDateEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$payments_core_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$payments_core_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final boolean isDateValid() {
        return this.isDateValid;
    }

    @Nullable
    public final ExpirationDate.Validated getValidatedDate() {
        ExpirationDate.Validated validated;
        boolean bl = this.isDateValid;
        if (bl) {
            validated = ExpirationDate.Unvalidated.Companion.create(this.getFieldText$payments_core_release()).validate();
        } else if (!bl) {
            validated = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validated;
    }

    @Override
    @NotNull
    protected String getAccessibilityText() {
        Object[] objectArray = new Object[]{this.getText()};
        String string2 = this.getResources().getString(R.string.stripe_acc_label_expiry_date_node, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    public final boolean getIncludeSeparatorGaps$payments_core_release() {
        return (Boolean)this.includeSeparatorGaps$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setIncludeSeparatorGaps$payments_core_release(boolean bl) {
        this.includeSeparatorGaps$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void setIncludeSeparatorGaps(boolean include) {
        this.setIncludeSeparatorGaps$payments_core_release(include);
    }

    public final void setText$payments_core_release(@Nullable Integer expiryMonth, @Nullable Integer expiryYear) {
        if (expiryMonth != null && expiryYear != null) {
            Object[] objectArray = new String[]{StringsKt.padStart((String)expiryMonth.toString(), (int)2, (char)'0'), StringsKt.padStart((String)StringsKt.takeLast((String)expiryYear.toString(), (int)2), (int)2, (char)'0')};
            this.setText(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)this.separator, null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final void updateSeparatorUi(boolean includeSeparatorGaps) {
        this.separator = includeSeparatorGaps ? SEPARATOR_WITH_GAPS : SEPARATOR_WITHOUT_GAPS;
        Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object)new InputFilter.LengthFilter(this.dateDigitsLength + this.separator.length()));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.setFilters((InputFilter[])thisCollection$iv.toArray(new InputFilter.LengthFilter[0]));
    }

    static /* synthetic */ void updateSeparatorUi$default(ExpiryDateEditText expiryDateEditText, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        expiryDateEditText.updateSeparatorUi(bl);
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new StripeTextWatcher(this){
            private int latestChangeStart;
            private int latestInsertionSize;
            @NotNull
            private ExpirationDate.Unvalidated expirationDate;
            @Nullable
            private Integer newCursorPosition;
            @Nullable
            private String formattedDate;
            final /* synthetic */ ExpiryDateEditText this$0;
            {
                this.this$0 = $receiver;
                this.expirationDate = ExpirationDate.Unvalidated.Companion.getEMPTY();
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                this.latestChangeStart = start;
                this.latestInsertionSize = after;
            }

            /*
             * WARNING - void declaration
             */
            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                void $this$filterTo$iv$iv;
                String inputText;
                boolean inErrorState = false;
                CharSequence charSequence = s;
                String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
                if (string2 == null) {
                    string2 = "";
                }
                String $this$filter$iv = inputText = string2;
                int $i$f$filter = 0;
                CharSequence charSequence2 = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!Character.isDigit(it)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                String string3 = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                Object rawNumericInput = string3;
                if (((String)rawNumericInput).length() == 1 && this.latestChangeStart == 0 && this.latestInsertionSize == 1) {
                    char first = ((String)rawNumericInput).charAt(0);
                    if (first != '0' && first != '1') {
                        rawNumericInput = "0" + (String)rawNumericInput;
                        $i$f$filter = this.latestInsertionSize;
                        this.latestInsertionSize = $i$f$filter + 1;
                    }
                } else if (((String)rawNumericInput).length() == 2 && this.latestChangeStart == 2 && this.latestInsertionSize == 0) {
                    String string4 = ((String)rawNumericInput).substring(0, 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    rawNumericInput = string4;
                }
                ExpirationDate.Unvalidated it = $i$f$filter = ExpirationDate.Unvalidated.Companion.create((String)rawNumericInput);
                boolean bl = false;
                this.expirationDate = it;
                ExpirationDate.Unvalidated expirationDate = $i$f$filter;
                if (!expirationDate.isMonthValid()) {
                    inErrorState = true;
                }
                StringBuilder formattedDateBuilder = new StringBuilder().append(expirationDate.getMonth());
                if (expirationDate.getMonth().length() == 2 && this.latestInsertionSize > 0 && !inErrorState || ((String)rawNumericInput).length() > 2) {
                    formattedDateBuilder.append(ExpiryDateEditText.access$getSeparator$p(this.this$0));
                }
                formattedDateBuilder.append(expirationDate.getYear());
                String string5 = formattedDateBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                String formattedDate = string5;
                this.newCursorPosition = this.this$0.updateSelectionIndex$payments_core_release(formattedDate.length(), this.latestChangeStart, this.latestInsertionSize, ExpiryDateEditText.access$getDateDigitsLength$p(this.this$0) + ExpiryDateEditText.access$getSeparator$p(this.this$0).length());
                this.formattedDate = formattedDate;
            }

            public void afterTextChanged(@Nullable Editable s) {
                boolean shouldShowError;
                if (this.formattedDate != null) {
                    this.this$0.setTextSilent$payments_core_release(this.formattedDate);
                    Integer n = this.newCursorPosition;
                    if (n != null) {
                        Integer n2 = n;
                        ExpiryDateEditText expiryDateEditText = this.this$0;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        expiryDateEditText.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)expiryDateEditText.getFieldText$payments_core_release().length()));
                    }
                }
                String month = this.expirationDate.getMonth();
                String year = this.expirationDate.getYear();
                boolean bl = shouldShowError = month.length() == 2 && !this.expirationDate.isMonthValid();
                if (month.length() == 2 && year.length() == 2) {
                    boolean wasComplete = this.this$0.isDateValid();
                    ExpiryDateEditText.access$setDateValid$p(this.this$0, ExpiryDateEditText.access$isDateValid(this.this$0, month, year));
                    boolean bl2 = shouldShowError = !this.this$0.isDateValid();
                    if (!wasComplete && this.this$0.isDateValid()) {
                        this.this$0.getCompletionCallback$payments_core_release().invoke();
                    }
                } else {
                    ExpiryDateEditText.access$setDateValid$p(this.this$0, false);
                }
                this.this$0.setErrorMessage(this.this$0.getResources().getString(this.expirationDate.isPartialEntry$payments_core_release() ? R.string.stripe_incomplete_expiry_date : (!this.expirationDate.isMonthValid() ? R.string.stripe_invalid_expiry_month : R.string.stripe_invalid_expiry_year)));
                this.this$0.setShouldShowError(shouldShowError && (this.expirationDate.isPartialEntry$payments_core_release() || this.expirationDate.isComplete$payments_core_release()));
                this.formattedDate = null;
                this.newCursorPosition = null;
            }
        });
    }

    @VisibleForTesting
    public final int updateSelectionIndex$payments_core_release(int newLength, int editActionStart, int editActionAddition, int maxInputLength) {
        int gapsJumped = editActionStart <= 2 && editActionStart + editActionAddition >= 2 ? this.separator.length() : 0;
        boolean isDelete = editActionAddition == 0;
        boolean shouldRemoveSeparator = isDelete && editActionStart == 2 + this.separator.length();
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        boolean bl = false;
        int newPosition2 = newPosition - (shouldRemoveSeparator && newPosition > 0 ? this.separator.length() : 0);
        int untruncatedPosition = Math.min(newPosition2, newLength);
        return Math.min(maxInputLength, untruncatedPosition);
    }

    private final boolean isDateValid(String month, String year) {
        int n;
        int inputMonth;
        Object object;
        int n2;
        if (month.length() != 2) {
            n2 = -1;
        } else {
            ExpiryDateEditText expiryDateEditText = this;
            try {
                ExpiryDateEditText $this$isDateValid_u24lambda_u243 = expiryDateEditText;
                boolean bl = false;
                object = Result.constructor-impl((Object)Integer.parseInt(month));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            expiryDateEditText = object;
            object = -1;
            n2 = inputMonth = ((Number)(Result.isFailure-impl((Object)((Object)expiryDateEditText)) ? object : expiryDateEditText)).intValue();
        }
        if (year.length() != 2) {
            n = -1;
        } else {
            Object object2;
            object = this;
            try {
                Object $this$isDateValid_u24lambda_u244 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)DateUtils.INSTANCE.convertTwoDigitYearToFour(Integer.parseInt(year)));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            object2 = -1;
            n = ((Number)(Result.isFailure-impl((Object)object) ? object2 : object)).intValue();
        }
        int inputYear = n;
        return DateUtils.isExpiryDataValid(inputMonth, inputYear);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _init_$lambda$1(ExpiryDateEditText this$0, View view, boolean hasFocus) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!(hasFocus || (charSequence = (CharSequence)this$0.getText()) == null || charSequence.length() == 0 || this$0.isDateValid)) {
            this$0.setShouldShowError(true);
        }
    }

    public static final /* synthetic */ String access$getSeparator$p(ExpiryDateEditText $this) {
        return $this.separator;
    }

    public static final /* synthetic */ int access$getDateDigitsLength$p(ExpiryDateEditText $this) {
        return $this.dateDigitsLength;
    }

    public static final /* synthetic */ void access$setDateValid$p(ExpiryDateEditText $this, boolean bl) {
        $this.isDateValid = bl;
    }

    public static final /* synthetic */ boolean access$isDateValid(ExpiryDateEditText $this, String month, String year) {
        return $this.isDateValid(month, year);
    }

    public static final /* synthetic */ void access$updateSeparatorUi(ExpiryDateEditText $this, boolean includeSeparatorGaps) {
        $this.updateSeparatorUi(includeSeparatorGaps);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ExpiryDateEditText.class, "includeSeparatorGaps", "getIncludeSeparatorGaps$payments_core_release()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        $stable = 8;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText$Companion;", "", "()V", "INCLUDE_SEPARATOR_GAPS_DEFAULT", "", "INVALID_INPUT", "", "SEPARATOR_WITHOUT_GAPS", "", "SEPARATOR_WITH_GAPS", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

