/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.RepeatOnLifecycleKt;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeService;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.cards.DefaultStaticCardAccountRanges;
import com.stripe.android.cards.StaticCardAccountRanges;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.CardBrand;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardWidgetViewModel;
import com.stripe.android.view.CardWidgetViewModelKt;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002xyB%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB?\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fBc\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ/\u0010h\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u00072\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u00072\b\b\u0002\u0010M\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\blJ\b\u0010m\u001a\u00020'H\u0014J\r\u0010n\u001a\u00020'H\u0000\u00a2\u0006\u0002\boJ\b\u0010p\u001a\u00020'H\u0014J\u0012\u0010q\u001a\u00020'2\b\u0010r\u001a\u0004\u0018\u00010sH\u0016J\b\u0010t\u001a\u00020sH\u0016J\u0017\u0010u\u001a\u00020'2\b\b\u0002\u0010v\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bwR\u0014\u0010\u001b\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u00020\u001f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010(\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010.\u001a\u00020&2\u0006\u0010-\u001a\u00020&8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b/\u0010!\u001a\u0004\b0\u00101\"\u0004\b2\u00103R \u00104\u001a\b\u0012\u0004\u0012\u00020'0\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R<\u0010<\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010*\"\u0004\b>\u0010,R$\u0010?\u001a\u00020&2\u0006\u0010-\u001a\u00020&@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00101\"\u0004\bA\u00103R\u001e\u0010D\u001a\u00020C2\u0006\u0010B\u001a\u00020C@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010G\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020'0%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010*\"\u0004\bI\u0010,R\u0014\u0010J\u001a\u00020C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010ER\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010;R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010P\u001a\b\u0012\u0004\u0012\u00020&0O2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020&0O@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TRH\u0010U\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0O\u0012\u0004\u0012\u00020'0%2\u0018\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0O\u0012\u0004\u0012\u00020'0%@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010*\"\u0004\bW\u0010,R\u0014\u0010X\u001a\u00020Y8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[R\u0016\u0010\\\u001a\u0004\u0018\u00010]8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001c\u0010\u000b\u001a\u00020\n8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010g\u00a8\u0006z"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "uiContext", "Lkotlin/coroutines/CoroutineContext;", "workContext", "publishableKeySupplier", "Lkotlin/Function0;", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)V", "cardAccountRangeRepository", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "staticCardAccountRanges", "Lcom/stripe/android/cards/StaticCardAccountRanges;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/cards/CardAccountRangeRepository;Lcom/stripe/android/cards/StaticCardAccountRanges;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Landroidx/lifecycle/ViewModelStoreOwner;)V", "accessibilityText", "getAccessibilityText", "()Ljava/lang/String;", "accountRangeService", "Lcom/stripe/android/cards/CardAccountRangeService;", "getAccountRangeService$annotations", "()V", "getAccountRangeService", "()Lcom/stripe/android/cards/CardAccountRangeService;", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "brandChangeCallback", "getBrandChangeCallback$payments_core_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$payments_core_release", "(Lkotlin/jvm/functions/Function1;)V", "value", "cardBrand", "getCardBrand$annotations", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "setCardBrand$payments_core_release", "(Lcom/stripe/android/model/CardBrand;)V", "completionCallback", "getCompletionCallback$payments_core_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$payments_core_release", "(Lkotlin/jvm/functions/Function0;)V", "formattedPanLength", "getFormattedPanLength", "()I", "implicitCardBrandChangeCallback", "getImplicitCardBrandChangeCallback$payments_core_release", "setImplicitCardBrandChangeCallback$payments_core_release", "implicitCardBrandForCbc", "getImplicitCardBrandForCbc$payments_core_release", "setImplicitCardBrandForCbc$payments_core_release", "<set-?>", "", "isCardNumberValid", "()Z", "isCbcEligible", "isLoadingCallback", "isLoadingCallback$payments_core_release", "setLoadingCallback$payments_core_release", "isValid", "loadingJob", "Lkotlinx/coroutines/Job;", "panLength", "getPanLength$payments_core_release", "", "possibleCardBrands", "getPossibleCardBrands$payments_core_release", "()Ljava/util/List;", "setPossibleCardBrands$payments_core_release", "(Ljava/util/List;)V", "possibleCardBrandsCallback", "getPossibleCardBrandsCallback$payments_core_release", "setPossibleCardBrandsCallback$payments_core_release", "unvalidatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "getUnvalidatedCardNumber", "()Lcom/stripe/android/cards/CardNumber$Unvalidated;", "validatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Validated;", "getValidatedCardNumber$payments_core_release", "()Lcom/stripe/android/cards/CardNumber$Validated;", "getViewModelStoreOwner$payments_core_release", "()Landroidx/lifecycle/ViewModelStoreOwner;", "setViewModelStoreOwner$payments_core_release", "(Landroidx/lifecycle/ViewModelStoreOwner;)V", "getWorkContext", "()Lkotlin/coroutines/CoroutineContext;", "setWorkContext", "(Lkotlin/coroutines/CoroutineContext;)V", "calculateCursorPosition", "newFormattedLength", "start", "addedDigits", "calculateCursorPosition$payments_core_release", "onAttachedToWindow", "onCardMetadataLoadedTooSlow", "onCardMetadataLoadedTooSlow$payments_core_release", "onDetachedFromWindow", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "updateLengthFilter", "maxLength", "updateLengthFilter$payments_core_release", "CardNumberTextWatcher", "SavedState", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardNumberEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberEditText.kt\ncom/stripe/android/view/CardNumberEditText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,450:1\n1774#2,4:451\n1747#2,3:455\n*S KotlinDebug\n*F\n+ 1 CardNumberEditText.kt\ncom/stripe/android/view/CardNumberEditText\n*L\n286#1:451,4\n290#1:455,3\n*E\n"})
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private CoroutineContext workContext;
    @NotNull
    private final CardAccountRangeRepository cardAccountRangeRepository;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @Nullable
    private ViewModelStoreOwner viewModelStoreOwner;
    @NotNull
    private CardBrand cardBrand;
    private /* synthetic */ Function1<? super CardBrand, Unit> brandChangeCallback;
    @NotNull
    private CardBrand implicitCardBrandForCbc;
    @NotNull
    private Function1<? super CardBrand, Unit> implicitCardBrandChangeCallback;
    @NotNull
    private List<? extends CardBrand> possibleCardBrands;
    private /* synthetic */ Function1<? super List<? extends CardBrand>, Unit> possibleCardBrandsCallback;
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isCardNumberValid;
    private boolean isCbcEligible;
    @NotNull
    private final CardAccountRangeService accountRangeService;
    private /* synthetic */ Function1<? super Boolean, Unit> isLoadingCallback;
    @Nullable
    private Job loadingJob;
    public static final int $stable = 8;

    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull CoroutineContext uiContext, @NotNull CoroutineContext workContext, @NotNull CardAccountRangeRepository cardAccountRangeRepository2, @NotNull StaticCardAccountRanges staticCardAccountRanges, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @Nullable ViewModelStoreOwner viewModelStoreOwner) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)cardAccountRangeRepository2, (String)"cardAccountRangeRepository");
        Intrinsics.checkNotNullParameter((Object)staticCardAccountRanges, (String)"staticCardAccountRanges");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        super(context, attrs, defStyleAttr);
        this.workContext = workContext;
        this.cardAccountRangeRepository = cardAccountRangeRepository2;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.viewModelStoreOwner = viewModelStoreOwner;
        this.cardBrand = CardBrand.Unknown;
        this.brandChangeCallback = brandChangeCallback.1.INSTANCE;
        this.implicitCardBrandForCbc = CardBrand.Unknown;
        this.implicitCardBrandChangeCallback = implicitCardBrandChangeCallback.1.INSTANCE;
        this.possibleCardBrands = CollectionsKt.emptyList();
        this.possibleCardBrandsCallback = possibleCardBrandsCallback.1.INSTANCE;
        this.completionCallback = completionCallback.1.INSTANCE;
        String[] stringArray = this.cardAccountRangeRepository;
        CoroutineContext coroutineContext = this.workContext;
        CardAccountRangeService.AccountRangeResultListener accountRangeResultListener = new CardAccountRangeService.AccountRangeResultListener(this){
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onAccountRangesResult(@NotNull List<AccountRange> accountRanges) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
                CardNumberEditText.updateLengthFilter$payments_core_release$default(this.this$0, 0, 1, null);
                Iterable $this$map$iv = accountRanges;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AccountRange accountRange = (AccountRange)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getBrand());
                }
                List brands = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                CardBrand cardBrand = (CardBrand)CollectionsKt.singleOrNull((List)brands);
                if (cardBrand == null) {
                    cardBrand = CardBrand.Unknown;
                }
                this.this$0.setCardBrand$payments_core_release(cardBrand);
                if (CardNumberEditText.access$isCbcEligible$p(this.this$0)) {
                    CardBrand cardBrand2 = (CardBrand)CollectionsKt.firstOrNull((List)brands);
                    if (cardBrand2 == null) {
                        cardBrand2 = CardBrand.Unknown;
                    }
                    this.this$0.setImplicitCardBrandForCbc$payments_core_release(cardBrand2);
                    this.this$0.setPossibleCardBrands$payments_core_release(brands);
                }
            }
        };
        this.accountRangeService = new CardAccountRangeService((CardAccountRangeRepository)stringArray, uiContext, coroutineContext, staticCardAccountRanges, accountRangeResultListener, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return CardNumberEditText.access$isCbcEligible$p(this.this$0);
            }
        }));
        this.isLoadingCallback = isLoadingCallback.1.INSTANCE;
        this.setNumberOnlyInputType();
        this.setErrorMessage(this.getResources().getString(R.string.stripe_invalid_card_number));
        this.addTextChangedListener(new CardNumberTextWatcher());
        this.getInternalFocusChangeListeners().add((arg_0, arg_1) -> CardNumberEditText._init_$lambda$1(this, arg_0, arg_1));
        if (Build.VERSION.SDK_INT >= 26) {
            stringArray = new String[]{"creditCardNumber"};
            this.setAutofillHints(stringArray);
        }
        CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        this.setLayoutDirection(0);
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, CoroutineContext coroutineContext, CoroutineContext coroutineContext2, CardAccountRangeRepository cardAccountRangeRepository2, StaticCardAccountRanges staticCardAccountRanges, AnalyticsRequestExecutor analyticsRequestExecutor, PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, ViewModelStoreOwner viewModelStoreOwner, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        if ((n2 & 0x40) != 0) {
            staticCardAccountRanges = new DefaultStaticCardAccountRanges();
        }
        if ((n2 & 0x200) != 0) {
            viewModelStoreOwner = null;
        }
        this(context, attributeSet, n, coroutineContext, coroutineContext2, cardAccountRangeRepository2, staticCardAccountRanges, analyticsRequestExecutor, paymentAnalyticsRequestFactory, viewModelStoreOwner);
    }

    @VisibleForTesting
    @NotNull
    public final CoroutineContext getWorkContext() {
        return this.workContext;
    }

    public final void setWorkContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.workContext = coroutineContext;
    }

    @Nullable
    public final ViewModelStoreOwner getViewModelStoreOwner$payments_core_release() {
        return this.viewModelStoreOwner;
    }

    public final void setViewModelStoreOwner$payments_core_release(@Nullable ViewModelStoreOwner viewModelStoreOwner) {
        this.viewModelStoreOwner = viewModelStoreOwner;
    }

    @JvmOverloads
    public CardNumberEditText(final @NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, (CoroutineContext)Dispatchers.getMain(), (CoroutineContext)Dispatchers.getIO(), (Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return PaymentConfiguration.Companion.getInstance(context).getPublishableKey();
            }
        }));
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    private CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr, CoroutineContext uiContext, CoroutineContext workContext, Function0<String> publishableKeySupplier) {
        this(context, attrs, defStyleAttr, uiContext, workContext, new DefaultCardAccountRangeRepositoryFactory(context).create(), new DefaultStaticCardAccountRanges(), (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor(), new PaymentAnalyticsRequestFactory(context, (Provider<String>)((Provider)() -> CardNumberEditText._init_$lambda$0(publishableKeySupplier))), null, 512, null);
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$payments_core_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CardBrand prevBrand = this.cardBrand;
        this.cardBrand = value;
        if (value != prevBrand) {
            this.brandChangeCallback.invoke((Object)this.cardBrand);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @VisibleForTesting
    public static /* synthetic */ void getCardBrand$annotations() {
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$payments_core_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$payments_core_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.brandChangeCallback = callback;
        callback.invoke((Object)this.cardBrand);
    }

    @NotNull
    public final CardBrand getImplicitCardBrandForCbc$payments_core_release() {
        return this.implicitCardBrandForCbc;
    }

    public final void setImplicitCardBrandForCbc$payments_core_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CardBrand prevBrands = this.implicitCardBrandForCbc;
        this.implicitCardBrandForCbc = value;
        if (value != prevBrands) {
            this.implicitCardBrandChangeCallback.invoke((Object)value);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @NotNull
    public final Function1<CardBrand, Unit> getImplicitCardBrandChangeCallback$payments_core_release() {
        return this.implicitCardBrandChangeCallback;
    }

    public final void setImplicitCardBrandChangeCallback$payments_core_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.implicitCardBrandChangeCallback = callback;
        callback.invoke((Object)this.implicitCardBrandForCbc);
    }

    @NotNull
    public final List<CardBrand> getPossibleCardBrands$payments_core_release() {
        return this.possibleCardBrands;
    }

    public final void setPossibleCardBrands$payments_core_release(@NotNull List<? extends CardBrand> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List<? extends CardBrand> prevBrands = this.possibleCardBrands;
        this.possibleCardBrands = value;
        if (!Intrinsics.areEqual(value, prevBrands)) {
            this.possibleCardBrandsCallback.invoke(value);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @NotNull
    public final Function1<List<? extends CardBrand>, Unit> getPossibleCardBrandsCallback$payments_core_release() {
        return this.possibleCardBrandsCallback;
    }

    public final void setPossibleCardBrandsCallback$payments_core_release(@NotNull Function1<? super List<? extends CardBrand>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.possibleCardBrandsCallback = callback;
        callback.invoke(this.possibleCardBrands);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$payments_core_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$payments_core_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final int getPanLength$payments_core_release() {
        int n;
        AccountRange accountRange = this.accountRangeService.getAccountRange();
        if (accountRange != null) {
            n = accountRange.getPanLength();
        } else {
            AccountRange accountRange2 = this.accountRangeService.getStaticCardAccountRanges().first(this.getUnvalidatedCardNumber());
            n = accountRange2 != null ? accountRange2.getPanLength() : 16;
        }
        return n;
    }

    private final int getFormattedPanLength() {
        return this.getPanLength$payments_core_release() + CardNumber.Companion.getSpacePositions(this.getPanLength$payments_core_release()).size();
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Nullable
    public final CardNumber.Validated getValidatedCardNumber$payments_core_release() {
        return this.getUnvalidatedCardNumber().validate(this.getPanLength$payments_core_release());
    }

    private final CardNumber.Unvalidated getUnvalidatedCardNumber() {
        return new CardNumber.Unvalidated(this.getFieldText$payments_core_release());
    }

    private final boolean isValid() {
        return this.getValidatedCardNumber$payments_core_release() != null;
    }

    @NotNull
    public final CardAccountRangeService getAccountRangeService() {
        return this.accountRangeService;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAccountRangeService$annotations() {
    }

    @NotNull
    public final Function1<Boolean, Unit> isLoadingCallback$payments_core_release() {
        return this.isLoadingCallback;
    }

    public final void setLoadingCallback$payments_core_release(@NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.isLoadingCallback = function1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.loadingJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CardNumberEditText.access$getCardAccountRangeRepository$p(this.this$0).getLoading().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ CardNumberEditText this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(boolean it, @NotNull Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                    int label;
                                    final /* synthetic */ CardNumberEditText this$0;
                                    final /* synthetic */ boolean $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.isLoadingCallback$payments_core_release().invoke((Object)Boxing.boxBoolean((boolean)this.$it));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        CardWidgetViewModelKt.doWithCardWidgetViewModel((View)this, this.viewModelStoreOwner, (Function2<? super LifecycleOwner, ? super CardWidgetViewModel, Unit>)((Function2)new Function2<LifecycleOwner, CardWidgetViewModel, Unit>(this){
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull LifecycleOwner $this$doWithCardWidgetViewModel, @NotNull CardWidgetViewModel viewModel2) {
                void $this$launchAndCollect_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)$this$doWithCardWidgetViewModel, (String)"$this$doWithCardWidgetViewModel");
                Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
                Flow flow = (Flow)viewModel2.isCbcEligible();
                CardNumberEditText cardNumberEditText = this.this$0;
                Lifecycle.State minActiveState$iv = Lifecycle.State.STARTED;
                boolean $i$f$launchAndCollect = false;
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)$this$doWithCardWidgetViewModel)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$doWithCardWidgetViewModel, minActiveState$iv, (Flow)$this$launchAndCollect_u24default$iv, null, cardNumberEditText){
                    int label;
                    final /* synthetic */ LifecycleOwner $$context_receiver_0;
                    final /* synthetic */ Lifecycle.State $minActiveState;
                    final /* synthetic */ Flow $this_launchAndCollect;
                    final /* synthetic */ CardNumberEditText this$0;
                    {
                        this.$minActiveState = $minActiveState;
                        this.$this_launchAndCollect = $receiver;
                        this.this$0 = cardNumberEditText;
                        this.$$context_receiver_0 = $$context_receiver_0;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)this.$$context_receiver_0, (Lifecycle.State)this.$minActiveState, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$this_launchAndCollect, null, this.this$0){
                                    int label;
                                    final /* synthetic */ Flow $this_launchAndCollect;
                                    final /* synthetic */ CardNumberEditText this$0;
                                    {
                                        this.$this_launchAndCollect = $receiver;
                                        this.this$0 = cardNumberEditText;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.$this_launchAndCollect.collect(new FlowCollector(this.this$0){
                                                    final /* synthetic */ CardNumberEditText this$0;
                                                    {
                                                        this.this$0 = cardNumberEditText;
                                                    }

                                                    /*
                                                     * WARNING - void declaration
                                                     */
                                                    @Nullable
                                                    public final Object emit(T it, @NotNull Continuation<? super Unit> $completion) {
                                                        void $this$mapTo$iv$iv;
                                                        boolean isCbcEligible = (Boolean)it;
                                                        boolean bl = false;
                                                        CardNumberEditText.access$setCbcEligible$p(this.this$0, isCbcEligible);
                                                        Iterable $this$map$iv = this.this$0.getAccountRangeService().getAccountRanges();
                                                        boolean $i$f$map = false;
                                                        Iterable iterable = $this$map$iv;
                                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                        boolean $i$f$mapTo = false;
                                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                            void it2;
                                                            AccountRange accountRange = (AccountRange)item$iv$iv;
                                                            Collection collection = destination$iv$iv;
                                                            boolean bl2 = false;
                                                            collection.add(it2.getBrand());
                                                        }
                                                        List brands = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                                                        if (isCbcEligible) {
                                                            CardBrand cardBrand = (CardBrand)CollectionsKt.firstOrNull((List)brands);
                                                            if (cardBrand == null) {
                                                                cardBrand = CardBrand.Unknown;
                                                            }
                                                            this.this$0.setImplicitCardBrandForCbc$payments_core_release(cardBrand);
                                                            this.this$0.setPossibleCardBrands$payments_core_release(brands);
                                                        } else {
                                                            CardBrand cardBrand = (CardBrand)CollectionsKt.singleOrNull((List)brands);
                                                            if (cardBrand == null) {
                                                                cardBrand = CardBrand.Unknown;
                                                            }
                                                            this.this$0.setCardBrand$payments_core_release(cardBrand);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }, (Continuation)this);
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }));
    }

    @Override
    @NotNull
    protected String getAccessibilityText() {
        Object[] objectArray = new Object[]{this.getText()};
        String string2 = this.getResources().getString(R.string.stripe_acc_label_card_number_node, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    protected void onDetachedFromWindow() {
        Job job = this.loadingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.loadingJob = null;
        this.accountRangeService.cancelAccountRangeRepositoryJob();
        super.onDetachedFromWindow();
    }

    public final /* synthetic */ void updateLengthFilter$payments_core_release(int maxLength) {
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        this.setFilters(inputFilterArray);
    }

    public static /* synthetic */ void updateLengthFilter$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = cardNumberEditText.getFormattedPanLength();
        }
        cardNumberEditText.updateLengthFilter$payments_core_release(n);
    }

    public final /* synthetic */ int calculateCursorPosition$payments_core_release(int newFormattedLength, int start, int addedDigits, int panLength) {
        boolean bl;
        int gapsJumped;
        block7: {
            int gap;
            int n;
            Set gapSet = CardNumber.Companion.getSpacePositions(panLength);
            Iterable $this$count$iv = gapSet;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(start <= gap && start + addedDigits >= gap) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            gapsJumped = n;
            Iterable $this$any$iv = gapSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (!(addedDigits == 0 && start == gap + 1)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean skipBack = bl;
        int newPosition = start + addedDigits + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newFormattedLength ? newPosition : newFormattedLength;
    }

    public static /* synthetic */ int calculateCursorPosition$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = cardNumberEditText.getPanLength$payments_core_release();
        }
        return cardNumberEditText.calculateCursorPosition$payments_core_release(n, n2, n3, n4);
    }

    public final /* synthetic */ void onCardMetadataLoadedTooSlow$payments_core_release() {
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(this.paymentAnalyticsRequestFactory, PaymentAnalyticsEvent.CardMetadataLoadedTooSlow, null, null, null, null, null, 62, null));
    }

    @Override
    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.isCbcEligible);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Parcelable state) {
        SavedState savedState;
        SavedState savedState2 = savedState = state instanceof SavedState ? (SavedState)state : null;
        this.isCbcEligible = savedState2 != null ? savedState2.isCbcEligible() : false;
        SavedState savedState3 = savedState;
        if (savedState3 == null || (savedState3 = savedState3.getSuperState()) == null) {
            savedState3 = state;
        }
        super.onRestoreInstanceState(savedState3);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final String _init_$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }

    private static final void _init_$lambda$1(CardNumberEditText this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!hasFocus && this$0.getUnvalidatedCardNumber().isPartialEntry(this$0.getPanLength$payments_core_release())) {
            this$0.setShouldShowError(true);
        }
    }

    public static final /* synthetic */ CardAccountRangeRepository access$getCardAccountRangeRepository$p(CardNumberEditText $this) {
        return $this.cardAccountRangeRepository;
    }

    public static final /* synthetic */ void access$setCbcEligible$p(CardNumberEditText $this, boolean bl) {
        $this.isCbcEligible = bl;
    }

    public static final /* synthetic */ boolean access$isCbcEligible$p(CardNumberEditText $this) {
        return $this.isCbcEligible;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0004H\u0002J*\u0010\"\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006$"}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardNumberTextWatcher;", "Lcom/stripe/android/view/StripeTextWatcher;", "(Lcom/stripe/android/view/CardNumberEditText;)V", "beforeCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "digitsAdded", "", "getDigitsAdded", "()Z", "formattedNumber", "", "isPastedPan", "latestChangeStart", "", "latestInsertionSize", "newCursorPosition", "Ljava/lang/Integer;", "shouldUpdateAfterChange", "getShouldUpdateAfterChange", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "isComplete", "wasCardNumberValid", "startPosition", "previousCount", "currentCount", "cardNumber", "onTextChanged", "before", "payments-core_release"})
    private final class CardNumberTextWatcher
    extends StripeTextWatcher {
        private int latestChangeStart;
        private int latestInsertionSize;
        @Nullable
        private Integer newCursorPosition;
        @Nullable
        private String formattedNumber;
        @NotNull
        private CardNumber.Unvalidated beforeCardNumber;
        private boolean isPastedPan;

        public CardNumberTextWatcher() {
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
        }

        @Override
        public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            this.isPastedPan = false;
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
            this.latestChangeStart = start;
            this.latestInsertionSize = after;
        }

        @Override
        public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
            CharSequence charSequence = s;
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            if (string2 == null) {
                string2 = "";
            }
            CardNumber.Unvalidated cardNumber = new CardNumber.Unvalidated(string2);
            CardNumberEditText.this.getAccountRangeService().onCardNumberChanged(cardNumber);
            this.isPastedPan = this.isPastedPan(start, before, count, cardNumber);
            if (this.isPastedPan) {
                CardNumberEditText.this.updateLengthFilter$payments_core_release(cardNumber.getFormatted(cardNumber.getLength()).length());
            }
            int n = this.isPastedPan ? cardNumber.getLength() : CardNumberEditText.this.getPanLength$payments_core_release();
            CardNumberEditText cardNumberEditText = CardNumberEditText.this;
            int maxPanLength = n;
            boolean bl = false;
            String formattedNumber = cardNumber.getFormatted(maxPanLength);
            this.newCursorPosition = cardNumberEditText.calculateCursorPosition$payments_core_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize, maxPanLength);
            this.formattedNumber = formattedNumber;
        }

        @Override
        public void afterTextChanged(@Nullable Editable s) {
            if (this.getShouldUpdateAfterChange()) {
                CardNumberEditText.this.setTextSilent$payments_core_release(this.formattedNumber);
                Integer n = this.newCursorPosition;
                if (n != null) {
                    Integer n2 = n;
                    CardNumberEditText cardNumberEditText = CardNumberEditText.this;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    cardNumberEditText.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)cardNumberEditText.getFieldText$payments_core_release().length()));
                }
            }
            this.formattedNumber = null;
            this.newCursorPosition = null;
            if (CardNumberEditText.this.getUnvalidatedCardNumber().getLength() == CardNumberEditText.this.getPanLength$payments_core_release()) {
                boolean wasCardNumberValid = CardNumberEditText.this.isCardNumberValid();
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(!CardNumberEditText.this.isValid());
                if (CardNumberEditText.this.getAccountRangeService().getAccountRange() == null && CardNumberEditText.this.getUnvalidatedCardNumber().isValidLuhn()) {
                    CardNumberEditText.this.onCardMetadataLoadedTooSlow$payments_core_release();
                }
                if (this.isComplete(wasCardNumberValid)) {
                    CardNumberEditText.this.getCompletionCallback$payments_core_release().invoke();
                }
            } else if (CardNumberEditText.this.getUnvalidatedCardNumber().isPartialEntry(CardNumberEditText.this.getPanLength$payments_core_release()) && !CardNumberEditText.this.getUnvalidatedCardNumber().isPossibleCardBrand()) {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(true);
            } else {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(false);
            }
        }

        private final boolean getShouldUpdateAfterChange() {
            return (this.getDigitsAdded() || !CardNumberEditText.this.isLastKeyDelete$payments_core_release()) && this.formattedNumber != null;
        }

        private final boolean getDigitsAdded() {
            return CardNumberEditText.this.getUnvalidatedCardNumber().getLength() > this.beforeCardNumber.getLength();
        }

        private final boolean isComplete(boolean wasCardNumberValid) {
            return !wasCardNumberValid && (CardNumberEditText.this.getUnvalidatedCardNumber().isMaxLength() || CardNumberEditText.this.isValid() && CardNumberEditText.this.getAccountRangeService().getAccountRange() != null);
        }

        private final boolean isPastedPan(int startPosition, int previousCount, int currentCount, CardNumber.Unvalidated cardNumber) {
            return currentCount > previousCount && startPosition == 0 && cardNumber.getNormalized().length() >= 14;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/CardNumberEditText$SavedState;", "Landroid/view/View$BaseSavedState;", "Landroid/os/Parcelable;", "superSavedState", "isCbcEligible", "", "(Landroid/os/Parcelable;Z)V", "()Z", "getSuperSavedState", "()Landroid/os/Parcelable;", "component1", "component2", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class SavedState
    extends View.BaseSavedState
    implements Parcelable {
        @Nullable
        private final Parcelable superSavedState;
        private final boolean isCbcEligible;
        public static final int $stable = 8;
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;

        public SavedState(@Nullable Parcelable superSavedState, boolean isCbcEligible) {
            super(superSavedState);
            this.superSavedState = superSavedState;
            this.isCbcEligible = isCbcEligible;
        }

        @Nullable
        public final Parcelable getSuperSavedState() {
            return this.superSavedState;
        }

        public final boolean isCbcEligible() {
            return this.isCbcEligible;
        }

        @Nullable
        public final Parcelable component1() {
            return this.superSavedState;
        }

        public final boolean component2() {
            return this.isCbcEligible;
        }

        @NotNull
        public final SavedState copy(@Nullable Parcelable superSavedState, boolean isCbcEligible) {
            return new SavedState(superSavedState, isCbcEligible);
        }

        public static /* synthetic */ SavedState copy$default(SavedState savedState, Parcelable parcelable, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                parcelable = savedState.superSavedState;
            }
            if ((n & 2) != 0) {
                bl = savedState.isCbcEligible;
            }
            return savedState.copy(parcelable, bl);
        }

        @NotNull
        public String toString() {
            return "SavedState(superSavedState=" + this.superSavedState + ", isCbcEligible=" + this.isCbcEligible + ")";
        }

        public int hashCode() {
            int result2 = this.superSavedState == null ? 0 : this.superSavedState.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCbcEligible);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedState)) {
                return false;
            }
            SavedState savedState = (SavedState)((Object)other);
            if (!Intrinsics.areEqual((Object)this.superSavedState, (Object)savedState.superSavedState)) {
                return false;
            }
            return this.isCbcEligible == savedState.isCbcEligible;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeParcelable(this.superSavedState, flags);
            out.writeInt(this.isCbcEligible ? 1 : 0);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SavedState> {
                @NotNull
                public final SavedState[] newArray(int size) {
                    return new SavedState[size];
                }

                @NotNull
                public final SavedState createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new SavedState(parcel.readParcelable(SavedState.class.getClassLoader()), parcel.readInt() != 0);
                }
            }
            CREATOR = new Creator();
        }
    }
}

