/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.core.os.BundleKt;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.databinding.StripeCardFormViewBinding;
import com.stripe.android.databinding.StripeHorizontalDividerBinding;
import com.stripe.android.databinding.StripeVerticalDividerBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.ExpirationDate;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.uicore.R;
import com.stripe.android.view.CardFormView;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.CardValidCallback;
import com.stripe.android.view.CardWidgetViewModel;
import com.stripe.android.view.CardWidgetViewModelKt;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.LifecycleOwnerDelegate;
import com.stripe.android.view.PostalCodeEditText;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import com.stripe.payments.model.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001d\b\u0007\u0018\u0000 l2\u00020\u0001:\u0002lmB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020QH\u0002J\b\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020QH\u0014J\b\u0010V\u001a\u00020QH\u0014J\u001a\u0010W\u001a\u00020Q2\u0006\u0010X\u001a\u00020'2\b\u0010Y\u001a\u0004\u0018\u00010(H\u0002J\u0012\u0010Z\u001a\u00020Q2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0014J\b\u0010]\u001a\u00020\\H\u0014J\u0010\u0010^\u001a\u00020Q2\b\u0010_\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010`\u001a\u00020Q2\u0006\u0010a\u001a\u00020TH\u0016J\u0014\u0010b\u001a\u00020Q2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u000f0dJ\b\u0010e\u001a\u00020QH\u0002J\b\u0010f\u001a\u00020QH\u0002J\b\u0010g\u001a\u00020QH\u0002J\u0012\u0010h\u001a\u00020Q2\b\u0010Y\u001a\u0004\u0018\u00010(H\u0002J\u0012\u0010i\u001a\u00020Q2\b\u0010j\u001a\u0004\u0018\u00010kH\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\n /*\u0004\u0018\u00010.0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00103\u001a\u0004\u0018\u00010(2\b\u00102\u001a\u0004\u0018\u00010(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0016\u00108\u001a\u0004\u0018\u0001098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0013\u0010<\u001a\u0004\u0018\u00010=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006n"}, d2={"Lcom/stripe/android/view/CardFormView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "allEditTextFields", "", "Lcom/stripe/android/view/StripeEditText;", "getAllEditTextFields", "()Ljava/util/Collection;", "brand", "Lcom/stripe/android/model/CardBrand;", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "cardContainer", "Lcom/google/android/material/card/MaterialCardView;", "cardMultilineWidget", "Lcom/stripe/android/view/CardMultilineWidget;", "cardParams", "Lcom/stripe/android/model/CardParams;", "getCardParams", "()Lcom/stripe/android/model/CardParams;", "cardValidCallback", "Lcom/stripe/android/view/CardValidCallback;", "cardValidTextWatcher", "com/stripe/android/view/CardFormView$cardValidTextWatcher$1", "Lcom/stripe/android/view/CardFormView$cardValidTextWatcher$1;", "countryLayout", "Lcom/stripe/android/view/CountryTextInputLayout;", "countryPostalDivider", "Landroid/view/View;", "errors", "Landroid/widget/TextView;", "errorsMap", "", "Lcom/stripe/android/view/CardValidCallback$Fields;", "", "invalidFields", "", "getInvalidFields", "()Ljava/util/Set;", "layoutInflater", "Landroid/view/LayoutInflater;", "kotlin.jvm.PlatformType", "lifecycleOwnerDelegate", "Lcom/stripe/android/view/LifecycleOwnerDelegate;", "value", "onBehalfOf", "getOnBehalfOf", "()Ljava/lang/String;", "setOnBehalfOf", "(Ljava/lang/String;)V", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "postalCodeContainer", "Lcom/google/android/material/textfield/TextInputLayout;", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "postalCodeView", "Lcom/stripe/android/view/PostalCodeEditText;", "style", "Lcom/stripe/android/view/CardFormView$Style;", "viewBinding", "Lcom/stripe/android/databinding/StripeCardFormViewBinding;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "getViewModelStoreOwner$payments_core_release", "()Landroidx/lifecycle/ViewModelStoreOwner;", "setViewModelStoreOwner$payments_core_release", "(Landroidx/lifecycle/ViewModelStoreOwner;)V", "applyBorderlessStyle", "", "applyStandardStyle", "isPostalValid", "", "onAttachedToWindow", "onDetachedFromWindow", "onFieldError", "field", "errorMessage", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setCardValidCallback", "callback", "setEnabled", "enabled", "setPreferredNetworks", "preferredNetworks", "", "setupCardWidget", "setupCountryAndPostal", "showPostalError", "updateErrorsView", "updatePostalCodeViewLocale", "countryCode", "Lcom/stripe/android/core/model/CountryCode;", "Companion", "Style", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardFormView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardFormView.kt\ncom/stripe/android/view/CardFormView\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 TextView.kt\nandroidx/core/widget/TextViewKt\n+ 6 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,569:1\n52#2,9:570\n1#3:579\n1855#4,2:580\n1855#4,2:582\n1855#4,2:610\n1855#4:642\n1856#4:647\n1549#4:650\n1620#4,3:651\n288#4,2:654\n58#5,23:584\n93#5,3:607\n58#5,23:612\n93#5,3:635\n326#6,4:638\n326#6,4:643\n256#6,2:648\n256#6,2:656\n*S KotlinDebug\n*F\n+ 1 CardFormView.kt\ncom/stripe/android/view/CardFormView\n*L\n217#1:570,9\n241#1:580,2\n245#1:582,2\n322#1:610,2\n373#1:642\n373#1:647\n551#1:650\n551#1:651,3\n552#1:654,2\n273#1:584,23\n273#1:607,3\n352#1:612,23\n352#1:635,3\n363#1:638,4\n374#1:643,4\n538#1:648,2\n559#1:656,2\n*E\n"})
public final class CardFormView
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final LayoutInflater layoutInflater;
    @NotNull
    private final StripeCardFormViewBinding viewBinding;
    @NotNull
    private final MaterialCardView cardContainer;
    @NotNull
    private final CardMultilineWidget cardMultilineWidget;
    @NotNull
    private final View countryPostalDivider;
    @NotNull
    private final TextInputLayout postalCodeContainer;
    @NotNull
    private final TextView errors;
    @NotNull
    private final PostalCodeEditText postalCodeView;
    @NotNull
    private final CountryTextInputLayout countryLayout;
    @NotNull
    private final PostalCodeValidator postalCodeValidator;
    @NotNull
    private Style style;
    @NotNull
    private final Map<CardValidCallback.Fields, String> errorsMap;
    @Nullable
    private CardValidCallback cardValidCallback;
    @NotNull
    private final LifecycleOwnerDelegate lifecycleOwnerDelegate;
    @NotNull
    private final cardValidTextWatcher.1 cardValidTextWatcher;
    @Nullable
    private ViewModelStoreOwner viewModelStoreOwner;
    @Nullable
    private String onBehalfOf;
    public static final int $stable = 8;
    @NotNull
    public static final String CARD_FORM_VIEW = "CardFormView";
    @NotNull
    private static final String STATE_ENABLED = "state_enabled";
    @NotNull
    private static final String STATE_SUPER_STATE = "state_super_state";
    @NotNull
    private static final String STATE_ON_BEHALF_OF = "state_on_behalf_of";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CardFormView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void attrs$iv;
        void $this$withStyledAttributes_u24default$iv;
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.layoutInflater = LayoutInflater.from((Context)context);
        StripeCardFormViewBinding stripeCardFormViewBinding = StripeCardFormViewBinding.inflate(this.layoutInflater, (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeCardFormViewBinding, (String)"inflate(...)");
        this.viewBinding = stripeCardFormViewBinding;
        MaterialCardView materialCardView = this.viewBinding.cardMultilineWidgetContainer;
        Intrinsics.checkNotNullExpressionValue((Object)materialCardView, (String)"cardMultilineWidgetContainer");
        this.cardContainer = materialCardView;
        CardMultilineWidget cardMultilineWidget = this.viewBinding.cardMultilineWidget;
        Intrinsics.checkNotNullExpressionValue((Object)cardMultilineWidget, (String)"cardMultilineWidget");
        this.cardMultilineWidget = cardMultilineWidget;
        View view = this.viewBinding.countryPostalDivider;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"countryPostalDivider");
        this.countryPostalDivider = view;
        TextInputLayout textInputLayout = this.viewBinding.postalCodeContainer;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"postalCodeContainer");
        this.postalCodeContainer = textInputLayout;
        TextView textView = this.viewBinding.errors;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"errors");
        this.errors = textView;
        PostalCodeEditText postalCodeEditText = this.viewBinding.postalCode;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)postalCodeEditText), (String)"postalCode");
        this.postalCodeView = postalCodeEditText;
        CountryTextInputLayout countryTextInputLayout = this.viewBinding.countryLayout;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)countryTextInputLayout), (String)"countryLayout");
        this.countryLayout = countryTextInputLayout;
        this.postalCodeValidator = new PostalCodeValidator();
        this.style = Style.Standard;
        this.errorsMap = new LinkedHashMap();
        this.lifecycleOwnerDelegate = new LifecycleOwnerDelegate();
        this.cardValidTextWatcher = new StripeTextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterTextChanged(@Nullable Editable s) {
                block0: {
                    super.afterTextChanged(s);
                    CardValidCallback cardValidCallback = CardFormView.access$getCardValidCallback$p(this.this$0);
                    if (cardValidCallback == null) break block0;
                    cardValidCallback.onInputChanged(CardFormView.access$getInvalidFields(this.this$0).isEmpty(), CardFormView.access$getInvalidFields(this.this$0));
                }
            }
        };
        this.setOrientation(1);
        this.setupCountryAndPostal();
        this.setupCardWidget();
        ColorStateList backgroundColorStateList = null;
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.StripeCardFormView, (String)"StripeCardFormView");
        int[] nArray = R.styleable.StripeCardFormView;
        int defStyleAttr$iv = 0;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray $this$_init__u24lambda_u243 = typedArray = $this$withStyledAttributes_u24default$iv.obtainStyledAttributes(attrs, (int[])attrs$iv, defStyleAttr$iv, defStyleRes$iv);
        boolean bl = false;
        backgroundColorStateList = $this$_init__u24lambda_u243.getColorStateList(R.styleable.StripeCardFormView_backgroundColorStateList);
        this.style = (Style)((Object)Style.getEntries().get($this$_init__u24lambda_u243.getInt(R.styleable.StripeCardFormView_cardFormStyle, 0)));
        typedArray.recycle();
        ColorStateList colorStateList = backgroundColorStateList;
        if (colorStateList != null) {
            ColorStateList it = colorStateList;
            boolean bl2 = false;
            this.cardContainer.setCardBackgroundColor(it);
            this.cardMultilineWidget.setBackgroundColor(0);
            this.countryLayout.setBackgroundColor(0);
            this.postalCodeContainer.setBackgroundColor(0);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.style.ordinal()]) {
            case 1: {
                this.applyStandardStyle();
                break;
            }
            case 2: {
                this.applyBorderlessStyle();
            }
        }
    }

    public /* synthetic */ CardFormView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final Collection<StripeEditText> getAllEditTextFields() {
        StripeEditText[] stripeEditTextArray = new StripeEditText[]{this.cardMultilineWidget.getCardNumberEditText(), this.cardMultilineWidget.getExpiryDateEditText(), this.cardMultilineWidget.getCvcEditText(), this.postalCodeView};
        return CollectionsKt.listOf((Object[])stripeEditTextArray);
    }

    private final Set<CardValidCallback.Fields> getInvalidFields() {
        CardValidCallback.Fields fields;
        CardValidCallback.Fields fields2 = fields = CardValidCallback.Fields.Postal;
        Collection collection = CollectionsKt.toList((Iterable)this.cardMultilineWidget.getInvalidFields$payments_core_release());
        boolean bl = false;
        boolean bl2 = !this.isPostalValid();
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object)((Object)(bl2 ? fields : null)))));
    }

    @Nullable
    public final ViewModelStoreOwner getViewModelStoreOwner$payments_core_release() {
        return this.viewModelStoreOwner;
    }

    public final void setViewModelStoreOwner$payments_core_release(@Nullable ViewModelStoreOwner viewModelStoreOwner) {
        this.viewModelStoreOwner = viewModelStoreOwner;
    }

    @NotNull
    public final CardBrand getBrand() {
        return this.cardMultilineWidget.getBrand();
    }

    @Nullable
    public final CardParams getCardParams() {
        if (!this.cardMultilineWidget.validateAllFields()) {
            this.cardMultilineWidget.setShouldShowErrorIcon$payments_core_release(true);
            return null;
        }
        this.cardMultilineWidget.setShouldShowErrorIcon$payments_core_release(false);
        if (!this.isPostalValid()) {
            this.showPostalError();
            return null;
        }
        this.updateErrorsView(null);
        ExpirationDate.Validated validated = this.cardMultilineWidget.getExpiryDateEditText().getValidatedDate();
        if (validated == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        ExpirationDate.Validated expirationDate = validated;
        CardBrand cardBrand = this.getBrand();
        Set set = SetsKt.setOf((Object)CARD_FORM_VIEW);
        CardNumber.Validated validated2 = this.cardMultilineWidget.getValidatedCardNumber$payments_core_release();
        String string3 = validated2 != null ? validated2.getValue() : null;
        if (string3 == null) {
            string3 = "";
        }
        Editable editable = this.cardMultilineWidget.getCvcEditText().getText();
        Editable editable2 = this.postalCodeView.getText();
        return new CardParams(cardBrand, set, string3, expirationDate.getMonth(), expirationDate.getYear(), editable != null ? editable.toString() : null, null, new Address.Builder().setCountryCode(this.countryLayout.getSelectedCountryCode$payments_core_release()).setPostalCode(editable2 != null ? editable2.toString() : null).build(), null, this.cardMultilineWidget.getCardBrandView$payments_core_release().cardParamsNetworks(), null, 1344, null);
    }

    private final PaymentMethodCreateParams.Card getPaymentMethodCard() {
        PaymentMethodCreateParams.Card card;
        CardParams cardParams = this.getCardParams();
        if (cardParams != null) {
            CardParams it = cardParams;
            boolean bl = false;
            String string2 = it.getNumber();
            String string3 = it.getCvc();
            int n = it.getExpMonth();
            int n2 = it.getExpYear();
            Set set = it.getAttribution();
            PaymentMethodCreateParams.Card.Networks networks = this.cardMultilineWidget.getCardBrandView$payments_core_release().paymentMethodCreateParamsNetworks();
            card = new PaymentMethodCreateParams.Card(string2, n, n2, string3, null, set, networks, 16, null);
        } else {
            card = null;
        }
        return card;
    }

    @Nullable
    public final PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card != null) {
            PaymentMethodCreateParams.Card it = card;
            boolean bl = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, it, null, null, null, 14, null);
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    @Nullable
    public final String getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public final void setOnBehalfOf(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.onBehalfOf, (Object)value)) {
            if (this.isAttachedToWindow()) {
                CardWidgetViewModelKt.doWithCardWidgetViewModel((View)this, this.viewModelStoreOwner, (Function2<? super LifecycleOwner, ? super CardWidgetViewModel, Unit>)((Function2)new Function2<LifecycleOwner, CardWidgetViewModel, Unit>(value){
                    final /* synthetic */ String $value;
                    {
                        this.$value = $value;
                        super(2);
                    }

                    public final void invoke(@NotNull LifecycleOwner $this$doWithCardWidgetViewModel, @NotNull CardWidgetViewModel viewModel2) {
                        Intrinsics.checkNotNullParameter((Object)$this$doWithCardWidgetViewModel, (String)"$this$doWithCardWidgetViewModel");
                        Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
                        viewModel2.setOnBehalfOf(this.$value);
                    }
                }));
            }
            this.onBehalfOf = value;
        }
    }

    public final void setCardValidCallback(@Nullable CardValidCallback callback) {
        block3: {
            StripeEditText it;
            this.cardValidCallback = callback;
            Iterable $this$forEach$iv = this.getAllEditTextFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StripeEditText)((Object)element$iv);
                boolean bl = false;
                it.removeTextChangedListener(this.cardValidTextWatcher);
            }
            if (callback != null) {
                $this$forEach$iv = this.getAllEditTextFields();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StripeEditText)((Object)element$iv);
                    boolean bl = false;
                    it.addTextChangedListener(this.cardValidTextWatcher);
                }
            }
            CardValidCallback cardValidCallback = this.cardValidCallback;
            if (cardValidCallback == null) break block3;
            cardValidCallback.onInputChanged(this.getInvalidFields().isEmpty(), this.getInvalidFields());
        }
    }

    private final void setupCountryAndPostal() {
        this.updatePostalCodeViewLocale(this.countryLayout.getSelectedCountryCode$payments_core_release());
        this.postalCodeView.setErrorColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stripe_card_form_view_form_error));
        this.postalCodeView.getInternalFocusChangeListeners().add((arg_0, arg_1) -> CardFormView.setupCountryAndPostal$lambda$7(this, arg_0, arg_1));
        TextView $this$doAfterTextChanged$iv = (TextView)this.postalCodeView;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = cardFormView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable it = s;
                boolean bl = false;
                CardFormView.access$onFieldError(this.this$0, CardValidCallback.Fields.Postal, null);
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                boolean bl = false;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                boolean bl = false;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        this.postalCodeView.setErrorMessageListener(arg_0 -> CardFormView.setupCountryAndPostal$lambda$9(this, arg_0));
        this.countryLayout.setCountryCodeChangeCallback((Function1<? super CountryCode, Unit>)((Function1)new Function1<CountryCode, Unit>(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CountryCode countryCode) {
                void $this$isVisible$iv;
                Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
                CardFormView.access$updatePostalCodeViewLocale(this.this$0, countryCode);
                View view = (View)CardFormView.access$getPostalCodeContainer$p(this.this$0);
                boolean value$iv = CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode);
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                CardFormView.access$getPostalCodeView$p(this.this$0).setShouldShowError(false);
                CardFormView.access$getPostalCodeView$p(this.this$0).setText(null);
            }
        }));
    }

    private final void updatePostalCodeViewLocale(CountryCode countryCode) {
        if (CountryCode.Companion.isUS(countryCode)) {
            this.postalCodeView.setConfig$payments_core_release(PostalCodeEditText.Config.US);
            this.postalCodeView.setErrorMessage(this.getResources().getString(R.string.stripe_address_zip_invalid));
        } else {
            this.postalCodeView.setConfig$payments_core_release(PostalCodeEditText.Config.Global);
            this.postalCodeView.setErrorMessage(this.getResources().getString(R.string.stripe_address_postal_code_invalid));
        }
    }

    private final boolean isPostalValid() {
        boolean bl;
        CountryCode countryCode = this.countryLayout.getSelectedCountryCode$payments_core_release();
        if (countryCode != null) {
            CountryCode countryCode2 = countryCode;
            boolean bl2 = false;
            String string2 = this.postalCodeView.getPostalCode$payments_core_release();
            if (string2 == null) {
                string2 = "";
            }
            bl = this.postalCodeValidator.isValid(string2, countryCode2.getValue());
        } else {
            bl = false;
        }
        return bl;
    }

    private final void showPostalError() {
        this.onFieldError(CardValidCallback.Fields.Postal, this.postalCodeView.getErrorMessage$payments_core_release());
    }

    private final void setupCardWidget() {
        StripeEditText[] stripeEditTextArray = new StripeEditText[]{this.cardMultilineWidget.getCardNumberEditText(), this.cardMultilineWidget.getExpiryDateEditText(), this.cardMultilineWidget.getCvcEditText()};
        Iterable $this$forEach$iv = SetsKt.setOf((Object[])stripeEditTextArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText editText = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            editText.setTextSize(0, this.getResources().getDimension(R.dimen.stripe_card_form_view_textsize));
            editText.setTextColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.stripe_card_form_view_text_color));
            editText.setBackgroundResource(17170445);
            editText.setErrorColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stripe_card_form_view_form_error));
        }
        this.cardMultilineWidget.getExpiryDateEditText().setIncludeSeparatorGaps$payments_core_release(true);
        this.cardMultilineWidget.setExpirationDatePlaceholderRes$payments_core_release(null);
        this.cardMultilineWidget.getExpiryTextInputLayout().setHint((CharSequence)this.getContext().getString(R.string.stripe_expiration_date_hint));
        this.cardMultilineWidget.getCardNumberTextInputLayout().setPlaceholderText(null);
        this.cardMultilineWidget.setCvcPlaceholderText("");
        this.cardMultilineWidget.setViewModelStoreOwner$payments_core_release(this.viewModelStoreOwner);
        this.cardMultilineWidget.getCardNumberEditText().setViewModelStoreOwner$payments_core_release(this.viewModelStoreOwner);
        this.cardMultilineWidget.getCvcEditText().setImeOptions(5);
        this.cardMultilineWidget.setBackgroundResource(R.drawable.stripe_card_form_view_text_input_layout_background);
        TextView $this$doAfterTextChanged$iv = (TextView)this.cardMultilineWidget.getCvcEditText();
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = cardFormView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable cvcText = s;
                boolean bl = false;
                View $this$isVisible$iv = (View)CardFormView.access$getPostalCodeContainer$p(this.this$0);
                boolean $i$f$isVisible = false;
                if ($this$isVisible$iv.getVisibility() == 0 && CardFormView.access$getCardMultilineWidget$p(this.this$0).getBrand().isMaxCvc(String.valueOf(cvcText))) {
                    CardFormView.access$getPostalCodeView$p(this.this$0).requestFocus();
                }
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                boolean bl = false;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                boolean bl = false;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        int layoutMarginHorizontal = this.getResources().getDimensionPixelSize(R.dimen.stripe_card_form_view_text_margin_horizontal);
        int layoutMarginVertical = this.getResources().getDimensionPixelSize(R.dimen.stripe_card_form_view_text_margin_vertical);
        Object[] $this$updateLayoutParams$iv = (Object[])this.cardMultilineWidget.getCardNumberTextInputLayout();
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((FrameLayout.LayoutParams)layoutParams);
        FrameLayout.LayoutParams $this$setupCardWidget_u24lambda_u2413 = (FrameLayout.LayoutParams)params$iv;
        boolean bl = false;
        $this$setupCardWidget_u24lambda_u2413.setMarginStart(layoutMarginHorizontal);
        $this$setupCardWidget_u24lambda_u2413.setMarginEnd(layoutMarginHorizontal);
        $this$setupCardWidget_u24lambda_u2413.topMargin = layoutMarginVertical;
        $this$setupCardWidget_u24lambda_u2413.bottomMargin = layoutMarginVertical;
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        $this$updateLayoutParams$iv = new TextInputLayout[]{this.cardMultilineWidget.getExpiryTextInputLayout(), this.cardMultilineWidget.getCvcInputLayout()};
        Iterable $this$forEach$iv2 = SetsKt.setOf((Object[])$this$updateLayoutParams$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            TextInputLayout frameLayout = (TextInputLayout)element$iv;
            boolean bl2 = false;
            View $this$updateLayoutParams$iv2 = (View)frameLayout;
            boolean $i$f$updateLayoutParamsTyped2 = false;
            ViewGroup.LayoutParams layoutParams2 = $this$updateLayoutParams$iv2.getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
            }
            ViewGroup.LayoutParams params$iv2 = (ViewGroup.LayoutParams)((LinearLayout.LayoutParams)layoutParams2);
            LinearLayout.LayoutParams $this$setupCardWidget_u24lambda_u2415_u24lambda_u2414 = (LinearLayout.LayoutParams)params$iv2;
            boolean bl3 = false;
            $this$setupCardWidget_u24lambda_u2415_u24lambda_u2414.setMarginStart(layoutMarginHorizontal);
            $this$setupCardWidget_u24lambda_u2415_u24lambda_u2414.setMarginEnd(layoutMarginHorizontal);
            $this$setupCardWidget_u24lambda_u2415_u24lambda_u2414.topMargin = layoutMarginVertical;
            $this$setupCardWidget_u24lambda_u2415_u24lambda_u2414.bottomMargin = layoutMarginVertical;
            $this$updateLayoutParams$iv2.setLayoutParams(params$iv2);
            frameLayout.setErrorEnabled(false);
            frameLayout.setError(null);
        }
        this.cardMultilineWidget.setCvcIcon(R.drawable.stripe_ic_cvc);
        this.cardMultilineWidget.setCardNumberErrorListener$payments_core_release(arg_0 -> CardFormView.setupCardWidget$lambda$16(this, arg_0));
        this.cardMultilineWidget.setExpirationDateErrorListener$payments_core_release(arg_0 -> CardFormView.setupCardWidget$lambda$17(this, arg_0));
        this.cardMultilineWidget.setCvcErrorListener$payments_core_release(arg_0 -> CardFormView.setupCardWidget$lambda$18(this, arg_0));
        this.cardMultilineWidget.setPostalCodeErrorListener$payments_core_release(null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cardContainer.setEnabled(enabled);
        this.cardMultilineWidget.setEnabled(enabled);
        this.countryLayout.setEnabled(enabled);
        this.postalCodeContainer.setEnabled(enabled);
        this.errors.setEnabled(enabled);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)STATE_SUPER_STATE, (Object)super.onSaveInstanceState()), TuplesKt.to((Object)STATE_ENABLED, (Object)this.isEnabled()), TuplesKt.to((Object)STATE_ON_BEHALF_OF, (Object)this.onBehalfOf)};
        return (Parcelable)BundleKt.bundleOf((Pair[])pairArray);
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof Bundle) {
            super.onRestoreInstanceState(((Bundle)state).getParcelable(STATE_SUPER_STATE));
            this.setEnabled(((Bundle)state).getBoolean(STATE_ENABLED));
            this.setOnBehalfOf(((Bundle)state).getString(STATE_ON_BEHALF_OF));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.lifecycleOwnerDelegate.initLifecycle((View)this);
        CardWidgetViewModelKt.doWithCardWidgetViewModel((View)this, this.viewModelStoreOwner, (Function2<? super LifecycleOwner, ? super CardWidgetViewModel, Unit>)((Function2)new Function2<LifecycleOwner, CardWidgetViewModel, Unit>(this){
            final /* synthetic */ CardFormView this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull LifecycleOwner $this$doWithCardWidgetViewModel, @NotNull CardWidgetViewModel viewModel2) {
                Intrinsics.checkNotNullParameter((Object)$this$doWithCardWidgetViewModel, (String)"$this$doWithCardWidgetViewModel");
                Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
                if (this.this$0.getOnBehalfOf() != null && !Intrinsics.areEqual((Object)viewModel2.getOnBehalfOf(), (Object)this.this$0.getOnBehalfOf())) {
                    viewModel2.setOnBehalfOf(this.this$0.getOnBehalfOf());
                }
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.lifecycleOwnerDelegate.destroyLifecycle((View)this);
    }

    public final void setPreferredNetworks(@NotNull List<? extends CardBrand> preferredNetworks) {
        Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
        this.cardMultilineWidget.getCardBrandView$payments_core_release().setMerchantPreferredNetworks(preferredNetworks);
    }

    private final void applyStandardStyle() {
        this.cardMultilineWidget.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getSecondRowLayout().addView(StripeVerticalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget.getSecondRowLayout(), false).getRoot(), 1);
        this.cardMultilineWidget.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), this.cardMultilineWidget.getChildCount());
        this.cardContainer.setCardElevation(this.getResources().getDimension(R.dimen.stripe_card_form_view_card_elevation));
    }

    /*
     * WARNING - void declaration
     */
    private final void applyBorderlessStyle() {
        void $this$isVisible$iv;
        this.cardMultilineWidget.getCardNumberTextInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getExpiryTextInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.cardMultilineWidget.getCvcInputLayout().addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.cardMultilineWidget, false).getRoot(), 1);
        this.countryLayout.addView(StripeHorizontalDividerBinding.inflate(this.layoutInflater, (ViewGroup)this.countryLayout, false).getRoot());
        View view = this.countryPostalDivider;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.cardContainer.setCardElevation(0.0f);
    }

    /*
     * WARNING - void declaration
     */
    private final void onFieldError(CardValidCallback.Fields field, String errorMessage) {
        Object v1;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            this.errorsMap.put(field, errorMessage);
            Iterable iterable = (Iterable)CardValidCallback.Fields.getEntries();
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CardValidCallback.Fields fields = (CardValidCallback.Fields)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.errorsMap.get(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        String error = v1;
        this.updateErrorsView(error);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateErrorsView(String errorMessage) {
        void $this$isVisible$iv;
        this.errors.setText((CharSequence)errorMessage);
        View view = (View)this.errors;
        boolean value$iv = errorMessage != null;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }

    @JvmOverloads
    public CardFormView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardFormView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setupCountryAndPostal$lambda$7(CardFormView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!hasFocus) {
            this$0.postalCodeView.setShouldShowError(!StringsKt.isBlank((CharSequence)this$0.postalCodeView.getFieldText$payments_core_release()) && !this$0.isPostalValid());
            if (this$0.postalCodeView.getShouldShowError()) {
                this$0.showPostalError();
            } else {
                this$0.onFieldError(CardValidCallback.Fields.Postal, null);
            }
        }
    }

    private static final void setupCountryAndPostal$lambda$9(CardFormView this$0, String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onFieldError(CardValidCallback.Fields.Postal, errorMessage);
    }

    private static final void setupCardWidget$lambda$16(CardFormView this$0, String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onFieldError(CardValidCallback.Fields.Number, errorMessage);
    }

    private static final void setupCardWidget$lambda$17(CardFormView this$0, String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onFieldError(CardValidCallback.Fields.Expiry, errorMessage);
    }

    private static final void setupCardWidget$lambda$18(CardFormView this$0, String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onFieldError(CardValidCallback.Fields.Cvc, errorMessage);
    }

    public static final /* synthetic */ void access$updatePostalCodeViewLocale(CardFormView $this, CountryCode countryCode) {
        $this.updatePostalCodeViewLocale(countryCode);
    }

    public static final /* synthetic */ TextInputLayout access$getPostalCodeContainer$p(CardFormView $this) {
        return $this.postalCodeContainer;
    }

    public static final /* synthetic */ PostalCodeEditText access$getPostalCodeView$p(CardFormView $this) {
        return $this.postalCodeView;
    }

    public static final /* synthetic */ void access$onFieldError(CardFormView $this, CardValidCallback.Fields field, String errorMessage) {
        $this.onFieldError(field, errorMessage);
    }

    public static final /* synthetic */ CardMultilineWidget access$getCardMultilineWidget$p(CardFormView $this) {
        return $this.cardMultilineWidget;
    }

    public static final /* synthetic */ CardValidCallback access$getCardValidCallback$p(CardFormView $this) {
        return $this.cardValidCallback;
    }

    public static final /* synthetic */ Set access$getInvalidFields(CardFormView $this) {
        return $this.getInvalidFields();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CardFormView$Companion;", "", "()V", "CARD_FORM_VIEW", "", "STATE_ENABLED", "STATE_ON_BEHALF_OF", "STATE_SUPER_STATE", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/CardFormView$Style;", "", "attrValue", "", "(Ljava/lang/String;II)V", "getAttrValue$payments_core_release", "()I", "Standard", "Borderless", "payments-core_release"})
    private static final class Style
    extends Enum<Style> {
        private final int attrValue;
        public static final /* enum */ Style Standard = new Style(0);
        public static final /* enum */ Style Borderless = new Style(1);
        private static final /* synthetic */ Style[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Style(int attrValue) {
            this.attrValue = attrValue;
        }

        public final int getAttrValue$payments_core_release() {
            return this.attrValue;
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }

        public static Style valueOf(String value) {
            return Enum.valueOf(Style.class, value);
        }

        @NotNull
        public static EnumEntries<Style> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = styleArray = new Style[]{Style.Standard, Style.Borderless};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Style.values().length];
            try {
                nArray[Style.Standard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Style.Borderless.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

