/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.view.StripeColorUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/BrandAdapter;", "Landroid/widget/ArrayAdapter;", "Lcom/stripe/android/model/CardBrand;", "context", "Landroid/content/Context;", "brands", "", "selectedBrand", "(Landroid/content/Context;Ljava/util/List;Lcom/stripe/android/model/CardBrand;)V", "colorUtils", "Lcom/stripe/android/view/StripeColorUtils;", "inflater", "Landroid/view/LayoutInflater;", "kotlin.jvm.PlatformType", "areAllItemsEnabled", "", "getCount", "", "getItem", "position", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "isEnabled", "updateView", "", "view", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class BrandAdapter
extends ArrayAdapter<CardBrand> {
    @NotNull
    private final List<CardBrand> brands;
    @Nullable
    private final CardBrand selectedBrand;
    private final LayoutInflater inflater;
    @NotNull
    private final StripeColorUtils colorUtils;
    public static final int $stable = 8;

    public BrandAdapter(@NotNull Context context, @NotNull List<? extends CardBrand> brands, @Nullable CardBrand selectedBrand) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(brands, (String)"brands");
        super(context, 0, brands);
        this.brands = brands;
        this.selectedBrand = selectedBrand;
        this.inflater = LayoutInflater.from((Context)context);
        this.colorUtils = new StripeColorUtils(context);
    }

    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        View view;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view2 = view = position == 0 ? this.inflater.inflate(R.layout.stripe_select_card_brand_view, parent, false) : this.inflater.inflate(R.layout.stripe_card_brand_choice_list_view, parent, false);
        if (position > 0) {
            Intrinsics.checkNotNull((Object)view);
            this.updateView(view, position);
        }
        Intrinsics.checkNotNull((Object)view);
        return view;
    }

    @Nullable
    public CardBrand getItem(int position) {
        return position == 0 ? null : (CardBrand)super.getItem(position - 1);
    }

    public int getCount() {
        return this.brands.isEmpty() ? 0 : this.brands.size() + 1;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        return position != 0;
    }

    private final void updateView(View view, int position) {
        block6: {
            CardBrand cardBrand = (CardBrand)CollectionsKt.getOrNull(this.brands, (int)(position - 1));
            if (cardBrand == null) break block6;
            CardBrand brand = cardBrand;
            boolean bl = false;
            boolean isSelected = brand == this.selectedBrand;
            ImageView imageView = (ImageView)view.findViewById(R.id.brand_icon);
            if (imageView != null) {
                imageView.setBackgroundResource(brand.getIcon());
            }
            View view2 = view.findViewById(R.id.brand_check);
            ImageView $this$updateView_u24lambda_u242_u24lambda_u240 = (ImageView)view2;
            boolean bl2 = false;
            if (isSelected) {
                $this$updateView_u24lambda_u242_u24lambda_u240.setVisibility(0);
                $this$updateView_u24lambda_u242_u24lambda_u240.setColorFilter(this.colorUtils.getColorPrimary());
            } else {
                $this$updateView_u24lambda_u242_u24lambda_u240.setVisibility(8);
            }
            View view3 = view2 = (TextView)view.findViewById(R.id.brand_text);
            if (view3 != null) {
                View view4;
                Intrinsics.checkNotNull((Object)view3);
                View $this$updateView_u24lambda_u242_u24lambda_u241 = view4 = view2;
                boolean bl3 = false;
                $this$updateView_u24lambda_u242_u24lambda_u241.setText((CharSequence)brand.getDisplayName());
                if (isSelected) {
                    $this$updateView_u24lambda_u242_u24lambda_u241.setTextColor(this.colorUtils.getColorPrimary());
                    $this$updateView_u24lambda_u242_u24lambda_u241.setTypeface(Typeface.DEFAULT_BOLD);
                } else {
                    $this$updateView_u24lambda_u242_u24lambda_u241.setTypeface(Typeface.DEFAULT);
                }
            }
        }
    }
}

