/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.Size;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceOrder;
import com.stripe.android.model.SourceTypeModel;
import com.stripe.android.model.WeChat;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.SourceCardDataJsonParser;
import com.stripe.android.model.parsers.SourceOrderJsonParser;
import com.stripe.android.model.parsers.SourceSepaDebitDataJsonParser;
import com.stripe.android.model.parsers.WeChatJsonParser;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0007\b\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source;", "()V", "parse", "json", "Lorg/json/JSONObject;", "CodeVerificationJsonParser", "Companion", "KlarnaJsonParser", "OwnerJsonParser", "ReceiverJsonParser", "RedirectJsonParser", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class SourceJsonParser
implements ModelJsonParser<Source> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String VALUE_SOURCE = "source";
    @NotNull
    private static final String VALUE_CARD = "card";
    @NotNull
    private static final Set<String> MODELED_TYPES;
    @NotNull
    private static final String FIELD_ID = "id";
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_AMOUNT = "amount";
    @NotNull
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    @NotNull
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    @NotNull
    private static final String FIELD_CREATED = "created";
    @NotNull
    private static final String FIELD_CURRENCY = "currency";
    @NotNull
    private static final String FIELD_FLOW = "flow";
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @NotNull
    private static final String FIELD_OWNER = "owner";
    @NotNull
    private static final String FIELD_RECEIVER = "receiver";
    @NotNull
    private static final String FIELD_REDIRECT = "redirect";
    @NotNull
    private static final String FIELD_SOURCE_ORDER = "source_order";
    @NotNull
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @NotNull
    private static final String FIELD_STATUS = "status";
    @NotNull
    private static final String FIELD_TYPE = "type";
    @NotNull
    private static final String FIELD_USAGE = "usage";
    @NotNull
    private static final String FIELD_WECHAT = "wechat";
    @NotNull
    private static final String FIELD_KLARNA = "klarna";

    @Nullable
    public Source parse(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string2 = json.optString(FIELD_OBJECT);
        return Intrinsics.areEqual((Object)string2, (Object)VALUE_CARD) ? SourceJsonParser.Companion.fromCardJson(json) : (Intrinsics.areEqual((Object)string2, (Object)VALUE_SOURCE) ? SourceJsonParser.Companion.fromSourceJson(json) : null);
    }

    static {
        Object[] objectArray = new String[]{VALUE_CARD, "sepa_debit"};
        MODELED_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$CodeVerification;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class CodeVerificationJsonParser
    implements ModelJsonParser<Source.CodeVerification> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
        @NotNull
        private static final String FIELD_STATUS = "status";
        private static final int INVALID_ATTEMPTS_REMAINING = -1;

        @NotNull
        public Source.CodeVerification parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.CodeVerification(json.optInt(FIELD_ATTEMPTS_REMAINING, -1), Source.CodeVerification.Status.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)"status")));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$CodeVerificationJsonParser$Companion;", "", "()V", "FIELD_ATTEMPTS_REMAINING", "", "FIELD_STATUS", "INVALID_ATTEMPTS_REMAINING", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010\"\u001a\u0004\u0018\u0001H#\"\n\b\u0000\u0010#\u0018\u0001*\u00020$2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010%\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CLIENT_SECRET", "FIELD_CODE_VERIFICATION", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_FLOW", "FIELD_ID", "FIELD_KLARNA", "FIELD_LIVEMODE", "FIELD_OBJECT", "FIELD_OWNER", "FIELD_RECEIVER", "FIELD_REDIRECT", "FIELD_SOURCE_ORDER", "FIELD_STATEMENT_DESCRIPTOR", "FIELD_STATUS", "FIELD_TYPE", "FIELD_USAGE", "FIELD_WECHAT", "MODELED_TYPES", "", "VALUE_CARD", "VALUE_SOURCE", "asSourceType", "sourceType", "fromCardJson", "Lcom/stripe/android/model/Source;", "jsonObject", "Lorg/json/JSONObject;", "fromSourceJson", "optStripeJsonModel", "T", "Lcom/stripe/android/core/model/StripeModel;", "key", "(Lorg/json/JSONObject;Ljava/lang/String;)Lcom/stripe/android/core/model/StripeModel;", "payments-core_release"})
    @SourceDebugExtension(value={"SMAP\nSourceJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceJsonParser.kt\ncom/stripe/android/model/parsers/SourceJsonParser$Companion\n*L\n1#1,317:1\n252#1,41:318\n252#1,41:359\n252#1,41:400\n252#1,41:441\n252#1,41:482\n*S KotlinDebug\n*F\n+ 1 SourceJsonParser.kt\ncom/stripe/android/model/parsers/SourceJsonParser$Companion\n*L\n201#1:318,41\n210#1:359,41\n218#1:400,41\n219#1:441,41\n220#1:482,41\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Source fromCardJson(JSONObject jsonObject) {
            return new Source(StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_ID), null, null, null, null, null, null, null, null, null, null, null, null, new SourceCardDataJsonParser().parse(jsonObject), SourceJsonParser.VALUE_CARD, SourceJsonParser.VALUE_CARD, null, null, null, null, null, 0x1F1FFE, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Source fromSourceJson(JSONObject jsonObject) {
            Source.Klarna klarna;
            WeChat weChat;
            WeChat weChat2;
            SourceOrder sourceOrder;
            StripeModel stripeModel;
            Source.Receiver receiver;
            boolean bl;
            Source.Flow flow;
            String string2;
            Long l;
            Object object;
            String string3;
            Long l2;
            String string4;
            SourceTypeModel sourceTypeModel;
            Object object2;
            Map sourceTypeData;
            String type;
            String typeRaw;
            block199: {
                StripeModel model$iv;
                StripeModel stripeModel2;
                StripeModel stripeModel3;
                String key$iv;
                block198: {
                    StripeModel stripeModel4;
                    Object key$iv2;
                    block196: {
                        StripeModel model$iv2;
                        StripeModel stripeModel5;
                        StripeModel stripeModel6;
                        Object it$iv;
                        block195: {
                            StripeModel stripeModel7;
                            Object key$iv3;
                            block193: {
                                StripeModel model$iv3;
                                StripeModel stripeModel8;
                                StripeModel stripeModel9;
                                block192: {
                                    Object it$iv2;
                                    StripeModel stripeModel10;
                                    block190: {
                                        StripeModel model$iv4;
                                        StripeModel stripeModel11;
                                        StripeModel stripeModel12;
                                        void key$iv4;
                                        block189: {
                                            SourceTypeModel sourceTypeModel2;
                                            Companion it$iv3;
                                            block188: {
                                                block184: {
                                                    StripeModel stripeModel13;
                                                    block186: {
                                                        StripeModel model$iv5;
                                                        StripeModel stripeModel14;
                                                        StripeModel stripeModel15;
                                                        block185: {
                                                            String string5 = StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_TYPE);
                                                            if (string5 == null) {
                                                                string5 = "unknown";
                                                            }
                                                            typeRaw = string5;
                                                            type = this.asSourceType(typeRaw);
                                                            sourceTypeData = StripeJsonUtils.INSTANCE.jsonObjectToMap(jsonObject.optJSONObject(typeRaw));
                                                            if (!MODELED_TYPES.contains(typeRaw)) break block184;
                                                            Companion this_$iv = this;
                                                            boolean $i$f$optStripeJsonModel = false;
                                                            if (jsonObject.has(typeRaw)) break block185;
                                                            stripeModel13 = null;
                                                            break block186;
                                                        }
                                                        switch (typeRaw) {
                                                            case "code_verification": {
                                                                Source.CodeVerification codeVerification;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl2 = false;
                                                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    codeVerification = null;
                                                                }
                                                                stripeModel15 = codeVerification;
                                                                break;
                                                            }
                                                            case "owner": {
                                                                Source.Owner owner;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl3 = false;
                                                                    owner = new OwnerJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    owner = null;
                                                                }
                                                                stripeModel15 = owner;
                                                                break;
                                                            }
                                                            case "receiver": {
                                                                Source.Receiver receiver2;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl4 = false;
                                                                    receiver2 = new ReceiverJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    receiver2 = null;
                                                                }
                                                                stripeModel15 = receiver2;
                                                                break;
                                                            }
                                                            case "redirect": {
                                                                Source.Redirect redirect;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl5 = false;
                                                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    redirect = null;
                                                                }
                                                                stripeModel15 = redirect;
                                                                break;
                                                            }
                                                            case "card": {
                                                                SourceTypeModel.Card card;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl6 = false;
                                                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    card = null;
                                                                }
                                                                stripeModel15 = card;
                                                                break;
                                                            }
                                                            case "sepa_debit": {
                                                                SourceTypeModel.SepaDebit sepaDebit;
                                                                JSONObject jSONObject = object2 = jsonObject.optJSONObject("sepa_debit");
                                                                if (jSONObject != null) {
                                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                                    it$iv3 = object2;
                                                                    boolean bl7 = false;
                                                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv3);
                                                                } else {
                                                                    sepaDebit = null;
                                                                }
                                                                stripeModel15 = sepaDebit;
                                                                break;
                                                            }
                                                            default: {
                                                                stripeModel15 = null;
                                                            }
                                                        }
                                                        if (!((stripeModel14 = (model$iv5 = stripeModel15)) instanceof SourceTypeModel)) {
                                                            stripeModel14 = null;
                                                        }
                                                        stripeModel13 = (SourceTypeModel)stripeModel14;
                                                    }
                                                    sourceTypeModel2 = (SourceTypeModel)stripeModel13;
                                                    break block188;
                                                }
                                                sourceTypeModel2 = null;
                                            }
                                            sourceTypeModel = sourceTypeModel2;
                                            string4 = StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_ID);
                                            l2 = StripeJsonUtils.INSTANCE.optLong(jsonObject, SourceJsonParser.FIELD_AMOUNT);
                                            string3 = StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_CLIENT_SECRET);
                                            it$iv3 = this;
                                            String bl7 = SourceJsonParser.FIELD_CODE_VERIFICATION;
                                            boolean $i$f$optStripeJsonModel = false;
                                            if (jsonObject.has((String)key$iv4)) break block189;
                                            stripeModel10 = null;
                                            break block190;
                                        }
                                        switch (key$iv4) {
                                            case "code_verification": {
                                                Source.CodeVerification codeVerification;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl8 = false;
                                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    codeVerification = null;
                                                }
                                                stripeModel12 = codeVerification;
                                                break;
                                            }
                                            case "owner": {
                                                Source.Owner owner;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl9 = false;
                                                    owner = new OwnerJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    owner = null;
                                                }
                                                stripeModel12 = owner;
                                                break;
                                            }
                                            case "receiver": {
                                                Source.Receiver receiver3;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl10 = false;
                                                    receiver3 = new ReceiverJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    receiver3 = null;
                                                }
                                                stripeModel12 = receiver3;
                                                break;
                                            }
                                            case "redirect": {
                                                Source.Redirect redirect;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl11 = false;
                                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    redirect = null;
                                                }
                                                stripeModel12 = redirect;
                                                break;
                                            }
                                            case "card": {
                                                SourceTypeModel.Card card;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl12 = false;
                                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    card = null;
                                                }
                                                stripeModel12 = card;
                                                break;
                                            }
                                            case "sepa_debit": {
                                                SourceTypeModel.SepaDebit sepaDebit;
                                                JSONObject jSONObject = object = jsonObject.optJSONObject("sepa_debit");
                                                if (jSONObject != null) {
                                                    Intrinsics.checkNotNull((Object)jSONObject);
                                                    it$iv2 = object;
                                                    boolean bl13 = false;
                                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv2);
                                                } else {
                                                    sepaDebit = null;
                                                }
                                                stripeModel12 = sepaDebit;
                                                break;
                                            }
                                            default: {
                                                stripeModel12 = null;
                                            }
                                        }
                                        if (!((stripeModel11 = (model$iv4 = stripeModel12)) instanceof Source.CodeVerification)) {
                                            stripeModel11 = null;
                                        }
                                        stripeModel10 = (Source.CodeVerification)stripeModel11;
                                    }
                                    object2 = (Source.CodeVerification)stripeModel10;
                                    l = StripeJsonUtils.INSTANCE.optLong(jsonObject, SourceJsonParser.FIELD_CREATED);
                                    string2 = StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_CURRENCY);
                                    flow = Source.Flow.Companion.fromCode(StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_FLOW));
                                    bl = jsonObject.optBoolean(SourceJsonParser.FIELD_LIVEMODE);
                                    it$iv2 = this;
                                    key$iv3 = SourceJsonParser.FIELD_OWNER;
                                    boolean $i$f$optStripeJsonModel = false;
                                    if (jsonObject.has((String)key$iv3)) break block192;
                                    stripeModel7 = null;
                                    break block193;
                                }
                                switch (key$iv3) {
                                    case "code_verification": {
                                        Source.CodeVerification codeVerification;
                                        Object object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl14 = false;
                                            codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            codeVerification = null;
                                        }
                                        stripeModel9 = codeVerification;
                                        break;
                                    }
                                    case "owner": {
                                        Source.Owner owner;
                                        Object object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl15 = false;
                                            owner = new OwnerJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            owner = null;
                                        }
                                        stripeModel9 = owner;
                                        break;
                                    }
                                    case "receiver": {
                                        Source.Receiver receiver4;
                                        Object object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl16 = false;
                                            receiver4 = new ReceiverJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            receiver4 = null;
                                        }
                                        stripeModel9 = receiver4;
                                        break;
                                    }
                                    case "redirect": {
                                        Source.Redirect redirect;
                                        Object object3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl17 = false;
                                            redirect = new RedirectJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            redirect = null;
                                        }
                                        stripeModel9 = redirect;
                                        break;
                                    }
                                    case "card": {
                                        SourceTypeModel.Card card;
                                        Object object3 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl18 = false;
                                            card = new SourceCardDataJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            card = null;
                                        }
                                        stripeModel9 = card;
                                        break;
                                    }
                                    case "sepa_debit": {
                                        SourceTypeModel.SepaDebit sepaDebit;
                                        Object object3 = jsonObject.optJSONObject("sepa_debit");
                                        JSONObject jSONObject = object3;
                                        if (jSONObject != null) {
                                            Intrinsics.checkNotNull((Object)jSONObject);
                                            it$iv = object3;
                                            boolean bl19 = false;
                                            sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv);
                                        } else {
                                            sepaDebit = null;
                                        }
                                        stripeModel9 = sepaDebit;
                                        break;
                                    }
                                    default: {
                                        stripeModel9 = null;
                                    }
                                }
                                if (!((stripeModel8 = (model$iv3 = stripeModel9)) instanceof Source.Owner)) {
                                    stripeModel8 = null;
                                }
                                stripeModel7 = (Source.Owner)stripeModel8;
                            }
                            object = (Source.Owner)stripeModel7;
                            key$iv3 = this;
                            key$iv2 = SourceJsonParser.FIELD_RECEIVER;
                            boolean $i$f$optStripeJsonModel = false;
                            if (jsonObject.has((String)key$iv2)) break block195;
                            stripeModel4 = null;
                            break block196;
                        }
                        switch (key$iv2) {
                            case "code_verification": {
                                Source.CodeVerification codeVerification;
                                Object object4 = it$iv = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                                if (object4 != null) {
                                    Intrinsics.checkNotNull((Object)object4);
                                    Object it$iv4 = it$iv;
                                    boolean bl20 = false;
                                    codeVerification = new CodeVerificationJsonParser().parse((JSONObject)it$iv4);
                                } else {
                                    codeVerification = null;
                                }
                                stripeModel6 = codeVerification;
                                break;
                            }
                            case "owner": {
                                Source.Owner owner;
                                Object object5 = it$iv = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                                if (object5 != null) {
                                    Intrinsics.checkNotNull((Object)object5);
                                    Object it$iv5 = it$iv;
                                    boolean bl21 = false;
                                    owner = new OwnerJsonParser().parse((JSONObject)it$iv5);
                                } else {
                                    owner = null;
                                }
                                stripeModel6 = owner;
                                break;
                            }
                            case "receiver": {
                                Source.Receiver receiver5;
                                Object object6 = it$iv = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                                if (object6 != null) {
                                    Intrinsics.checkNotNull((Object)object6);
                                    Object it$iv6 = it$iv;
                                    boolean bl22 = false;
                                    receiver5 = new ReceiverJsonParser().parse((JSONObject)it$iv6);
                                } else {
                                    receiver5 = null;
                                }
                                stripeModel6 = receiver5;
                                break;
                            }
                            case "redirect": {
                                Source.Redirect redirect;
                                Object object7 = it$iv = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                                if (object7 != null) {
                                    Intrinsics.checkNotNull((Object)object7);
                                    Object it$iv7 = it$iv;
                                    boolean bl23 = false;
                                    redirect = new RedirectJsonParser().parse((JSONObject)it$iv7);
                                } else {
                                    redirect = null;
                                }
                                stripeModel6 = redirect;
                                break;
                            }
                            case "card": {
                                SourceTypeModel.Card card;
                                Object object8 = it$iv = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                                if (object8 != null) {
                                    Intrinsics.checkNotNull((Object)object8);
                                    Object it$iv8 = it$iv;
                                    boolean bl24 = false;
                                    card = new SourceCardDataJsonParser().parse((JSONObject)it$iv8);
                                } else {
                                    card = null;
                                }
                                stripeModel6 = card;
                                break;
                            }
                            case "sepa_debit": {
                                SourceTypeModel.SepaDebit sepaDebit;
                                Object object9 = it$iv = jsonObject.optJSONObject("sepa_debit");
                                if (object9 != null) {
                                    Intrinsics.checkNotNull((Object)object9);
                                    Object it$iv9 = it$iv;
                                    boolean bl25 = false;
                                    sepaDebit = new SourceSepaDebitDataJsonParser().parse((JSONObject)it$iv9);
                                } else {
                                    sepaDebit = null;
                                }
                                stripeModel6 = sepaDebit;
                                break;
                            }
                            default: {
                                stripeModel6 = null;
                            }
                        }
                        if (!((stripeModel5 = (model$iv2 = stripeModel6)) instanceof Source.Receiver)) {
                            stripeModel5 = null;
                        }
                        stripeModel4 = (Source.Receiver)stripeModel5;
                    }
                    receiver = (Source.Receiver)stripeModel4;
                    key$iv2 = this;
                    key$iv = SourceJsonParser.FIELD_REDIRECT;
                    boolean $i$f$optStripeJsonModel = false;
                    if (jsonObject.has(key$iv)) break block198;
                    stripeModel = null;
                    break block199;
                }
                switch (key$iv) {
                    case "code_verification": {
                        Source.CodeVerification codeVerification;
                        JSONObject it$iv;
                        JSONObject it$iv9;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl26 = false;
                            codeVerification = new CodeVerificationJsonParser().parse(it$iv);
                        } else {
                            codeVerification = null;
                        }
                        stripeModel3 = codeVerification;
                        break;
                    }
                    case "owner": {
                        Source.Owner owner;
                        JSONObject it$iv9;
                        JSONObject it$iv;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl27 = false;
                            owner = new OwnerJsonParser().parse(it$iv);
                        } else {
                            owner = null;
                        }
                        stripeModel3 = owner;
                        break;
                    }
                    case "receiver": {
                        Source.Receiver receiver6;
                        JSONObject it$iv9;
                        JSONObject it$iv;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl28 = false;
                            receiver6 = new ReceiverJsonParser().parse(it$iv);
                        } else {
                            receiver6 = null;
                        }
                        stripeModel3 = receiver6;
                        break;
                    }
                    case "redirect": {
                        Source.Redirect redirect;
                        JSONObject it$iv9;
                        JSONObject it$iv;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl29 = false;
                            redirect = new RedirectJsonParser().parse(it$iv);
                        } else {
                            redirect = null;
                        }
                        stripeModel3 = redirect;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject it$iv9;
                        JSONObject it$iv;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl30 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel3 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject it$iv9;
                        JSONObject it$iv;
                        JSONObject jSONObject = it$iv9 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject != null) {
                            Intrinsics.checkNotNull((Object)jSONObject);
                            it$iv = it$iv9;
                            boolean bl31 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel3 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel3 = null;
                    }
                }
                if (!((stripeModel2 = (model$iv = stripeModel3)) instanceof Source.Redirect)) {
                    stripeModel2 = null;
                }
                stripeModel = (Source.Redirect)stripeModel2;
            }
            Source.Redirect redirect = (Source.Redirect)stripeModel;
            JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_SOURCE_ORDER);
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl32 = false;
                sourceOrder = new SourceOrderJsonParser().parse(it);
            } else {
                sourceOrder = null;
            }
            SourceOrder sourceOrder2 = sourceOrder;
            String string6 = StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_STATEMENT_DESCRIPTOR);
            Source.Status status = Source.Status.Companion.fromCode(StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_STATUS));
            Source.Usage usage = Source.Usage.Companion.fromCode(StripeJsonUtils.optString((JSONObject)jsonObject, (String)SourceJsonParser.FIELD_USAGE));
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_WECHAT, (Object)type)) {
                WeChatJsonParser weChatJsonParser = new WeChatJsonParser();
                JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_WECHAT);
                if (jSONObject2 == null) {
                    jSONObject2 = new JSONObject();
                }
                weChat2 = weChatJsonParser.parse(jSONObject2);
            } else {
                weChat2 = weChat = null;
            }
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_KLARNA, (Object)type)) {
                KlarnaJsonParser klarnaJsonParser = new KlarnaJsonParser();
                JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_KLARNA);
                if (jSONObject3 == null) {
                    jSONObject3 = new JSONObject();
                }
                klarna = klarnaJsonParser.parse(jSONObject3);
            } else {
                klarna = null;
            }
            Source.Klarna klarna2 = klarna;
            return new Source(string4, l2, string3, (Source.CodeVerification)object2, l, string2, flow, bl, (Source.Owner)object, receiver, redirect, status, sourceTypeData, sourceTypeModel, type, typeRaw, usage, weChat, klarna2, sourceOrder2, string6);
        }

        private final /* synthetic */ <T extends StripeModel> T optStripeJsonModel(JSONObject jsonObject, @Size(min=1L) String key) {
            StripeModel stripeModel;
            boolean $i$f$optStripeJsonModel = false;
            if (!jsonObject.has(key)) {
                return null;
            }
            switch (key) {
                case "code_verification": {
                    Source.CodeVerification codeVerification;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        codeVerification = new CodeVerificationJsonParser().parse(it);
                    } else {
                        codeVerification = null;
                    }
                    stripeModel = codeVerification;
                    break;
                }
                case "owner": {
                    Source.Owner owner;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        owner = new OwnerJsonParser().parse(it);
                    } else {
                        owner = null;
                    }
                    stripeModel = owner;
                    break;
                }
                case "receiver": {
                    Source.Receiver receiver;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        receiver = new ReceiverJsonParser().parse(it);
                    } else {
                        receiver = null;
                    }
                    stripeModel = receiver;
                    break;
                }
                case "redirect": {
                    Source.Redirect redirect;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        redirect = new RedirectJsonParser().parse(it);
                    } else {
                        redirect = null;
                    }
                    stripeModel = redirect;
                    break;
                }
                case "card": {
                    SourceTypeModel.Card card;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        card = new SourceCardDataJsonParser().parse(it);
                    } else {
                        card = null;
                    }
                    stripeModel = card;
                    break;
                }
                case "sepa_debit": {
                    SourceTypeModel.SepaDebit sepaDebit;
                    JSONObject it;
                    JSONObject jSONObject = jsonObject.optJSONObject("sepa_debit");
                    if (jSONObject != null) {
                        it = jSONObject;
                        boolean bl = false;
                        sepaDebit = new SourceSepaDebitDataJsonParser().parse(it);
                    } else {
                        sepaDebit = null;
                    }
                    stripeModel = sepaDebit;
                    break;
                }
                default: {
                    stripeModel = null;
                }
            }
            StripeModel model = stripeModel;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)model;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceType(String sourceType) {
            String string2 = sourceType;
            if (string2 == null) return "unknown";
            int n = -1;
            switch (string2.hashCode()) {
                case 38358441: {
                    if (string2.equals("giropay")) {
                        n = 1;
                    }
                    break;
                }
                case 100048981: {
                    if (string2.equals("ideal")) {
                        n = 2;
                    }
                    break;
                }
                case -1414960566: {
                    if (string2.equals("alipay")) {
                        n = 3;
                    }
                    break;
                }
                case -791770330: {
                    if (string2.equals(SourceJsonParser.FIELD_WECHAT)) {
                        n = 4;
                    }
                    break;
                }
                case 100648: {
                    if (string2.equals("eps")) {
                        n = 5;
                    }
                    break;
                }
                case -896955097: {
                    if (string2.equals("sofort")) {
                        n = 6;
                    }
                    break;
                }
                case -284840886: {
                    if (string2.equals("unknown")) {
                        n = 7;
                    }
                    break;
                }
                case -1920743119: {
                    if (string2.equals("bancontact")) {
                        n = 8;
                    }
                    break;
                }
                case 109234: {
                    if (string2.equals("p24")) {
                        n = 9;
                    }
                    break;
                }
                case -1128905083: {
                    if (string2.equals(SourceJsonParser.FIELD_KLARNA)) {
                        n = 10;
                    }
                    break;
                }
                case 1636477296: {
                    if (string2.equals("sepa_debit")) {
                        n = 11;
                    }
                    break;
                }
                case -825238221: {
                    if (string2.equals("three_d_secure")) {
                        n = 12;
                    }
                    break;
                }
                case 3046160: {
                    if (string2.equals(SourceJsonParser.VALUE_CARD)) {
                        n = 13;
                    }
                    break;
                }
                case 1251821346: {
                    if (string2.equals("multibanco")) {
                        n = 14;
                    }
                    break;
                }
            }
            switch (n) {
                case 13: {
                    return SourceJsonParser.VALUE_CARD;
                }
                case 12: {
                    return "three_d_secure";
                }
                case 1: {
                    return "giropay";
                }
                case 11: {
                    return "sepa_debit";
                }
                case 2: {
                    return "ideal";
                }
                case 6: {
                    return "sofort";
                }
                case 8: {
                    return "bancontact";
                }
                case 3: {
                    return "alipay";
                }
                case 5: {
                    return "eps";
                }
                case 9: {
                    return "p24";
                }
                case 14: {
                    return "multibanco";
                }
                case 4: {
                    return SourceJsonParser.FIELD_WECHAT;
                }
                case 7: {
                    return "unknown";
                }
                case 10: {
                    return SourceJsonParser.FIELD_KLARNA;
                }
                default: {
                    return "unknown";
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Klarna;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseSet", "", "", "key", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class KlarnaJsonParser
    implements ModelJsonParser<Source.Klarna> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_FIRST_NAME = "first_name";
        @NotNull
        private static final String FIELD_LAST_NAME = "last_name";
        @NotNull
        private static final String FIELD_PURCHASE_COUNTRY = "purchase_country";
        @NotNull
        private static final String FIELD_CLIENT_TOKEN = "client_token";
        @NotNull
        private static final String FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE = "pay_later_asset_urls_descriptive";
        @NotNull
        private static final String FIELD_PAY_LATER_ASSET_URLS_STANDARD = "pay_later_asset_urls_standard";
        @NotNull
        private static final String FIELD_PAY_LATER_NAME = "pay_later_name";
        @NotNull
        private static final String FIELD_PAY_LATER_REDIRECT_URL = "pay_later_redirect_url";
        @NotNull
        private static final String FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE = "pay_now_asset_urls_descriptive";
        @NotNull
        private static final String FIELD_PAY_NOW_ASSET_URLS_STANDARD = "pay_now_asset_urls_standard";
        @NotNull
        private static final String FIELD_PAY_NOW_NAME = "pay_now_name";
        @NotNull
        private static final String FIELD_PAY_NOW_REDIRECT_URL = "pay_now_redirect_url";
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE = "pay_over_time_asset_urls_descriptive";
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD = "pay_over_time_asset_urls_standard";
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_NAME = "pay_over_time_name";
        @NotNull
        private static final String FIELD_PAY_OVER_TIME_REDIRECT_URL = "pay_over_time_redirect_url";
        @NotNull
        private static final String FIELD_PAYMENT_METHOD_CATEGORIES = "payment_method_categories";
        @NotNull
        private static final String FIELD_CUSTOM_PAYMENT_METHODS = "custom_payment_methods";

        @NotNull
        public Source.Klarna parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FIRST_NAME);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST_NAME);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PURCHASE_COUNTRY);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CLIENT_TOKEN);
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE);
            String string7 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_LATER_ASSET_URLS_STANDARD);
            String string8 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_LATER_NAME);
            String string9 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_LATER_REDIRECT_URL);
            String string10 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE);
            String string11 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_NOW_ASSET_URLS_STANDARD);
            String string12 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_NOW_NAME);
            String string13 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_NOW_REDIRECT_URL);
            String string14 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE);
            String string15 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD);
            String string16 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_OVER_TIME_NAME);
            String string17 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAY_OVER_TIME_REDIRECT_URL);
            Set<String> set = this.parseSet(json, FIELD_PAYMENT_METHOD_CATEGORIES);
            Set<String> set2 = this.parseSet(json, FIELD_CUSTOM_PAYMENT_METHODS);
            return new Source.Klarna(string2, string3, string4, string5, string10, string11, string12, string13, string6, string7, string8, string9, string14, string15, string16, string17, set, set2);
        }

        private final Set<String> parseSet(JSONObject json, String key) {
            Set set;
            String[] stringArray;
            Object object = StripeJsonUtils.optString((JSONObject)json, (String)key);
            if ((object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : (set = null)) == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$KlarnaJsonParser$Companion;", "", "()V", "FIELD_CLIENT_TOKEN", "", "FIELD_CUSTOM_PAYMENT_METHODS", "FIELD_FIRST_NAME", "FIELD_LAST_NAME", "FIELD_PAYMENT_METHOD_CATEGORIES", "FIELD_PAY_LATER_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_LATER_ASSET_URLS_STANDARD", "FIELD_PAY_LATER_NAME", "FIELD_PAY_LATER_REDIRECT_URL", "FIELD_PAY_NOW_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_NOW_ASSET_URLS_STANDARD", "FIELD_PAY_NOW_NAME", "FIELD_PAY_NOW_REDIRECT_URL", "FIELD_PAY_OVER_TIME_ASSET_URLS_DESCRIPTIVE", "FIELD_PAY_OVER_TIME_ASSET_URLS_STANDARD", "FIELD_PAY_OVER_TIME_NAME", "FIELD_PAY_OVER_TIME_REDIRECT_URL", "FIELD_PURCHASE_COUNTRY", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Owner;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class OwnerJsonParser
    implements ModelJsonParser<Source.Owner> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @NotNull
        private static final String FIELD_EMAIL = "email";
        @NotNull
        private static final String FIELD_NAME = "name";
        @NotNull
        private static final String FIELD_PHONE = "phone";
        @NotNull
        private static final String FIELD_VERIFIED_ADDRESS = "verified_address";
        @NotNull
        private static final String FIELD_VERIFIED_EMAIL = "verified_email";
        @NotNull
        private static final String FIELD_VERIFIED_NAME = "verified_name";
        @NotNull
        private static final String FIELD_VERIFIED_PHONE = "verified_phone";

        @NotNull
        public Source.Owner parse(@NotNull JSONObject json) {
            Address address;
            Address address2;
            JSONObject it;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject != null) {
                it = jSONObject;
                boolean bl = false;
                address2 = new AddressJsonParser().parse(it);
            } else {
                address2 = null;
            }
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PHONE);
            JSONObject jSONObject2 = json.optJSONObject(FIELD_VERIFIED_ADDRESS);
            if (jSONObject2 != null) {
                it = jSONObject2;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                Address address3 = address2;
                boolean bl = false;
                Address address4 = new AddressJsonParser().parse(it);
                address2 = address3;
                string2 = string7;
                string3 = string6;
                string4 = string5;
                address = address4;
            } else {
                address = null;
            }
            String string8 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_VERIFIED_PHONE);
            String string9 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_VERIFIED_NAME);
            String string10 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_VERIFIED_EMAIL);
            Address address5 = address;
            String string11 = string4;
            String string12 = string3;
            String string13 = string2;
            Address address6 = address2;
            return new Source.Owner(address6, string13, string12, string11, address5, string10, string9, string8);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$OwnerJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "FIELD_VERIFIED_ADDRESS", "FIELD_VERIFIED_EMAIL", "FIELD_VERIFIED_NAME", "FIELD_VERIFIED_PHONE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Receiver;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class ReceiverJsonParser
    implements ModelJsonParser<Source.Receiver> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @NotNull
        private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
        @NotNull
        private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
        @NotNull
        private static final String FIELD_AMOUNT_RETURNED = "amount_returned";

        @NotNull
        public Source.Receiver parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Receiver(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ADDRESS), json.optLong(FIELD_AMOUNT_CHARGED), json.optLong(FIELD_AMOUNT_RECEIVED), json.optLong(FIELD_AMOUNT_RETURNED));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$ReceiverJsonParser$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_AMOUNT_CHARGED", "FIELD_AMOUNT_RECEIVED", "FIELD_AMOUNT_RETURNED", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source$Redirect;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class RedirectJsonParser
    implements ModelJsonParser<Source.Redirect> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_RETURN_URL = "return_url";
        @NotNull
        private static final String FIELD_STATUS = "status";
        @NotNull
        private static final String FIELD_URL = "url";

        @NotNull
        public Source.Redirect parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new Source.Redirect(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_RETURN_URL), Source.Redirect.Status.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)"status")), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_URL));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$RedirectJsonParser$Companion;", "", "()V", "FIELD_RETURN_URL", "", "FIELD_STATUS", "FIELD_URL", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

