/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.cards;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeSource;
import com.stripe.android.cards.CardAccountRangeStore;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepository;
import com.stripe.android.cards.InMemoryCardAccountRangeSource;
import com.stripe.android.cards.InMemoryCardAccountRangeStore;
import com.stripe.android.cards.RemoteCardAccountRangeSource;
import com.stripe.android.cards.StaticCardAccountRangeSource;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory;", "Lcom/stripe/android/cards/CardAccountRangeRepository$Factory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "(Landroid/content/Context;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;)V", "appContext", "kotlin.jvm.PlatformType", "cardAccountRangeRepository", "Lkotlin/Lazy;", "Lcom/stripe/android/cards/DefaultCardAccountRangeRepository;", "create", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "createRemoteCardAccountRangeSource", "Lcom/stripe/android/cards/CardAccountRangeSource;", "store", "Lcom/stripe/android/cards/CardAccountRangeStore;", "createWithStripeRepository", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "publishableKey", "", "fireAnalyticsEvent", "", "event", "Lcom/stripe/android/networking/PaymentAnalyticsEvent;", "NullCardAccountRangeSource", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class DefaultCardAccountRangeRepositoryFactory
implements CardAccountRangeRepository.Factory {
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final Context appContext;
    @NotNull
    private final Lazy<DefaultCardAccountRangeRepository> cardAccountRangeRepository;
    public static final int $stable = 8;

    @Inject
    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.appContext = context.getApplicationContext();
        this.cardAccountRangeRepository = LazyKt.lazy((Function0)((Function0)new Function0<DefaultCardAccountRangeRepository>(this){
            final /* synthetic */ DefaultCardAccountRangeRepositoryFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultCardAccountRangeRepository invoke() {
                InMemoryCardAccountRangeStore store = new InMemoryCardAccountRangeStore();
                return new DefaultCardAccountRangeRepository(new InMemoryCardAccountRangeSource(store), DefaultCardAccountRangeRepositoryFactory.access$createRemoteCardAccountRangeSource(this.this$0, store), new StaticCardAccountRangeSource(null, 1, null), store);
            }
        }));
    }

    public DefaultCardAccountRangeRepositoryFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor());
    }

    @Override
    @NotNull
    public CardAccountRangeRepository create() throws IllegalStateException {
        return (CardAccountRangeRepository)this.cardAccountRangeRepository.getValue();
    }

    @Override
    @NotNull
    public CardAccountRangeRepository createWithStripeRepository(@NotNull StripeRepository stripeRepository2, @NotNull String publishableKey) {
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
        InMemoryCardAccountRangeStore store = new InMemoryCardAccountRangeStore();
        CardAccountRangeSource cardAccountRangeSource = new InMemoryCardAccountRangeSource(store);
        ApiRequest.Options options = new ApiRequest.Options(publishableKey, null, null, 6, null);
        CardAccountRangeStore cardAccountRangeStore = store;
        AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        return new DefaultCardAccountRangeRepository(cardAccountRangeSource, new RemoteCardAccountRangeSource(stripeRepository2, options, cardAccountRangeStore, analyticsRequestExecutor, new PaymentAnalyticsRequestFactory(context, publishableKey, null, 4, null)), new StaticCardAccountRangeSource(null, 1, null), store);
    }

    private final CardAccountRangeSource createRemoteCardAccountRangeSource(CardAccountRangeStore store) {
        CardAccountRangeSource cardAccountRangeSource;
        Object publishableKey;
        Object $this$createRemoteCardAccountRangeSource_u24lambda_u240;
        Object object = this;
        try {
            $this$createRemoteCardAccountRangeSource_u24lambda_u240 = object;
            boolean bl = false;
            Context context = ((DefaultCardAccountRangeRepositoryFactory)$this$createRemoteCardAccountRangeSource_u24lambda_u240).appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            $this$createRemoteCardAccountRangeSource_u24lambda_u240 = Result.constructor-impl((Object)PaymentConfiguration.Companion.getInstance(context).getPublishableKey());
        }
        catch (Throwable bl) {
            $this$createRemoteCardAccountRangeSource_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createRemoteCardAccountRangeSource_u24lambda_u240;
        if (Result.isSuccess-impl((Object)object)) {
            publishableKey = (String)object;
            boolean bl = false;
            this.fireAnalyticsEvent((String)publishableKey, PaymentAnalyticsEvent.CardMetadataPublishableKeyAvailable);
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = publishableKey = throwable;
            boolean bl = false;
            this.fireAnalyticsEvent("pk_undefined", PaymentAnalyticsEvent.CardMetadataPublishableKeyUnavailable);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 == null) {
            publishableKey = (String)object;
            boolean bl = false;
            Context context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            StripeRepository stripeRepository2 = new StripeApiRepository(context, (Function0)new Function0<String>((String)publishableKey){
                final /* synthetic */ String $publishableKey;
                {
                    this.$publishableKey = $publishableKey;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$publishableKey;
                }
            }, null, null, null, null, null, null, null, null, null, null, null, null, null, 32764, null);
            ApiRequest.Options options = new ApiRequest.Options((String)publishableKey, null, null, 6, null);
            AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
            Context context2 = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"appContext");
            cardAccountRangeSource = new RemoteCardAccountRangeSource(stripeRepository2, options, store, analyticsRequestExecutor, new PaymentAnalyticsRequestFactory(context2, (String)publishableKey, null, 4, null));
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            cardAccountRangeSource = new NullCardAccountRangeSource();
        }
        return cardAccountRangeSource;
    }

    private final void fireAnalyticsEvent(String publishableKey, PaymentAnalyticsEvent event) {
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(new PaymentAnalyticsRequestFactory(context, publishableKey, null, 4, null), event, null, null, null, null, null, 62, null));
    }

    public static final /* synthetic */ CardAccountRangeSource access$createRemoteCardAccountRangeSource(DefaultCardAccountRangeRepositoryFactory $this, CardAccountRangeStore store) {
        return $this.createRemoteCardAccountRangeSource(store);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory$NullCardAccountRangeSource;", "Lcom/stripe/android/cards/CardAccountRangeSource;", "()V", "loading", "Lkotlinx/coroutines/flow/StateFlow;", "", "getLoading", "()Lkotlinx/coroutines/flow/StateFlow;", "getAccountRanges", "", "Lcom/stripe/android/model/AccountRange;", "cardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "(Lcom/stripe/android/cards/CardNumber$Unvalidated;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "payments-core_release"})
    private static final class NullCardAccountRangeSource
    implements CardAccountRangeSource {
        @NotNull
        private final StateFlow<Boolean> loading = StateFlowsKt.stateFlowOf((Object)false);

        @Override
        @Nullable
        public Object getAccountRanges(@NotNull CardNumber.Unvalidated cardNumber, @NotNull Continuation<? super List<AccountRange>> $completion) {
            return null;
        }

        @Override
        @NotNull
        public StateFlow<Boolean> getLoading() {
            return this.loading;
        }

        @Override
        @Nullable
        public Object getAccountRange(@NotNull CardNumber.Unvalidated cardNumber, @NotNull Continuation<? super AccountRange> $completion) {
            return CardAccountRangeSource.DefaultImpls.getAccountRange(this, cardNumber, $completion);
        }
    }
}

