/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.task;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RestrictTo;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.task.OnFailureListener;
import com.stripe.hcaptcha.task.OnOpenListener;
import com.stripe.hcaptcha.task.OnSuccessListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0004J\b\u0010\u001c\u001a\u00020\u0018H\u0004J\u0017\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0004\u00a2\u0006\u0004\b \u0010!J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010&\u001a\u00020\u0010J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010&\u001a\u00020\u0010J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010)\u001a\u00020\u0012J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010)\u001a\u00020\u0012J\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010,\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/stripe/hcaptcha/task/Task;", "TResult", "", "<init>", "()V", "isComplete", "", "isSuccessful", "result", "Ljava/lang/Object;", "exception", "Lcom/stripe/hcaptcha/HCaptchaException;", "onSuccessListeners", "", "Lcom/stripe/hcaptcha/task/OnSuccessListener;", "onFailureListeners", "Lcom/stripe/hcaptcha/task/OnFailureListener;", "onOpenListeners", "Lcom/stripe/hcaptcha/task/OnOpenListener;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "reset", "", "setResult", "(Ljava/lang/Object;)V", "setException", "captchaOpened", "scheduleCaptchaExpired", "tokenExpiration", "Lkotlin/time/Duration;", "scheduleCaptchaExpired-LRDsOJo", "(J)V", "addOnSuccessListener", "onSuccessListener", "removeOnSuccessListener", "addOnFailureListener", "onFailureListener", "removeOnFailureListener", "addOnOpenListener", "onOpenListener", "removeOnOpenListener", "removeAllListeners", "tryCallbacks", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Task.kt\ncom/stripe/hcaptcha/task/Task\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1863#2,2:203\n1863#2,2:205\n1863#2,2:207\n*S KotlinDebug\n*F\n+ 1 Task.kt\ncom/stripe/hcaptcha/task/Task\n*L\n86#1:203,2\n184#1:205,2\n191#1:207,2\n*E\n"})
public class Task<TResult> {
    private boolean isComplete;
    private boolean isSuccessful;
    @Nullable
    private TResult result;
    @Nullable
    private HCaptchaException exception;
    @NotNull
    private final List<OnSuccessListener<TResult>> onSuccessListeners;
    @NotNull
    private final List<OnFailureListener> onFailureListeners;
    @NotNull
    private final List<OnOpenListener> onOpenListeners;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());

    protected Task() {
        this.onSuccessListeners = new ArrayList();
        this.onFailureListeners = new ArrayList();
        this.onOpenListeners = new ArrayList();
        this.reset();
    }

    @NotNull
    protected final Handler getHandler() {
        return this.handler;
    }

    private final void reset() {
        this.isComplete = false;
        this.isSuccessful = false;
        this.result = null;
        this.exception = null;
    }

    protected final void setResult(TResult result) {
        this.result = result;
        this.isSuccessful = true;
        this.isComplete = true;
        this.tryCallbacks();
    }

    protected final void setException(@NotNull HCaptchaException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.exception = exception;
        this.isSuccessful = false;
        this.isComplete = true;
        this.tryCallbacks();
    }

    protected final void captchaOpened() {
        Iterable $this$forEach$iv = this.onOpenListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnOpenListener it = (OnOpenListener)element$iv;
            boolean bl = false;
            it.onOpen();
        }
    }

    protected final void scheduleCaptchaExpired-LRDsOJo(long tokenExpiration) {
        this.handler.postDelayed(() -> Task.scheduleCaptchaExpired_LRDsOJo$lambda$1(this), Duration.getInWholeMilliseconds-impl((long)tokenExpiration));
    }

    @NotNull
    public final Task<TResult> addOnSuccessListener(@NotNull OnSuccessListener<TResult> onSuccessListener) {
        Intrinsics.checkNotNullParameter(onSuccessListener, (String)"onSuccessListener");
        this.onSuccessListeners.add(onSuccessListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnSuccessListener(@NotNull OnSuccessListener<TResult> onSuccessListener) {
        Intrinsics.checkNotNullParameter(onSuccessListener, (String)"onSuccessListener");
        this.onSuccessListeners.remove(onSuccessListener);
        return this;
    }

    @NotNull
    public final Task<TResult> addOnFailureListener(@NotNull OnFailureListener onFailureListener) {
        Intrinsics.checkNotNullParameter((Object)onFailureListener, (String)"onFailureListener");
        this.onFailureListeners.add(onFailureListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnFailureListener(@NotNull OnFailureListener onFailureListener) {
        Intrinsics.checkNotNullParameter((Object)onFailureListener, (String)"onFailureListener");
        this.onFailureListeners.remove(onFailureListener);
        return this;
    }

    @NotNull
    public final Task<TResult> addOnOpenListener(@NotNull OnOpenListener onOpenListener) {
        Intrinsics.checkNotNullParameter((Object)onOpenListener, (String)"onOpenListener");
        this.onOpenListeners.add(onOpenListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnOpenListener(@NotNull OnOpenListener onOpenListener) {
        Intrinsics.checkNotNullParameter((Object)onOpenListener, (String)"onOpenListener");
        this.onOpenListeners.remove(onOpenListener);
        return this;
    }

    @NotNull
    public final Task<TResult> removeAllListeners() {
        this.onSuccessListeners.clear();
        this.onFailureListeners.clear();
        this.onOpenListeners.clear();
        return this;
    }

    private final void tryCallbacks() {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object e;
        boolean shouldReset = false;
        TResult TResult = this.result;
        if (TResult != null) {
            e = TResult;
            boolean bl = false;
            $this$forEach$iv = this.onSuccessListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OnSuccessListener)element$iv;
                boolean bl2 = false;
                it.onSuccess(e);
                shouldReset = true;
            }
        }
        HCaptchaException hCaptchaException = this.exception;
        if (hCaptchaException != null) {
            e = hCaptchaException;
            boolean bl = false;
            $this$forEach$iv = this.onFailureListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OnFailureListener)element$iv;
                boolean bl3 = false;
                it.onFailure((HCaptchaException)e);
                shouldReset = true;
            }
        }
        if (shouldReset) {
            this.reset();
        }
    }

    private static final void scheduleCaptchaExpired_LRDsOJo$lambda$1(Task this$0) {
        for (OnFailureListener listener : this$0.onFailureListeners) {
            listener.onFailure(new HCaptchaException(HCaptchaError.TOKEN_TIMEOUT, null, 2, null));
        }
    }
}

