/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.task;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RestrictTo;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.task.OnFailureListener;
import com.stripe.hcaptcha.task.OnOpenListener;
import com.stripe.hcaptcha.task.OnSuccessListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u000fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u0011J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\b\u0010\u001c\u001a\u00020\u001dH\u0004J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u000fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u0011J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\b\u0010\"\u001a\u00020\u001dH\u0002J\u001a\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0004J\u0015\u0010)\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u001dH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"Lcom/stripe/hcaptcha/task/Task;", "TResult", "", "()V", "exception", "Lcom/stripe/hcaptcha/HCaptchaException;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "isComplete", "", "isSuccessful", "onFailureListeners", "", "Lcom/stripe/hcaptcha/task/OnFailureListener;", "onOpenListeners", "Lcom/stripe/hcaptcha/task/OnOpenListener;", "onSuccessListeners", "Lcom/stripe/hcaptcha/task/OnSuccessListener;", "result", "Ljava/lang/Object;", "addOnFailureListener", "onFailureListener", "addOnOpenListener", "onOpenListener", "addOnSuccessListener", "onSuccessListener", "captchaOpened", "", "removeAllListeners", "removeOnFailureListener", "removeOnOpenListener", "removeOnSuccessListener", "reset", "scheduleCaptchaExpired", "tokenExpiration", "Lkotlin/time/Duration;", "scheduleCaptchaExpired-LRDsOJo", "(J)V", "setException", "setResult", "(Ljava/lang/Object;)V", "tryCallbacks", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Task.kt\ncom/stripe/hcaptcha/task/Task\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1855#2,2:203\n1855#2,2:205\n1855#2,2:207\n*S KotlinDebug\n*F\n+ 1 Task.kt\ncom/stripe/hcaptcha/task/Task\n*L\n86#1:203,2\n184#1:205,2\n191#1:207,2\n*E\n"})
public class Task<TResult> {
    private boolean isComplete;
    private boolean isSuccessful;
    @Nullable
    private TResult result;
    @Nullable
    private HCaptchaException exception;
    @NotNull
    private final List<OnSuccessListener<TResult>> onSuccessListeners;
    @NotNull
    private final List<OnFailureListener> onFailureListeners;
    @NotNull
    private final List<OnOpenListener> onOpenListeners;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());

    protected Task() {
        this.onSuccessListeners = new ArrayList();
        this.onFailureListeners = new ArrayList();
        this.onOpenListeners = new ArrayList();
        this.reset();
    }

    @NotNull
    protected final Handler getHandler() {
        return this.handler;
    }

    private final void reset() {
        this.isComplete = false;
        this.isSuccessful = false;
        this.result = null;
        this.exception = null;
    }

    protected final void setResult(TResult result) {
        this.result = result;
        this.isSuccessful = true;
        this.isComplete = true;
        this.tryCallbacks();
    }

    protected final void setException(@NotNull HCaptchaException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.exception = exception;
        this.isSuccessful = false;
        this.isComplete = true;
        this.tryCallbacks();
    }

    protected final void captchaOpened() {
        Iterable $this$forEach$iv = this.onOpenListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnOpenListener it = (OnOpenListener)element$iv;
            boolean bl = false;
            it.onOpen();
        }
    }

    protected final void scheduleCaptchaExpired-LRDsOJo(long tokenExpiration) {
        this.handler.postDelayed(() -> Task.scheduleCaptchaExpired_LRDsOJo$lambda$1(this), Duration.getInWholeMilliseconds-impl((long)tokenExpiration));
    }

    @NotNull
    public final Task<TResult> addOnSuccessListener(@NotNull OnSuccessListener<TResult> onSuccessListener) {
        Intrinsics.checkNotNullParameter(onSuccessListener, (String)"onSuccessListener");
        this.onSuccessListeners.add(onSuccessListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnSuccessListener(@NotNull OnSuccessListener<TResult> onSuccessListener) {
        Intrinsics.checkNotNullParameter(onSuccessListener, (String)"onSuccessListener");
        this.onSuccessListeners.remove(onSuccessListener);
        return this;
    }

    @NotNull
    public final Task<TResult> addOnFailureListener(@NotNull OnFailureListener onFailureListener) {
        Intrinsics.checkNotNullParameter((Object)onFailureListener, (String)"onFailureListener");
        this.onFailureListeners.add(onFailureListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnFailureListener(@NotNull OnFailureListener onFailureListener) {
        Intrinsics.checkNotNullParameter((Object)onFailureListener, (String)"onFailureListener");
        this.onFailureListeners.remove(onFailureListener);
        return this;
    }

    @NotNull
    public final Task<TResult> addOnOpenListener(@NotNull OnOpenListener onOpenListener) {
        Intrinsics.checkNotNullParameter((Object)onOpenListener, (String)"onOpenListener");
        this.onOpenListeners.add(onOpenListener);
        this.tryCallbacks();
        return this;
    }

    @NotNull
    public final Task<TResult> removeOnOpenListener(@NotNull OnOpenListener onOpenListener) {
        Intrinsics.checkNotNullParameter((Object)onOpenListener, (String)"onOpenListener");
        this.onOpenListeners.remove(onOpenListener);
        return this;
    }

    @NotNull
    public final Task<TResult> removeAllListeners() {
        this.onSuccessListeners.clear();
        this.onFailureListeners.clear();
        this.onOpenListeners.clear();
        return this;
    }

    private final void tryCallbacks() {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object e;
        boolean shouldReset = false;
        TResult TResult = this.result;
        if (TResult != null) {
            e = TResult;
            boolean bl = false;
            $this$forEach$iv = this.onSuccessListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OnSuccessListener)element$iv;
                boolean bl2 = false;
                it.onSuccess(e);
                shouldReset = true;
            }
        }
        HCaptchaException hCaptchaException = this.exception;
        if (hCaptchaException != null) {
            e = hCaptchaException;
            boolean bl = false;
            $this$forEach$iv = this.onFailureListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OnFailureListener)element$iv;
                boolean bl3 = false;
                it.onFailure((HCaptchaException)e);
                shouldReset = true;
            }
        }
        if (shouldReset) {
            this.reset();
        }
    }

    private static final void scheduleCaptchaExpired_LRDsOJo$lambda$1(Task this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (OnFailureListener listener2 : this$0.onFailureListeners) {
            listener2.onFailure(new HCaptchaException(HCaptchaError.TOKEN_TIMEOUT, null, 2, null));
        }
    }
}

