/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.util.Utils;
import com.sshtools.server.vsession.CmdLine;
import com.sshtools.server.vsession.Command;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.Environment;
import com.sshtools.server.vsession.LineParser;
import com.sshtools.server.vsession.MshListener;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UnsupportedCommandException;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.commands.Alias;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.ParseException;
import org.jline.reader.Candidate;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class Msh
extends ShellCommand {
    private Throwable lastError;
    private boolean exit;
    private String prompt;
    protected CommandFactory<? extends Command> commandFactory;
    protected Map<Long, Job> runningJobs = new HashMap<Long, Job>();
    private long nextJobId = 1L;
    public static final String LOGIN_CONTEXT = "loginContext";
    private List<MshListener> listeners = new ArrayList<MshListener>();

    public Msh(CommandFactory<? extends Command> commandFactory) {
        super("msh", "Shell", "Usage: msh <script>", "A basic interactive shell for executing commands.");
        this.setBuiltIn(false);
        this.commandFactory = commandFactory;
    }

    public Msh(String name, String subsystem, String usage, String description) {
        super(name, subsystem, usage, description);
        this.setBuiltIn(false);
    }

    public void addListener(MshListener listener) {
        this.listeners.add(listener);
    }

    protected void setCommandFactory(CommandFactory<? extends Command> commandFactory) {
        this.commandFactory = commandFactory;
    }

    public String expandEnvironmentVariables(Environment env, String value, Map<String, String> additionalReplacements) {
        if (Objects.isNull(value)) {
            return value;
        }
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(value);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String attributeName = matcher.group(1);
            if (!env.containsKey(attributeName) && !additionalReplacements.containsKey(attributeName)) {
                Log.debug((String)("Replacement token " + attributeName + " not in list to replace from"), (Object[])new Object[0]);
                continue;
            }
            String replacement = env.containsKey(attributeName) ? env.get(attributeName).toString() : additionalReplacements.get(attributeName);
            builder.append(value.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(value.substring(i, value.length()));
        return builder.toString();
    }

    protected void runShell(VirtualConsole console) throws IOException {
        HashMap<String, String> additionalReplacements = new HashMap<String, String>();
        if (!console.getEnvironment().containsKey("PROMPT")) {
            console.getEnvironment().put("PROMPT", "# ");
        }
        while (!this.exit) {
            this.prompt = (String)console.getEnvironment().get("PROMPT");
            this.prompt = this.expandEnvironmentVariables(console.getEnvironment(), this.prompt, additionalReplacements);
            try {
                String line = console.readLine(this.prompt);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Received: " + line), (Object[])new Object[0]);
                }
                if (line == null) {
                    this.exit = true;
                    continue;
                }
                this.parseLine(line, console);
            }
            catch (InterruptedIOException ie) {
                console.println();
            }
            catch (EndOfFileException eofe) {
                this.exit = true;
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Exiting shell", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException {
        for (MshListener listener : this.listeners) {
            listener.started(args, console);
        }
        try {
            if (args.length <= 1) {
                this.runShell(console);
            } else {
                if ("c".equals(args[1]) && args.length >= 3) {
                    List<String> commandArgs = Arrays.asList(args).subList(1, args.length);
                    this.parseArgs(console, commandArgs);
                } else {
                    this.source(console, console.getCurrentDirectory().resolveFile(args[2]));
                }
                if ("s".equals(args[2]) && args.length >= 3) {
                    try {
                        String line = console.readLine();
                        if (line == null) {
                            this.exit = true;
                        } else {
                            this.parseLine(line, console);
                        }
                        console.clear();
                    }
                    catch (InterruptedIOException ie) {
                        console.println();
                    }
                }
            }
        }
        finally {
            for (MshListener listener : this.listeners) {
                listener.finished(args, console);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void source(VirtualConsole console, AbstractFile file) throws IOException, PermissionDeniedException {
        try (InputStream inputStream = file.getInputStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));){
            String line = null;
            while ((line = r.readLine()) != null) {
                this.parseLine(line, console);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void source(VirtualConsole console, InputStream in) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = r.readLine()) != null) {
                this.parseLine(line, console);
            }
        }
    }

    protected void parseArgs(VirtualConsole console, List<String> lineArgs) throws IOException {
        LineParser lineParser = new LineParser(console.getEnvironment());
        if (lineArgs.size() > 0 && !lineArgs.get(0).startsWith("#")) {
            this.expandAliases(console, lineParser, lineArgs, this.exitCode);
            this.exitCode = this.spawn(console, lineArgs.toArray(new String[0]), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseLine(String line, VirtualConsole console) throws IOException {
        LineParser lineParser = new LineParser(console.getEnvironment());
        if (!(line = line.trim()).startsWith("#") && !line.equals("")) {
            CmdLine lastCommand = null;
            boolean exit = false;
            console.getLineReader().getVariables().put("disable-history", Boolean.TRUE);
            try {
                block6: for (CmdLine l : lineParser.parseCommands(line, this.exitCode)) {
                    if (exit) {
                        break;
                    }
                    switch (lastCommand == null ? 0 : lastCommand.getExitCode()) {
                        case -2147483648: 
                        case 0: {
                            if (lastCommand == null || lastCommand.getCondition() != CmdLine.Condition.ExecNextCommandOnFailure) break;
                            exit = true;
                            continue block6;
                        }
                        default: {
                            if (lastCommand == null || lastCommand.getCondition() != CmdLine.Condition.ExecNextCommandOnSuccess) break;
                            exit = true;
                            continue block6;
                        }
                    }
                    lastCommand = l;
                    this.expandAliases(console, lineParser, l.getArgs(), this.exitCode);
                    this.exitCode = this.spawn(console, l.getArgArray(), l.isBackground());
                    l.setExitCode(this.exitCode);
                }
            }
            finally {
                console.getLineReader().getVariables().remove("disable-history");
            }
        }
    }

    private void expandAliases(VirtualConsole console, LineParser lineParser, List<String> lineArgs, int lastExitCode) {
        String cmd;
        if (lineArgs.size() > 0 && Alias.hasAlias(cmd = lineArgs.get(0), console.getConnection().getUsername())) {
            lineArgs.remove(0);
            lineArgs.addAll(0, lineParser.parse(Alias.getAliasCommand(cmd, console.getConnection().getUsername()), lastExitCode));
        }
    }

    protected int spawn(VirtualConsole console, String[] args, boolean background) throws IOException {
        try {
            return this.doSpawn(console, args, background);
        }
        catch (PermissionDeniedException pde) {
            this.lastError = pde;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Failed to create ShellCommand instance for " + args[0]), (Throwable)pde, (Object[])new Object[0]);
            }
            console.println();
            console.println("You are not allowed to run '" + args[0] + "'.");
            console.println(pde.getMessage());
            console.println();
            return 98;
        }
        catch (UsageException ex) {
            console.println(args[0] + ": usage: " + ex.getMessage());
            return 1;
        }
        catch (ParseException ie) {
            this.lastError = ie;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Failed to parse command line for " + args[0]), (Throwable)ie, (Object[])new Object[0]);
            }
            console.println("The command was recognized but could not run");
            return 1;
        }
        catch (EndOfFileException eofe) {
            this.exit = true;
            return 0;
        }
        catch (UnsupportedCommandException e) {
            console.println(String.format("Unsupported command: %s", args[0]));
            Log.error((String)e.getMessage(), (Object[])new Object[0]);
            return -1;
        }
        catch (Throwable t) {
            this.lastError = t.getCause() != null ? t.getCause() : t;
            Log.error((String)("Failed to run command line " + args[0]), (Throwable)t, (Object[])new Object[0]);
            console.println();
            console.println(this.lastError.getMessage() == null ? this.lastError.getClass().getName() : this.lastError.getMessage());
            return 99;
        }
    }

    protected int doSpawn(VirtualConsole console, String[] args, boolean background) throws UnsupportedCommandException, IllegalAccessException, InstantiationException, ParseException, IOException, PermissionDeniedException, UsageException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Command cmd = args[0].equals("sh") || args[0].equals("msh") ? new Msh(this.commandFactory) : this.commandFactory.createCommand(args[0], console.getConnection());
        if (((ShellPolicy)console.getConnection().getContext().getPolicy(ShellPolicy.class)).checkPermission(console.getConnection(), 8192, new String[]{cmd.getCommandName()})) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Executing command {}", (Object[])new Object[]{Utils.join((String[])args, (String)" ")});
            }
            return this.runCommandWithArgs(args, cmd, console, background);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Cannot execute {}", (Object[])new Object[]{Utils.join((String[])args, (String)" ")});
        }
        throw new SecurityException("You are not allowed to run the command " + cmd.getCommandName() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runCommandWithArgs(String[] args, Command cmd, VirtualConsole console, boolean background) throws ParseException, IOException, PermissionDeniedException, UsageException {
        if (!((ShellPolicy)console.getContext().getPolicy(ShellPolicy.class)).checkPermission(console.getConnection(), 8192, new String[]{cmd.getCommandName()})) {
            throw new PermissionDeniedException("Permission denied. Cannot execute " + cmd.getCommandName());
        }
        if (background) {
            if (this.runningJobs.size() == 0) {
                this.nextJobId = 1L;
            }
            Job job = new Job(this.nextJobId++, cmd, args, console);
            this.runningJobs.put(job.getJobId(), job);
            console.println("[" + job.getJobId() + "] ");
            job.start();
            return 0;
        }
        for (MshListener listener : this.listeners) {
            listener.commandStarted(cmd, args, console);
        }
        try {
            cmd.run(args, console);
        }
        catch (UsageException e) {
            console.println();
            console.println(cmd.getUsage());
        }
        finally {
            for (MshListener listener : this.listeners) {
                listener.commandFinished(cmd, args, console);
            }
        }
        return cmd.getExitCode();
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void exit() {
        this.exit = true;
    }

    public CommandFactory<? extends Command> getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
    }

    public void killProcess(long pid) {
        if (this.runningJobs.containsKey(pid)) {
            this.runningJobs.get(pid).interrupt();
        }
    }

    class Job
    extends Thread {
        long id;
        Command cmd;
        boolean running = true;
        String[] args;
        VirtualConsole console;
        Throwable lastError;

        Job(long id, Command cmd, String[] args, VirtualConsole console) {
            this.id = id;
            this.cmd = cmd;
            this.args = args;
            this.console = console;
        }

        @Override
        public void run() {
            for (MshListener listener : Msh.this.listeners) {
                listener.commandStarted(this.cmd, this.args, this.console);
            }
            try {
                this.cmd.run(this.args, this.console);
            }
            catch (Throwable t) {
                this.lastError = t;
            }
            finally {
                for (MshListener listener : Msh.this.listeners) {
                    listener.commandFinished(this.cmd, this.args, this.console);
                }
            }
            this.running = false;
            Msh.this.runningJobs.remove(this.id);
        }

        boolean isRunning() {
            return this.running;
        }

        long getJobId() {
            return this.id;
        }

        int getExitCode() {
            return this.cmd.getExitCode();
        }
    }
}

