/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.client.SshClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.CommandArgumentsParser;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientHelper;
import com.sshtools.vsession.commands.ssh.SshClientOptionsExtractor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public abstract class AbstractSshClientCommand
extends ShellCommand {
    private String[] originalArguments = null;
    protected Options options = new Options();
    protected VirtualConsole console;

    public AbstractSshClientCommand(String name, String subsystem, String signature, String description) {
        super(name, subsystem, signature, description);
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getUsage() {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), "ssh", "", this.getOptions(), formatter.getLeftPadding(), formatter.getDescPadding(), "");
        pw.flush();
        String result = out.toString();
        return result;
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        this.console = console;
        String[] filteredArgs = this.filterArgs(args);
        CommandLine cli = CommandArgumentsParser.parse(this.getOptions(), filteredArgs, this.getUsage());
        SshClientArguments arguments = this.generateCommandArguments(cli, this.originalArguments);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"The arguments parsed are {}", (Object[])new Object[]{arguments});
        }
        try (SshClient sshClient = null;){
            sshClient = SshClientHelper.connectClient(arguments, console);
            this.runCommand(sshClient, arguments, console);
        }
    }

    protected abstract void runCommand(SshClient var1, SshClientArguments var2, VirtualConsole var3);

    protected abstract SshClientArguments generateCommandArguments(CommandLine var1, String[] var2) throws IOException, PermissionDeniedException;

    protected String[] filterArgs(String[] args) {
        this.originalArguments = args;
        int indexTillSshClientCommandFound = SshClientOptionsExtractor.extractSshCommandLineFromExecuteCommand(args);
        return Arrays.copyOfRange(args, 0, indexTillSshClientCommandFound + 1);
    }
}

