/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.server.vsession.UsageException;
import java.util.Objects;

public class CliHelper {
    public static boolean hasOption(String[] args, char shortOpt, String longOpt) {
        return CliHelper.hasShortOption(args, shortOpt) || CliHelper.hasLongOption(args, longOpt);
    }

    public static String getValue(String[] args, char shortOpt, String longOpt) throws UsageException {
        return CliHelper.getValue(args, shortOpt, longOpt, null);
    }

    public static String getValue(String[] args, char shortOpt, String longOpt, String defaultValue) throws UsageException {
        if (CliHelper.hasShortOption(args, shortOpt)) {
            return CliHelper.getShortValue(args, shortOpt);
        }
        if (CliHelper.hasLongOption(args, longOpt)) {
            return CliHelper.getLongValue(args, longOpt);
        }
        if (Objects.isNull(defaultValue)) {
            throw new UsageException(String.format("Missing -%c or --%s option", Character.valueOf(shortOpt), longOpt));
        }
        return defaultValue;
    }

    public static boolean hasShortOption(String[] args, char opt) {
        for (String arg : args) {
            if (!arg.startsWith("-") || arg.startsWith("--") || arg.length() != 2 || arg.indexOf(opt) != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLongOption(String[] args, String opt) {
        while (!opt.startsWith("--")) {
            opt = "-" + opt;
        }
        for (String arg : args) {
            if (!arg.equals(opt)) continue;
            return true;
        }
        return false;
    }

    public static String getLongValue(String[] args, String opt) throws UsageException {
        while (!opt.startsWith("--")) {
            opt = "-" + opt;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--") || !arg.equals(opt)) continue;
            if (args.length > i + 1) {
                return args[i + 1];
            }
            throw new UsageException("Missing value for long option " + opt);
        }
        throw new UsageException("Missing long option " + opt);
    }

    public static String getShortValue(String[] args, char opt) throws UsageException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-") || arg.startsWith("--") || arg.length() != 2 || arg.indexOf(opt) != 1) continue;
            if (args.length > i + 1) {
                return args[i + 1];
            }
            throw new UsageException("Missing value for option " + opt);
        }
        throw new UsageException("Missing option " + opt);
    }

    public static boolean isOption(String opt, String shortOptions) {
        if (opt.startsWith("--")) {
            return shortOptions.contains(opt.substring(2));
        }
        if (opt.startsWith("-")) {
            return shortOptions.contains(opt.substring(1));
        }
        return false;
    }
}

