/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualFileObject;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VirtualMountFile
extends VirtualFileObject {
    private String name;
    private String path;
    private AbstractFile file;
    Map<String, AbstractFile> cachedChildren;

    public VirtualMountFile(String path, VirtualMount mount, VirtualFileFactory fileFactory) throws PermissionDeniedException, IOException {
        super(fileFactory, mount);
        int idx = path.lastIndexOf(47);
        this.name = idx > -1 ? path.substring(idx + 1) : path;
        this.path = path;
    }

    public boolean isMount() {
        return FileUtils.addTrailingSlash((String)this.parentMount.getMount()).equals(FileUtils.addTrailingSlash((String)this.path));
    }

    private AbstractFile resolveFile() throws PermissionDeniedException, IOException {
        if (Objects.nonNull(this.file)) {
            return this.file;
        }
        this.file = this.parentMount.getActualFileFactory().getFile(this.parentMount.getResolvePath(this.path));
        return this.file;
    }

    public boolean exists() throws IOException, PermissionDeniedException {
        return this.isMount() || this.resolveFile().exists();
    }

    public boolean createFolder() throws PermissionDeniedException, IOException {
        if (this.isMount()) {
            return false;
        }
        return this.resolveFile().createFolder();
    }

    public long lastModified() throws IOException, PermissionDeniedException {
        if (this.isMount()) {
            return this.parentMount.lastModified();
        }
        return this.resolveFile().lastModified();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException, PermissionDeniedException {
        if (this.isMount()) {
            return 0L;
        }
        return this.resolveFile().length();
    }

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException {
        if (this.isMount()) {
            SftpFileAttributes attrs = new SftpFileAttributes(2, "UTF-8");
            attrs.setPermissions(this.parentMount.defaultPermissions());
            try {
                attrs.setReadOnly(this.parentMount.isReadOnly());
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
            attrs.setTimes(new UnsignedInteger64(this.parentMount.lastModified()), new UnsignedInteger64(this.parentMount.lastModified()), new UnsignedInteger64(this.parentMount.lastModified()));
            return attrs;
        }
        return this.resolveFile().getAttributes();
    }

    public boolean isHidden() throws IOException, PermissionDeniedException {
        if (this.isMount()) {
            return false;
        }
        return this.resolveFile().isHidden();
    }

    public boolean isDirectory() throws IOException, PermissionDeniedException {
        return this.isMount() || this.resolveFile().isDirectory();
    }

    public synchronized List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cachedChildren)) {
            HashMap<String, AbstractFile> files = new HashMap<String, AbstractFile>(this.getVirtualMounts());
            String currentPath = FileUtils.checkEndsWithSlash((String)this.path);
            VirtualMountManager mgr = this.fileFactory.getMountManager();
            AbstractFile file = this.resolveFile();
            if (file.exists()) {
                VirtualMount actualMount = mgr.getMount(currentPath);
                for (AbstractFile child : file.getChildren()) {
                    files.put(currentPath + child.getName(), new VirtualMountFile(currentPath + child.getName(), actualMount, this.fileFactory));
                }
            }
            this.cachedChildren = files;
        }
        return new ArrayList<AbstractFile>(this.cachedChildren.values());
    }

    public boolean isFile() throws IOException, PermissionDeniedException {
        return !this.isMount() && this.resolveFile().isFile();
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public InputStream getInputStream() throws IOException, PermissionDeniedException {
        if (this.isDirectory()) {
            throw new IOException("No I/O stream supported on non-file");
        }
        return this.resolveFile().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        if (this.isDirectory()) {
            throw new IOException("No I/O stream supported on non-file");
        }
        return this.resolveFile().getOutputStream();
    }

    public boolean isReadable() throws IOException, PermissionDeniedException {
        return this.isMount() || this.resolveFile().isReadable();
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        this.resolveFile().copyFrom(src);
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        this.resolveFile().moveTo(target);
    }

    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        return !this.isMount() && this.resolveFile().delete(recursive);
    }

    @Override
    public synchronized void refresh() {
        try {
            this.cachedChildren = null;
            super.refresh();
            this.resolveFile().refresh();
        }
        catch (PermissionDeniedException | IOException throwable) {
            // empty catch block
        }
    }

    public boolean isWritable() throws IOException, PermissionDeniedException {
        return !this.parentMount.isReadOnly() || this.resolveFile().isWritable();
    }

    public boolean createNewFile() throws PermissionDeniedException, IOException {
        return !this.isMount() && this.resolveFile().createNewFile();
    }

    public void truncate() throws PermissionDeniedException, IOException {
        if (!this.isMount()) {
            this.resolveFile().truncate();
        }
    }

    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        this.file.setAttributes(attrs);
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.path;
    }

    public boolean supportsRandomAccess() {
        try {
            return !this.isMount() && this.resolveFile().supportsRandomAccess();
        }
        catch (PermissionDeniedException | IOException e) {
            return false;
        }
    }

    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException, PermissionDeniedException {
        return this.resolveFile().openFile(writeAccess);
    }

    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        if (this.isDirectory()) {
            throw new IOException("No I/O stream supported on non-file");
        }
        return this.resolveFile().getOutputStream(append);
    }

    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        if (child.startsWith("/")) {
            return this.fileFactory.getFile(child);
        }
        return this.fileFactory.getFile(this.path + (this.path.equals("/") || this.path.endsWith("/") ? "" : "/") + child);
    }

    public AbstractFileFactory<VirtualFile> getFileFactory() {
        return this.parentMount.getVirtualFileFactory();
    }

    public int hashCode() {
        return Objects.hash(this.parentMount, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMountFile other = (VirtualMountFile)this.getClass().cast(obj);
        return Objects.equals(other.path, this.path) && Objects.equals(other.parentMount, this.parentMount);
    }

    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        if (this.isMount()) {
            throw new PermissionDeniedException("Cannot symlink a mount");
        }
        this.resolveFile().symlinkTo(target);
    }

    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        if (this.isMount()) {
            return this.getAbsolutePath();
        }
        return this.resolveFile().readSymbolicLink();
    }
}

