/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileAdapter;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountFile;
import com.sshtools.common.files.vfs.VirtualMountManager;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VirtualMappedFile
extends AbstractFileAdapter
implements VirtualFile {
    private VirtualMount parentMount;
    private VirtualFileFactory fileFactory;
    private String absolutePath;
    private String name;

    public VirtualMappedFile(String path, VirtualMount parentMount, VirtualFileFactory fileFactory) throws IOException, PermissionDeniedException {
        this.parentMount = parentMount;
        this.fileFactory = fileFactory;
        this.toActualPath(path);
        this.init(parentMount.getActualFileFactory().getFile(this.toActualPath(path)));
        this.absolutePath = this.toVirtualPath(super.getAbsolutePath());
        int idx = this.absolutePath.lastIndexOf("/");
        this.name = this.absolutePath.substring(idx + 1);
    }

    VirtualMappedFile(AbstractFile actualFile, VirtualMount parentMount, VirtualFileFactory fileFactory) throws IOException, PermissionDeniedException {
        this.parentMount = parentMount;
        this.fileFactory = fileFactory;
        this.init(actualFile);
        this.absolutePath = this.toVirtualPath(super.getAbsolutePath());
        int idx = this.absolutePath.lastIndexOf("/");
        this.name = this.absolutePath.substring(idx + 1);
    }

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        VirtualMountManager mgr = this.fileFactory.getMountManager();
        if (this.absolutePath.equals("/")) {
            for (VirtualMount m : mgr.getMounts()) {
                if (m.isFilesystemRoot()) continue;
                String child = m.getMount().substring(1);
                if (child.indexOf(47) > -1) {
                    child = child.substring(0, child.indexOf(47));
                }
                files.add(new VirtualMountFile(this.absolutePath + child, m, this.fileFactory));
            }
            for (AbstractFile f : super.getChildren()) {
                VirtualMappedFile f2 = new VirtualMappedFile(f, this.parentMount, this.fileFactory);
                if (mgr.isMounted(f2.getAbsolutePath())) continue;
                files.add(f2);
            }
        } else {
            for (AbstractFile f : super.getChildren()) {
                files.add(new VirtualMappedFile(f, this.parentMount, this.fileFactory));
            }
        }
        return files;
    }

    public AbstractFile getMappedFile() {
        return this.file;
    }

    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.absolutePath;
    }

    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        return this.toVirtualPath(super.getAbsolutePath());
    }

    public String getName() {
        return this.name;
    }

    private String toVirtualPath(String actualPath) throws IOException, FileNotFoundException, PermissionDeniedException {
        if ((actualPath = actualPath.replace('\\', '/')).startsWith("./")) {
            actualPath = actualPath.substring(2);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Translating Actual: {}", (Object[])new Object[]{actualPath});
        }
        actualPath = this.translateCanonicalPath(actualPath, this.parentMount.getRoot());
        String parent = this.translateCanonicalPath(this.parentMount.getRoot(), this.parentMount.getRoot());
        int idx = actualPath.indexOf(parent);
        String relative = actualPath.substring(idx + parent.length());
        String virtualPath = FileUtils.addTrailingSlash((String)this.parentMount.getMount()) + FileUtils.removeStartingSlash((String)relative);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Translate Success: {}", (Object[])new Object[]{virtualPath});
        }
        return virtualPath.equals("/") ? virtualPath : FileUtils.removeTrailingSlash((String)virtualPath);
    }

    public AbstractFile resolveFile(String child) throws PermissionDeniedException, IOException {
        if (child.startsWith("/")) {
            return this.fileFactory.getFile(child);
        }
        return this.fileFactory.getFile(FileUtils.addTrailingSlash((String)this.absolutePath) + child);
    }

    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        if (src instanceof VirtualMappedFile) {
            super.copyFrom(((VirtualMappedFile)src).file);
        } else {
            super.copyFrom(src);
        }
    }

    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        if (target instanceof VirtualMappedFile) {
            super.moveTo(((VirtualMappedFile)target).file);
        } else {
            super.moveTo(target);
        }
    }

    private String toActualPath(String virtualPath) throws IOException, FileNotFoundException, PermissionDeniedException {
        if (virtualPath.equals("")) {
            virtualPath = this.parentMount.getMount();
        } else if (virtualPath.startsWith("./")) {
            virtualPath = virtualPath.replaceFirst("./", FileUtils.addTrailingSlash((String)this.parentMount.getMount()));
        } else if (!virtualPath.startsWith("/")) {
            virtualPath = FileUtils.addTrailingSlash((String)this.parentMount.getMount()) + virtualPath;
        }
        String str = virtualPath.length() > this.parentMount.getMount().length() ? FileUtils.addTrailingSlash((String)this.parentMount.getRoot()) + virtualPath.substring(this.parentMount.getMount().length()) : this.parentMount.getRoot();
        return this.translateCanonicalPath(str, this.parentMount.getRoot());
    }

    protected String translateCanonicalPath(String path, String securemount) throws FileNotFoundException, IOException, PermissionDeniedException {
        try {
            String canonical2;
            if (Log.isTraceEnabled()) {
                Log.trace((String)"     Translating Canonical: {}", (Object[])new Object[]{path});
                Log.trace((String)"                     Mount: {} ", (Object[])new Object[]{securemount});
            }
            boolean containsDotDot = path.indexOf("..") > -1 || path.indexOf(46) > -1;
            AbstractFile f = this.parentMount.getActualFileFactory().getFile(path);
            String canonical = containsDotDot ? f.getCanonicalPath().replace('\\', '/') : f.getAbsolutePath().replace('\\', '/');
            AbstractFile f2 = this.parentMount.getActualFileFactory().getFile(securemount);
            String string = canonical2 = containsDotDot ? f2.getCanonicalPath().replace('\\', '/') : f2.getAbsolutePath().replace('\\', '/');
            if (!canonical2.endsWith("/")) {
                canonical2 = canonical2 + "/";
            }
            if (!canonical.endsWith("/")) {
                canonical = canonical + "/";
            }
            if (canonical.startsWith(canonical2)) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"          Translate Success: {}", (Object[])new Object[]{FileUtils.removeTrailingSlash((String)canonical)});
                }
                return FileUtils.removeTrailingSlash((String)canonical);
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)"          Translate Failed: {}", (Object[])new Object[]{FileUtils.removeTrailingSlash((String)canonical)});
            }
            throw new FileNotFoundException("Path " + path + " could not be found");
        }
        catch (IOException ex) {
            Log.debug((String)ex.getMessage(), (Throwable)ex, (Object[])new Object[0]);
            throw new FileNotFoundException("Path " + path + " could not be found");
        }
    }

    public int hashCode() {
        return Objects.hash(this.parentMount, this.absolutePath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMappedFile other = (VirtualMappedFile)this.getClass().cast(obj);
        return Objects.equals(other.absolutePath, this.absolutePath) && Objects.equals(other.parentMount, this.parentMount);
    }
}

