/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.PathFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.IOException;
import java.nio.file.Path;

public class PathFileFactory
implements AbstractFileFactory<PathFile> {
    private Path base;

    public PathFileFactory(Path base) {
        this.base = base;
    }

    public PathFile getFile(String path) throws PermissionDeniedException, IOException {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Resolving path '{}' in '{}'", (Object[])new Object[]{path, this.base});
        }
        if (!path.toString().startsWith(this.base.toString())) {
            throw new IllegalStateException(String.format("Path '%s' requested is not a child of '%s'", path, this.base));
        }
        path = path.substring(this.base.toString().length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Path p = path.equals("") ? this.base : this.base.resolve(path);
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Resolved path '{}' as '{}' in '{}'", (Object[])new Object[]{path, p, this.base});
        }
        return new PathFile(p, this);
    }

    public Event populateEvent(Event evt) {
        return evt;
    }

    public PathFile getDefaultPath() throws PermissionDeniedException, IOException {
        return this.getFile("/");
    }
}

