/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class MutualCallbackAuthenticator
extends SimpleClientAuthenticator {
    public static final int SSH_MSG_USERAUTH_SIGNED_CHALLENGE = 60;
    public static final String MUTUAL_KEY_AUTHENTICATION = "mutual-key-auth@sshtools.com";
    TransportProtocolClient transport;
    String username;
    byte[] ourChallenge;
    MutualKeyAuthenticatonStore authenticationStore;

    public MutualCallbackAuthenticator(MutualKeyAuthenticatonStore authenticationStore) {
        this.authenticationStore = authenticationStore;
    }

    public String getName() {
        return MUTUAL_KEY_AUTHENTICATION;
    }

    public void authenticate(TransportProtocolClient transport, String username) throws IOException, SshException {
        this.transport = transport;
        this.username = username;
        transport.addOutgoingTask((ConnectionAwareTask)new InitialChallenge((SshConnection)transport.getConnection()));
    }

    public boolean processMessage(ByteArrayReader msg) throws IOException {
        if (msg.read() != 60) {
            return false;
        }
        this.transport.addOutgoingTask((ConnectionAwareTask)new ProcessChallengeResponse((SshConnection)this.transport.getConnection(), msg));
        return true;
    }

    class InitialChallenge
    extends ConnectionAwareTask {
        public InitialChallenge(SshConnection con) {
            super(con);
        }

        public void doTask() {
            try {
                final byte[] msg = this.generateAuthenticationRequest();
                MutualCallbackAuthenticator.this.transport.postMessage((SshMessage)new AuthenticationMessage(MutualCallbackAuthenticator.this.username, "ssh-connection", MutualCallbackAuthenticator.MUTUAL_KEY_AUTHENTICATION){

                    public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                        super.writeMessageIntoBuffer(buf);
                        buf.put(msg);
                        return true;
                    }
                });
            }
            catch (Throwable e) {
                MutualCallbackAuthenticator.this.failure();
                MutualCallbackAuthenticator.this.transport.disconnect(11, "Internal error");
            }
        }

        byte[] generateAuthenticationRequest() throws IOException, SshException, NoSuchAlgorithmException {
            try (ByteArrayWriter baw = new ByteArrayWriter();){
                MutualCallbackAuthenticator.this.ourChallenge = new byte[512];
                JCEComponentManager.getSecureRandom().nextBytes(MutualCallbackAuthenticator.this.ourChallenge);
                baw.writeBinaryString(MutualCallbackAuthenticator.this.ourChallenge);
                byte[] byArray = baw.toByteArray();
                return byArray;
            }
        }
    }

    class ProcessChallengeResponse
    extends ConnectionAwareTask {
        ByteArrayReader msg;

        public ProcessChallengeResponse(SshConnection con, ByteArrayReader msg) {
            super(con);
            this.msg = msg;
        }

        protected void doTask() throws Throwable {
            byte[] signature = this.msg.readBinaryString();
            byte[] theirChallenge = this.msg.readBinaryString();
            try (ByteArrayWriter writer = new ByteArrayWriter();){
                writer.writeBinaryString(MutualCallbackAuthenticator.this.ourChallenge);
                writer.writeString(MutualCallbackAuthenticator.this.username);
                writer.writeBinaryString(MutualCallbackAuthenticator.this.transport.getSessionKey());
                SshPublicKey remotePublicKey = MutualCallbackAuthenticator.this.authenticationStore.getPublicKey(this.con);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Mutual authentication is using the remote key {}", (Object[])new Object[]{SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)remotePublicKey)});
                }
                if (Objects.isNull(remotePublicKey)) {
                    MutualCallbackAuthenticator.this.failure();
                    MutualCallbackAuthenticator.this.transport.disconnect(13, "There was no public key configured for the user");
                    return;
                }
                if (!remotePublicKey.verifySignature(signature, writer.toByteArray())) {
                    MutualCallbackAuthenticator.this.failure();
                    MutualCallbackAuthenticator.this.transport.disconnect(13, "Failed to verify remote public key signature");
                    return;
                }
                writer.reset();
                writer.writeBinaryString(theirChallenge);
                writer.writeString(MutualCallbackAuthenticator.this.username);
                writer.writeBinaryString(MutualCallbackAuthenticator.this.transport.getSessionKey());
                SshKeyPair localPrivateKey = MutualCallbackAuthenticator.this.authenticationStore.getPrivateKey(this.con);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Mutual authentication is using the local key {}", (Object[])new Object[]{SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)localPrivateKey.getPublicKey())});
                }
                final byte[] signature2 = localPrivateKey.getPrivateKey().sign(writer.toByteArray());
                MutualCallbackAuthenticator.this.transport.postMessage(new SshMessage(){

                    public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                        buf.put((byte)60);
                        buf.putInt(signature2.length);
                        buf.put(signature2);
                        return true;
                    }

                    public void messageSent(Long sequenceNo) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Sent SSH_MSG_USERAUTH_SIGNED_CHALLENGE", (Object[])new Object[0]);
                        }
                    }
                });
            }
        }
    }
}

