/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.util.Date;

class TransportProtocolSwitchingClient
extends TransportProtocolClient {
    ProtocolContextFactory<SshServerContext> serverFactory;
    String callbackIdentifier;
    ConnectRequestFuture connectFuture;

    public TransportProtocolSwitchingClient(SshClientContext sshContext, String callbackIdentifier, ProtocolContextFactory<SshServerContext> serverFactory, ConnectRequestFuture connectFuture) throws LicenseException {
        super(sshContext, connectFuture);
        this.serverFactory = serverFactory;
        this.callbackIdentifier = callbackIdentifier;
        this.connectFuture = connectFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRemoteIdentificationReceived(String remoteIdentification) {
        if (!remoteIdentification.startsWith("SSH-2.0-" + this.callbackIdentifier)) {
            try {
                SshServerContext context = (SshServerContext)this.serverFactory.createContext(((SshClientContext)this.sshContext).getDaemonContext(), this.getSocketConnection().getSocketChannel());
                TransportProtocolServer engine = (TransportProtocolServer)context.createEngine(this.connectFuture);
                this.transferState((TransportProtocol)engine);
                this.getSocketConnection().setProtocolEngine((ProtocolEngine)engine);
            }
            catch (Exception e) {
                Log.error((String)"Failed to switch roles", (Throwable)e, (Object[])new Object[0]);
                this.socketConnection.closeConnection(true);
            }
            finally {
                ((SshClientContext)this.getContext()).getConnectionManager().unregisterTransport((TransportProtocol)this);
            }
        } else {
            int idx = remoteIdentification.indexOf(95);
            if (idx > -1) {
                if (remoteIdentification.trim().length() > idx + 1) {
                    String username = remoteIdentification.substring(idx + 1).trim();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Callback client username is {}", (Object[])new Object[]{username});
                    }
                    ((SshClientContext)this.getContext()).setUsername(username);
                    this.generateCallbackEvent(username);
                    return;
                }
            } else {
                int length = "SSH-2.0-".length() + this.callbackIdentifier.length();
                String username = remoteIdentification.substring(length + 1).trim();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Callback client username is {}", (Object[])new Object[]{username});
                }
                ((SshClientContext)this.getContext()).setUsername(username);
                this.generateCallbackEvent(username);
                return;
            }
            throw new IllegalStateException(String.format("Callback identifier missing _ or username token [%s]", remoteIdentification.trim()));
        }
    }

    private void generateCallbackEvent(String username) {
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777205, true).addAttribute("CONNECTION", (Object)this.con).addAttribute("OP_STARTED", (Object)new Date()).addAttribute("OP_FINISHED", (Object)new Date()));
    }
}

