/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback;

import com.sshtools.common.auth.InMemoryMutualKeyAuthenticationStore;
import com.sshtools.common.auth.MutualKeyAuthenticatonStore;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.VFSFileFactory;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.files.vfs.VirtualMountTemplate;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileFactory;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.server.AbstractSshServer;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.callback.CallbackContextFactory;
import com.sshtools.server.callback.InMemoryCallbackRegistrationService;
import com.sshtools.server.callback.commands.CallbackCommandFactory;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.VirtualChannelFactory;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.vsession.commands.ssh.SshClientsCommandFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CallbackServer
extends AbstractSshServer {
    InMemoryMutualKeyAuthenticationStore store = new InMemoryMutualKeyAuthenticationStore();
    InMemoryCallbackRegistrationService callbacks = new InMemoryCallbackRegistrationService();

    public CallbackServer() {
    }

    public CallbackServer(InetAddress addressToBind, int port) {
        super(addressToBind, port);
    }

    public CallbackServer(int port) throws UnknownHostException {
        super(port);
    }

    public CallbackServer(String addressToBind, int port) throws UnknownHostException {
        super(addressToBind, port);
    }

    public ProtocolContextFactory<?> getDefaultContextFactory() {
        return new CallbackContextFactory((MutualKeyAuthenticatonStore)this.store, this.callbacks, this);
    }

    public FileFactory getFileFactory() {
        return new FileFactory(){

            public AbstractFileFactory<?> getFileFactory(SshConnection con) throws IOException, PermissionDeniedException {
                return new VirtualFileFactory(new VirtualMountTemplate("/", "ram://" + con.getUsername(), (AbstractFileFactory)new VFSFileFactory(), true), new VirtualMountTemplate[0]);
            }
        };
    }

    public ChannelFactory<SshServerContext> getChannelFactory() {
        return new VirtualChannelFactory(new CommandFactory[]{new CallbackCommandFactory(this.callbacks), new SshClientsCommandFactory()});
    }

    public void addAgentKey(String username, SshKeyPair privateKey, SshPublicKey publicKey) {
        this.store.addKey(username, privateKey, publicKey);
    }
}

