/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.callback.commands;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.ShellTask;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.callback.commands.CallbackCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class CallbackShell
extends CallbackCommand {
    public CallbackShell() {
        super("shell", "Callback", "shell <name>", "Open a shell to a named callback client");
    }

    public void run(String[] args, final VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        if (args.length != 2) {
            throw new UsageException("Invalid number of arguments");
        }
        String clientName = args[1];
        SshConnection con = this.server.getCallbackClient(clientName);
        if (Objects.isNull(con)) {
            console.println(String.format("%s is not currently connected", clientName));
            return;
        }
        console.println(String.format("---- Opening shell on %s", clientName));
        console.println();
        ShellTask shell = new ShellTask(con){

            protected void beforeStartShell(SessionChannelNG session) {
                session.allocatePseudoTerminal(console.getTerminal().getType(), console.getTerminal().getWidth(), console.getTerminal().getHeight());
            }

            protected void onOpenSession(final SessionChannelNG session) throws IOException, SshException, ShellTimeoutException {
                console.getSessionChannel().enableRawMode();
                this.con.addTask(new ConnectionAwareTask(this.con){

                    protected void doTask() throws Throwable {
                        IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream());
                    }
                });
                IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
            }
        };
        con.addTask((ConnectionAwareTask)shell);
        shell.waitForever();
        console.getSessionChannel().disableRawMode();
        console.println();
        console.println(String.format("---- Exited shell on %s", clientName));
    }
}

