/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.util.HashMap;
import java.util.Map;

public class CallbackConfiguration {
    public static final String DEFAULT_CALLBACK_ID = "CallbackClient";
    private String agentName;
    private String serverHost;
    private int serverPort = 22;
    private Long reconnectIntervalMs;
    private SshKeyPair privateKey;
    private SshPublicKey publicKey;
    private String memo;
    private String callbackIdentifier = "CallbackClient";
    private boolean reconnect = true;
    private long connectTimeout = 5000L;
    Map<String, Object> properties = new HashMap<String, Object>();

    public CallbackConfiguration(String agentName, String serverHost, int serverPort, Long reconnectIntervalMs, Long connectTimeoutMs, SshKeyPair privateKey, SshPublicKey publicKey, String memo) {
        this.agentName = agentName;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.memo = memo;
        this.connectTimeout = connectTimeoutMs;
        this.reconnectIntervalMs = reconnectIntervalMs;
    }

    protected CallbackConfiguration() {
    }

    public CallbackConfiguration setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public Long getReconnectIntervalMs() {
        return this.reconnectIntervalMs == null ? 5000L : this.reconnectIntervalMs;
    }

    public void setReconnectIntervalMs(Long reconnectIntervalMs) {
        this.reconnectIntervalMs = reconnectIntervalMs;
    }

    public SshKeyPair getPrivateKey() {
        return this.privateKey;
    }

    public SshPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCallbackIdentifier() {
        return this.callbackIdentifier;
    }

    public void setCallbackIdentifier(String callbackIdentifier) {
        this.callbackIdentifier = callbackIdentifier;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

