/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.callback.client.CallbackClient;
import com.sshtools.callback.client.CallbackConfiguration;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DisconnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CallbackSession
implements Runnable {
    private final CallbackClient app;
    private final String hostname;
    private final int port;
    private CallbackConfiguration config;
    private ConnectRequestFuture future;
    private boolean isStopped = false;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long reconnectStartedAt = -1L;
    private Throwable exception;
    private Connection<?> con;

    public CallbackSession(CallbackConfiguration config, CallbackClient app, String hostname, int port) throws IOException {
        this.config = config;
        this.app = app;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void run() {
        while (this.app.getSshEngine().isStarted()) {
            if (this.isStopped) {
                Log.info((String)"Callback to {}:{} has been stopped", (Object[])new Object[]{this.hostname, this.port});
                break;
            }
            try {
                this.connect();
            }
            catch (SshException | IOException e) {
                this.exception = e;
                Log.error((String)"Connection failed to {}:{}", (Object[])new Object[]{this.hostname, this.port});
            }
            if (Log.isInfoEnabled()) {
                Log.info((String)"Connection disconnected from {}:{}", (Object[])new Object[]{this.hostname, this.port});
            }
            if (!this.config.isReconnect()) break;
            this.reconnectStartedAt = System.currentTimeMillis();
            try {
                long interval = this.config.getReconnectIntervalMs();
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Will reconnect to {}:{} in {} seconds", (Object[])new Object[]{this.hostname, this.port, interval / 1000L});
                }
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.reconnectStartedAt = -1L;
            }
        }
    }

    public Throwable getLastError() {
        return this.exception;
    }

    public long getTimeRemainingUntilReconnect() {
        if (this.reconnectStartedAt == -1L) {
            return -1L;
        }
        return Math.min(this.config.getReconnectIntervalMs(), Math.max(0L, this.config.getReconnectIntervalMs() - (System.currentTimeMillis() - this.reconnectStartedAt)));
    }

    public void updateMemo(String memo) throws IOException {
        GlobalRequest req = new GlobalRequest("memo@jadaptive.com", this.con, ByteArrayWriter.encodeString((String)this.config.getMemo()));
        this.con.sendGlobalRequest(req, false);
    }

    public void connect() throws IOException, SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Connecting to {}:{}", (Object[])new Object[]{this.hostname, this.port});
        }
        this.future = this.app.getSshEngine().connect(this.hostname, this.port, this.createContext(this.config));
        this.future.waitFor(30000L);
        if (this.future.isDone() && this.future.isSuccess()) {
            this.con = this.future.getConnection();
            if (!this.con.isConnected() || this.con.isDisconnecting()) {
                Throwable exception = this.app.getSshEngine().getLastError();
                if (exception == null) {
                    throw new IOException("Failed to connect.");
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof SshException) {
                    throw (SshException)exception;
                }
                throw new IOException("Failed to connect.", exception);
            }
            this.con.setProperty("callbackClient", (Object)this);
            this.con.getAuthenticatedFuture().waitFor(30000L);
            if (this.con.getAuthenticatedFuture().isDone() && this.con.getAuthenticatedFuture().isSuccess()) {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Callback {} registering with memo {}", (Object[])new Object[]{this.con.getUUID(), this.config.getMemo()});
                }
                this.updateMemo(this.config.getMemo());
                this.app.onClientConnected(this, (SshConnection)this.con);
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Client is connected to {}:{}", (Object[])new Object[]{this.hostname, this.port});
                }
                this.exception = null;
                this.con.getDisconnectFuture().waitForever();
            } else {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Could not authenticate to {}:{}", (Object[])new Object[]{this.hostname, this.port});
                }
                this.exception = new IOException("Authentication failed.");
                this.con.disconnect();
            }
            this.app.onClientStop(this, (SshConnection)this.con);
            this.con.removeProperty("callbackClient");
            this.app.getClients().remove(this);
        }
    }

    protected ProtocolContext createContext(CallbackConfiguration config) throws IOException, SshException {
        return this.app.createContext(this.app.getSshEngine().getContext(), config);
    }

    public void disconnect() {
        if (this.future.isDone() && this.future.isSuccess()) {
            this.future.getTransport().disconnect(11, "The user disconnected.");
        }
    }

    public DisconnectRequestFuture stop() {
        this.isStopped = true;
        this.disconnect();
        return this.future.getTransport().getDisconnectFuture();
    }

    public String getName() {
        return this.config.getAgentName() + "@" + this.config.getServerHost();
    }

    public CallbackConfiguration getConfig() {
        return this.config;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setConfig(CallbackConfiguration config) {
        this.config = config;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object val) {
        this.attributes.put(key, val);
    }
}

